<?php

	#  
	define("DOC_ENCODING", "windows-1251");
	
	################################################################################
#                                                                              #
# MD4 pure PHP edition by DKameleon (http://dkameleon.com)                     #
#                                                                              #
# A PHP implementation of the RSA Data Security, Inc. MD4 Message              #
# Digest Algorithm, as defined in RFC 1320.                                    #
# Based on JavaScript realization taken from: http://pajhome.org.uk/crypt/md5/ #
#                                                                              #
# Updates and new versions: http://my-tools.net/md4php/                        #
#                                                                              #
# History of changes:                                                          #
# 2007.04.06                                                                   #
# - initial release                                                            #
# 2007.04.15                                                                   #
# - fixed safe_add function                                                    #
# 2007.08.26                                                                   #
# - changed code to single class implementation                                #
# - changed safe_add function a little                                         #
# - added self test function                                                   #
# 2009.01.16                                                                   #
# - added some optimizations suggested (by Alex Polushin)                      #
#                                                                              #
################################################################################

# MD4 class
class MD4 {

	var $mode = 0; // safe_add mode. got one report about optimization


	function MD4($selftest = true) {
		if ($selftest) { $this->SelfTest(); }
	}


	function SelfTest() {
		$result = $this->Calc("12345678") == "012d73e0fab8d26e0f4d65e36077511e";
		$this->mode = $result ? 0 : 1;
		return $result;
	}


	function str2blks($str) {
		$nblk = ((strlen($str) + 8) >> 6) + 1;
		for($i = 0; $i < $nblk * 16; $i++) $blks[$i] = 0;
		for($i = 0; $i < strlen($str); $i++)
			$blks[$i >> 2] |= ord($str{$i}) << (($i % 4) * 8);
		$blks[$i >> 2] |= 0x80 << (($i % 4) * 8);
		$blks[$nblk * 16 - 2] = strlen($str) * 8;
		return $blks;
	}


	function safe_add($x, $y) {
		if ($this->mode == 0) {
			return ($x + $y) & 0xFFFFFFFF;
		}

		$lsw = ($x & 0xFFFF) + ($y & 0xFFFF);
		$msw = ($x >> 16) + ($y >> 16) + ($lsw >> 16);
		return ($msw << 16) | ($lsw & 0xFFFF);
	}


	function zeroFill($a, $b) {
		$z = hexdec(80000000);
		if ($z & $a) {
			$a >>= 1;
			$a &= (~$z);
			$a |= 0x40000000;
			$a >>= ($b-1);
		} else {
			$a >>= $b;
		}
		return $a;
	}


	function rol($num, $cnt) {
		return ($num << $cnt) | ($this->zeroFill($num, (32 - $cnt)));
	}


	function cmn($q, $a, $b, $x, $s, $t) {
		return $this->safe_add($this->rol($this->safe_add($this->safe_add($a, $q), $this->safe_add($x, $t)), $s), $b);
	}


	function ffMD4($a, $b, $c, $d, $x, $s) {
		return $this->cmn(($b & $c) | ((~$b) & $d), $a, 0, $x, $s, 0);
	}


	function ggMD4($a, $b, $c, $d, $x, $s) {
		return $this->cmn(($b & $c) | ($b & $d) | ($c & $d), $a, 0, $x, $s, 1518500249);
	}


	function hhMD4($a, $b, $c, $d, $x, $s) {
		return $this->cmn($b ^ $c ^ $d, $a, 0, $x, $s, 1859775393);
	}


	function Calc($str, $raw_output = false) {

		$x = $this->str2blks($str);

		$a =  1732584193;
		$b = -271733879;
		$c = -1732584194;
		$d =  271733878;

		for($i = 0; $i < count($x); $i += 16) {
			$olda = $a;
			$oldb = $b;
			$oldc = $c;
			$oldd = $d;

			$a = $this->ffMD4($a, $b, $c, $d, $x[$i+ 0], 3 );
			$d = $this->ffMD4($d, $a, $b, $c, $x[$i+ 1], 7 );
			$c = $this->ffMD4($c, $d, $a, $b, $x[$i+ 2], 11);
			$b = $this->ffMD4($b, $c, $d, $a, $x[$i+ 3], 19);
			$a = $this->ffMD4($a, $b, $c, $d, $x[$i+ 4], 3 );
			$d = $this->ffMD4($d, $a, $b, $c, $x[$i+ 5], 7 );
			$c = $this->ffMD4($c, $d, $a, $b, $x[$i+ 6], 11);
			$b = $this->ffMD4($b, $c, $d, $a, $x[$i+ 7], 19);
			$a = $this->ffMD4($a, $b, $c, $d, $x[$i+ 8], 3 );
			$d = $this->ffMD4($d, $a, $b, $c, $x[$i+ 9], 7 );
			$c = $this->ffMD4($c, $d, $a, $b, $x[$i+10], 11);
			$b = $this->ffMD4($b, $c, $d, $a, $x[$i+11], 19);
			$a = $this->ffMD4($a, $b, $c, $d, $x[$i+12], 3 );
			$d = $this->ffMD4($d, $a, $b, $c, $x[$i+13], 7 );
			$c = $this->ffMD4($c, $d, $a, $b, $x[$i+14], 11);
			$b = $this->ffMD4($b, $c, $d, $a, $x[$i+15], 19);

			$a = $this->ggMD4($a, $b, $c, $d, $x[$i+ 0], 3 );
			$d = $this->ggMD4($d, $a, $b, $c, $x[$i+ 4], 5 );
			$c = $this->ggMD4($c, $d, $a, $b, $x[$i+ 8], 9 );
			$b = $this->ggMD4($b, $c, $d, $a, $x[$i+12], 13);
			$a = $this->ggMD4($a, $b, $c, $d, $x[$i+ 1], 3 );
			$d = $this->ggMD4($d, $a, $b, $c, $x[$i+ 5], 5 );
			$c = $this->ggMD4($c, $d, $a, $b, $x[$i+ 9], 9 );
			$b = $this->ggMD4($b, $c, $d, $a, $x[$i+13], 13);
			$a = $this->ggMD4($a, $b, $c, $d, $x[$i+ 2], 3 );
			$d = $this->ggMD4($d, $a, $b, $c, $x[$i+ 6], 5 );
			$c = $this->ggMD4($c, $d, $a, $b, $x[$i+10], 9 );
			$b = $this->ggMD4($b, $c, $d, $a, $x[$i+14], 13);
			$a = $this->ggMD4($a, $b, $c, $d, $x[$i+ 3], 3 );
			$d = $this->ggMD4($d, $a, $b, $c, $x[$i+ 7], 5 );
			$c = $this->ggMD4($c, $d, $a, $b, $x[$i+11], 9 );
			$b = $this->ggMD4($b, $c, $d, $a, $x[$i+15], 13);

			$a = $this->hhMD4($a, $b, $c, $d, $x[$i+ 0], 3 );
			$d = $this->hhMD4($d, $a, $b, $c, $x[$i+ 8], 9 );
			$c = $this->hhMD4($c, $d, $a, $b, $x[$i+ 4], 11);
			$b = $this->hhMD4($b, $c, $d, $a, $x[$i+12], 15);
			$a = $this->hhMD4($a, $b, $c, $d, $x[$i+ 2], 3 );
			$d = $this->hhMD4($d, $a, $b, $c, $x[$i+10], 9 );
			$c = $this->hhMD4($c, $d, $a, $b, $x[$i+ 6], 11);
			$b = $this->hhMD4($b, $c, $d, $a, $x[$i+14], 15);
			$a = $this->hhMD4($a, $b, $c, $d, $x[$i+ 1], 3 );
			$d = $this->hhMD4($d, $a, $b, $c, $x[$i+ 9], 9 );
			$c = $this->hhMD4($c, $d, $a, $b, $x[$i+ 5], 11);
			$b = $this->hhMD4($b, $c, $d, $a, $x[$i+13], 15);
			$a = $this->hhMD4($a, $b, $c, $d, $x[$i+ 3], 3 );
			$d = $this->hhMD4($d, $a, $b, $c, $x[$i+11], 9 );
			$c = $this->hhMD4($c, $d, $a, $b, $x[$i+ 7], 11);
			$b = $this->hhMD4($b, $c, $d, $a, $x[$i+15], 15);

			$a = $this->safe_add($a, $olda);
			$b = $this->safe_add($b, $oldb);
			$c = $this->safe_add($c, $oldc);
			$d = $this->safe_add($d, $oldd);
		}
		$x = pack('V4', $a, $b, $c, $d);
		if ($raw_output) { return $x; }
		return bin2hex($x);
	}


}
# MD4 class

	################################################################################
#                                                                              #
# Webmoney Signer PHP edition by DKameleon (http://dkameleon.com)              #
#                                                                              #
# Updates and new versions: http://my-tools.net/wmxi/                          #
#                                                                              #
# Server requirements:                                                         #
# - MHash (not needed from 2007.04.06)                                         #
# - BCMath or GMP                                                              #
#                                                                              #
# History of changes:                                                          #
# 2007.02.14                                                                   #
# - initial release of the signer                                              #
# 2007.04.06                                                                   #
# - replaced MHash md4 with pure PHP md4                                       #
# 2007.08.26                                                                   #
# - added automatical switching between available MD4 implementations          #
# - added error messages                                                       #
# - added possibility to accept binary key data                                #
# 2007.04.06                                                                   #
# - added gmp support (by Alex Polushin)                                       #
# - improved _bcpowmod(), _md4(), _dec2hex(), _hex2dec() (by Alex Polushin)    #
# 2009.01.25                                                                   #
# - implemented backward compatibility for updated functions                   #
# - added internal debug option                                                #
#                                                                              #
################################################################################

//include_once("md4.php");

# WMSigner class
class WMSigner {

	var $wmid = "";
	var $pass = "";
	var $kwm = "";

	# backward compatibility switch
	var $old = true;

	# debug switch
	var $debug = false;

	# constructor
	function WMSigner($wmid, $pass, $kwm) {
		$this->wmid = $wmid;
		$this->pass = $pass;


		$this->kwm = file_exists($kwm) ? file_get_contents($kwm) : $kwm;
		if (strlen($this->kwm) != 164) {
			die("KWM file not found or KWM data invalid");
		}
	}


	# bcpowmod wrapper for old PHP
	function _bcpowmod($m, $e, $n) {
		if (function_exists("bcpowmod")) {
			return bcpowmod($m, $e, $n);
		}
		if (function_exists("gmp_powm")) {
			return trim(gmp_strval(gmp_powm($m, $e, $n)));
		}

		# backward compatibility switch
		if ($this->old) {
			$r = "";
			while ($e != "0") {
				$t = bcmod($e, "4096");
				$r = substr("000000000000".decbin(intval($t)), -12).$r;
				$e = bcdiv($e, "4096");
			}
			$r = preg_replace("!^0+!", "", $r);
			if ($r == "") $r = "0";
			$m = bcmod($m, $n);
			$erb = strrev($r);
			$result = "1";
			$a[0] = $m;
			for ($i = 1; $i < strlen($erb); $i++) {
				$a[$i] = bcmod(bcmul($a[$i-1], $a[$i-1]), $n);
			}
			for ($i = 0; $i < strlen($erb); $i++) {
				if ($erb[$i] == "1") {
					$result = bcmod(bcmul($result, $a[$i]), $n);
				}
			}
			return $result;
		} else {
			$e = $this->_dec2hex($e);
			$a["0"] = "1";
			for($i = 1; $i < 16; $i++) {
				$a[dechex($i)] = bcmod(bcmul($a[dechex($i-1)], $m), $n);
			}
			$result = $a[$e{0}];
			$l = strlen($e);
			for($i = 1; $i < $l; $i++) {
				$result = bcmod(bcmul(bcpow($result, 16), $a[$e{$i}]), $n);
			}
			return $result;
		}

	}


	# md4 wrapper
	function _md4($data) {
		if (function_exists("mhash")) { return mhash(MHASH_MD4, $data); }

		if (function_exists("hash")) { return hash("md4", $data, true); }

		if (class_exists("MD4")) {
			$md = new MD4(true);
			return $md->Calc($data, true);
		}

		die("MD4 function not found.");
	}


	# XOR two strings
	function _XOR($str, $xor_str, $shift = 0) {
		$str_len = strlen($str);
		$xor_len = strlen($xor_str);
		$i = $shift;
		$k = 0;
		while ($i < $str_len) {
			$str{$i} = chr(ord($str{$i}) ^ ord($xor_str[$k]));
			$i++;
			$k++;
			if ($k >= $xor_len) { $k = 0; }
		}
		return $str;
	}


	# convert decimal to hexadecimal
	function _dec2hex($number) {
		if (function_exists("gmp_strval")) {
			$hexval = trim(gmp_strval($number,16));
			if (strlen($hexval) % 2) { $hexval = "0".$hexval; }
			return $hexval;
		}

		# backward compatibility switch
		if ($this->old) {
			$hexvalues = array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F");
			$hexval = "";
			while($number != "0") {
				$hexval = $hexvalues[bcmod($number, "16")].$hexval;
				$number = bcdiv($number, "16", 0);
			}
			if (strlen($hexval) % 2) { $hexval = "0".$hexval; }
			return $hexval;
		} else {
			$hexval = "";
			do {
				$hexval = dechex(substr($number, -8) % 256).$hexval;
				if (strlen($hexval) % 2) { $hexval = "0".$hexval; }
				$number = bcdiv($number, 256, 0);
			} while($number != "0");
			return $hexval;
		}

	}


	# convert hexadecimal to decimal
	function _hex2dec($number) {
		if (function_exists("gmp_strval")) {
			return trim(gmp_strval("0x$number",10));
		}

		# backward compatibility switch
		if ($this->old) {
			$decvalues = array(
				"0" => "0", "1" => "1", "2" => "2", "3" => "3",
				"4" => "4", "5" => "5", "6" => "6", "7" => "7",
				"8" => "8", "9" => "9", "A" => "10", "B" => "11",
				"C" => "12", "D" => "13", "E" => "14", "F" => "15");
			$decval = "0";
			$number = strrev(strtoupper($number));
			for($i = 0; $i < strlen($number); $i++) {
				$decval = bcadd(bcmul(bcpow("16", $i, 0), $decvalues[$number{$i}]), $decval);
			}
			return $decval;
		} else {
			$n = strlen($number);
			$p = $n % 7;
			if ($p==0) $p = 7;
			$decval = hexdec(substr($number, 0, $p));
			while ($p < $n) {
				$decval = bcadd(bcmul($decval, 0x10000000), hexdec(substr($number, $p, 7)));
				$p += 7;
			}
			return $decval;
		}

	}


	# swap hexadecimal string
	function _shortunswap($hex_str) {
		$len = strlen($hex_str);
		if(($len / 2) % 2) {
			$hex_str = "00".$hex_str;
			$len = strlen($hex_str);
		}
		$pre_res = strrev($hex_str);
		$res = "";
		for($i = 0; $i < $len / 4; ++$i) {
			$res .= $pre_res[$i*4 + 3];
			$res .= $pre_res[$i*4 + 2];
			$res .= $pre_res[$i*4 + 1];
			$res .= $pre_res[$i*4 + 0];
		}
		return $res;
	}



	# both of SecureKeyByIDPW
	function SecureKeyByIDPW($wmid, $pass, $key_data, $half = false) {
		$idpw = $wmid;
		$pass_len = strlen($pass) >> ($half ? 1 : 0);
		$idpw .= substr($pass, 0, $pass_len);
		$digest = $this->_md4($idpw);
		$result = $key_data;
		$result["buf"] = $this->_XOR($result["buf"], $digest, 6);
		return $result;
	}


	# initializing E and N
	function Init($content, $key_data, &$keys) {
		if (strlen($content) < 24) { return 1; }
		if (strlen($content) - 8 < $key_data["len"]) { return -1; }

		$crc_cont = "";
		$crc_cont .= pack("v", $key_data["reserved"]);
		$crc_cont .= pack("v", $key_data["signflag"]);
		$crc_cont .= pack("V4", 0, 0, 0, 0);
		$crc_cont .= pack("V", $key_data["len"]);
		$crc_cont .= $key_data["buf"];
		$digest = $this->_md4($crc_cont);
		if (strcmp($digest, $key_data["crc"])) { return -1; }
		$tmp = unpack("Vreserved/vek_base", $key_data["buf"]);
		$tmp["buf"] = substr($key_data["buf"], 6);
		$keys["ekey"] = substr($tmp["buf"], 0, $tmp["ek_base"]);
		$tmp2 = unpack("vnk_base", substr($tmp["buf"], $tmp["ek_base"]));
		$tmp2["buf"] = substr($tmp["buf"], $tmp["ek_base"] + 2);
		$keys["nkey"] = substr($tmp2["buf"], 0, $tmp2["nk_base"]);
		return 0;
	}


	# sign data
	function Sign($data) {
		$result = "";
		$key_data = unpack("vreserved/vsignflag/a16crc/Vlen/a*buf", $this->kwm);

		$sign_keys = array();

		$key_test = $this->SecureKeyByIDPW($this->wmid, $this->pass, $key_data, true);

		$key_test["signflag"] = 0;
		if ($this->Init($this->kwm, $key_test, $sign_keys) != 0) {
			$key_test = $this->SecureKeyByIDPW($this->wmid, $this->pass, $key_data, false);

			$key_test["signflag"] = 0;
			if ($this->Init($this->kwm, $key_test, $sign_keys) != 0) {
				die("Checksum failed. KWM password invalid.");
			}
		}

		if (isset($sign_keys["ekey"]) && isset($sign_keys["nkey"])) {
			$digest = $this->_md4($data);
			$to_encrypt = $digest;
			for($i = 0; $i < 10; ++$i) { $to_encrypt .= pack("V", $this->debug ? 0 : mt_rand()); }
			$to_encrypt = pack("v", strlen($to_encrypt)).$to_encrypt;

			$m = $this->_hex2dec(bin2hex(strrev($to_encrypt)));
			$e = $this->_hex2dec(bin2hex(strrev($sign_keys["ekey"])));
			$n = $this->_hex2dec(bin2hex(strrev($sign_keys["nkey"])));

			$a = $this->_bcpowmod($m, $e, $n);
			$result = $this->_shortunswap($this->_dec2hex($a));
		}

		return strtolower($result);
	}


}
# WMSigner class


	# WMSigner caller
	function Sign($data, $wmid, $pass, $kwm) {
		$wmsigner = new WMSigner($wmid, $pass, $kwm);
		return $wmsigner->Sign($data);
	}


	#  ,   
	#      
	//include_once("../wmxi.php");
################################################################################
#                                                                              #
# Webmoney XML Interfaces by DKameleon (http://dkameleon.com)                  #
#                                                                              #
# Updates and new versions: http://my-tools.net/wmxi/                          #
#                                                                              #
# Server requirements:                                                         #
#  - CURL                                                                      #
#  - MBString                                                                  #
#                                                                              #
# History of changes:                                                          #
# 2007.02.14                                                                   #
# - initial release of X1 - X11 interfaces                                     #
# 2007.03.02                                                                   #
# - some technical fixes of X7 interface                                       #
# 2007.04.19                                                                   #
# - enchanced special chars correction                                         #
# 2007.08.26                                                                   #
# - added certificate existance check                                          #
# 2007.12.05                                                                   #
# - added X13 - X16 interfaces                                                 #
#                                                                              #
################################################################################


# WMXI constants
define("WMXI_URL_CLASSIC_X1", "https://w3s.webmoney.ru/asp/XMLInvoice.asp");
define("WMXI_URL_LITE_X1", "https://w3s.wmtransfer.com/asp/XMLInvoiceCert.asp");

define("WMXI_URL_CLASSIC_X2", "https://w3s.webmoney.ru/asp/XMLTrans.asp");
define("WMXI_URL_LITE_X2", "https://w3s.wmtransfer.com/asp/XMLTransCert.asp");

define("WMXI_URL_CLASSIC_X3", "https://w3s.webmoney.ru/asp/XMLOperations.asp");
define("WMXI_URL_LITE_X3", "https://w3s.wmtransfer.com/asp/XMLOperationsCert.asp");

define("WMXI_URL_CLASSIC_X4", "https://w3s.webmoney.ru/asp/XMLOutInvoices.asp");
define("WMXI_URL_LITE_X4", "https://w3s.webmoney.ru/asp/XMLOutInvoicesCert.asp");

define("WMXI_URL_CLASSIC_X5", "https://w3s.webmoney.ru/asp/XMLFinishProtect.asp");
define("WMXI_URL_LITE_X5", "https://w3s.wmtransfer.com/asp/XMLFinishProtectCert.asp");

define("WMXI_URL_CLASSIC_X6", "https://w3s.webmoney.ru/asp/XMLSendMsg.asp");
define("WMXI_URL_LITE_X6", "https://w3s.wmtransfer.com/asp/XMLSendMsgCert.asp");

define("WMXI_URL_CLASSIC_X7", "https://w3s.webmoney.ru/asp/XMLClassicAuth.asp");
define("WMXI_URL_LITE_X7", "https://w3s.wmtransfer.com/asp/XMLClassicAuthCert.asp");

define("WMXI_URL_CLASSIC_X8", "https://w3s.webmoney.ru/asp/XMLFindWMPurse.asp");
define("WMXI_URL_LITE_X8", "https://w3s.wmtransfer.com/asp/XMLFindWMPurseCert.asp");

define("WMXI_URL_CLASSIC_X9", "https://w3s.webmoney.ru/asp/XMLPurses.asp");
define("WMXI_URL_LITE_X9", "https://w3s.wmtransfer.com/asp/XMLPursesCert.asp");

define("WMXI_URL_CLASSIC_X10", "https://w3s.webmoney.ru/asp/XMLInInvoices.asp");
define("WMXI_URL_LITE_X10", "https://w3s.webmoney.ru/asp/XMLInInvoicesCert.asp");

define("WMXI_URL_CLASSIC_X11", "https://passport.webmoney.ru/asp/XMLGetWMPassport.asp");
define("WMXI_URL_LITE_X11", "https://passport.webmoney.ru/asp/XMLGetWMPassport.asp");

define("WMXI_URL_CLASSIC_X13", "https://w3s.webmoney.ru/asp/XMLRejectProtect.asp");
define("WMXI_URL_LITE_X13", "https://w3s.wmtransfer.com/asp/XMLRejectProtectCert.asp");

define("WMXI_URL_CLASSIC_X14", "https://w3s.webmoney.ru/asp/XMLTransMoneyback.asp");
define("WMXI_URL_LITE_X14", "https://w3s.wmtransfer.com/asp/XMLTransMoneybackCert.asp");


define("WMXI_URL_CLASSIC_X15a", "https://w3s.webmoney.ru/asp/XMLTrustList.asp");
define("WMXI_URL_LITE_X15a", "https://w3s.webmoney.ru/asp/XMLTrustListCert.asp");

define("WMXI_URL_CLASSIC_X15b", "https://w3s.webmoney.ru/asp/XMLTrustList2.asp");
define("WMXI_URL_LITE_X15b", "https://w3s.webmoney.ru/asp/XMLTrustList2Cert.asp");

define("WMXI_URL_CLASSIC_X15c", "https://w3s.webmoney.ru/asp/XMLTrustSave2.asp");
define("WMXI_URL_LITE_X15c", "https://w3s.webmoney.ru/asp/XMLTrustSave2Cert.asp");

define("WMXI_URL_CLASSIC_X16", "https://w3s.webmoney.ru/asp/XMLCreatePurse.asp");
define("WMXI_URL_LITE_X16", "https://w3s.wmtransfer.com/asp/XMLCreatePurseCert.asp");


# WMXI class
class WMXI {

	var $classic = true;

	var $wm_cert = "";
	var $encoding = "UTF-8";

	var $kwm = ""; # classic
	var $wmid = ""; # classic
	var $pass = ""; # classic + lite
	var $rsa_key = "";  # lite
	var $rsa_cert = "";  # lite


	# constructor
	function WMXI($wm_cert = "", $encoding = "UTF-8") {
		if (($wm_cert != "") && !file_exists($wm_cert)) {
			die("Specified certificate $wm_cert not found.");
		}
		$this->wm_cert = $wm_cert;
		$this->encoding = $encoding;
	}


	# initialize classic
	function Classic($wmid, $pass, $kwm) {
		$this->classic = true;
		$this->wmid = $wmid;
		$this->pass = $pass;
		$this->kwm = $kwm;
		//require_once("wmsigner.php");
	}


	# initialize lite
	function Lite($rsa_key, $rsa_cert, $pass) {
		$this->classic = false;
		$this->rsa_key = $rsa_key;
		$this->rsa_cert = $rsa_cert;
		$this->pass = $pass;
	}


	# change string encoding
	function _change_encoding($text, $encoding, $entities = false) {
		$text = $entities ? htmlspecialchars($text, ENT_QUOTES) : $text;
		return mb_convert_encoding($text, $encoding, $this->encoding);
	}


	# generate reqn
	function _reqn() {
		list($usec, $sec) = explode(" ", substr(microtime(), 2));
		return substr($sec.$usec, 0, 15);
	}


	# external sign function
	function _sign($data) {
		$text = $this->_change_encoding($data, "windows-1251");
		return Sign($text, $this->wmid, $this->pass, $this->kwm);
	}


	# external request structure creator
	function _xml($data, $name = "w3s.request") {
		return $this->__xml(array($name => $data));
	}


	# internal request structure creator
	function __xml($data) {
		$result = "";

		foreach($data as $k => $v) {
			$value = is_array($v) ? "\n".$this->__xml($v) : $this->_change_encoding($v, "HTML-ENTITIES", true);
			$result .= "<$k>$value</$k>\n";
		}

		return $result;
	}


	# request to server
	function _request($url, $xml) {
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
		if ($this->wm_cert != "") {
			curl_setopt($ch, CURLOPT_CAINFO, $this->wm_cert);
		} else {
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		}

		if(!$this->classic){
			curl_setopt($ch, CURLOPT_SSLKEY, $this->rsa_key);
			curl_setopt($ch, CURLOPT_SSLKEYPASSWD , $this->pass);
			curl_setopt($ch, CURLOPT_SSLCERT, $this->rsa_cert);
		};

		$result = curl_exec($ch);
		if(curl_errno($ch) != 0) {
			$result = "";
			$result .= "<errno>".curl_errno($ch)."</errno>\n";
			$result .= "<error>".curl_error($ch)."</error>\n";
		};
		curl_close($ch);

		return $result;
	}


	# interface X1
	function X1($orderid, $customerwmid, $storepurse, $amount, $desc, $address, $period, $expiration) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["invoice"] = array(
			"orderid" => $orderid,
			"customerwmid" => $customerwmid,
			"storepurse" => $storepurse,
			"amount" => $amount,
			"desc" => $desc,
			"address" => $address,
			"period" => $period,
			"expiration" => $expiration,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign(implode("", array_values($data["invoice"])).$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X1 : WMXI_URL_LITE_X1;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X2
	function X2($tranid, $pursesrc, $pursedest, $amount, $period, $pcode, $desc, $wminvid) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["trans"] = array(
			"tranid" => $tranid,
			"pursesrc" => $pursesrc,
			"pursedest" => $pursedest,
			"amount" => $amount,
			"period" => $period,
			"pcode" => $pcode,
			"desc" => $desc,
			"wminvid" => $wminvid,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["reqn"].implode("", array_values($data["trans"])));
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X2 : WMXI_URL_LITE_X2;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X3
	function X3($purse, $wmtranid, $tranid, $wminvid, $orderid, $datestart, $datefinish) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["getoperations"] = array(
			"purse" => $purse,
			"wmtranid" => $wmtranid,
			"tranid" => $tranid,
			"wminvid" => $wminvid,
			"orderid" => $orderid,
			"datestart" => $datestart,
			"datefinish" => $datefinish,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["getoperations"]["purse"].$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X3 : WMXI_URL_LITE_X3;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X4
	function X4($purse, $wminvid, $orderid, $datestart, $datefinish) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["getoutinvoices"] = array(
			"purse" => $purse,
			"wminvid" => $wminvid,
			"orderid" => $orderid,
			"datestart" => $datestart,
			"datefinish" => $datefinish,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["getoutinvoices"]["purse"].$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X4 : WMXI_URL_LITE_X4;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X5
	function X5($wmtranid, $pcode) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["finishprotect"] = array(
			"wmtranid" => $wmtranid,
			"pcode" => $pcode,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign(implode("", array_values($data["finishprotect"])).$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X5 : WMXI_URL_LITE_X5;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X6
	function X6($receiverwmid, $msgsubj, $msgtext) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["message"] = array(
			"receiverwmid" => $receiverwmid,
			"msgsubj" => $msgsubj,
			"msgtext" => $msgtext,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["message"]["receiverwmid"].$data["reqn"].$data["message"]["msgtext"].$data["message"]["msgsubj"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X6 : WMXI_URL_LITE_X6;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X7
	function X7($wmid, $plan, $sign) {
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["testsign"] = array(
			"wmid" => $wmid,
			"plan" => $plan,
			"sign" => $sign,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["wmid"].implode("", array_values($data["testsign"])));
		}

#		$data["testsign"]["plan"] = "<![CDATA[".$data["testsign"]["plan"]."]]>";

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X7 : WMXI_URL_LITE_X7;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X8
	function X8($wmid, $purse) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["testwmpurse"] = array(
			"wmid" => $wmid,
			"purse" => $purse,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign(implode("", array_values($data["testwmpurse"])));
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X8 : WMXI_URL_LITE_X8;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X9
	function X9($wmid) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["getpurses"] = array(
			"wmid" => $wmid,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign(implode("", array_values($data["getpurses"])).$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X9 : WMXI_URL_LITE_X9;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X10
	function X10($wmid, $wminvid, $datestart, $datefinish) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["getininvoices"] = array(
			"wmid" => $wmid,
			"wminvid" => $wminvid,
			"datestart" => $datestart,
			"datefinish" => $datefinish,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign(implode("", array_values($data["getininvoices"])).$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X10 : WMXI_URL_LITE_X10;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X11
	function X11($passportwmid, $dict, $info, $mode) {

		# 2008.09.17 change made due bug report:
		# https://forum.webmoney.ru/Default.aspx?g=posts&m=66321#66321

		if ($this->classic) { $data["wmid"] = $this->wmid; } else { $data["wmid"] = ""; }
		$data["passportwmid"] = $passportwmid;
		/*if ($this->classic) {*/ $data["sign"] = ""; /*}*/
		$data["params"] = array(
			"dict" => $dict,
			"info" => $info,
			"mode" => $mode,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["wmid"].$data["passportwmid"]);
		}

		$xml = $this->_xml($data, "request");
		$url = $this->classic ? WMXI_URL_CLASSIC_X11 : WMXI_URL_LITE_X11;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X13
	function X13($wmtranid) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["rejectprotect"] = array(
			"wmtranid" => $wmtranid,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["rejectprotect"]["wmtranid"].$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X13 : WMXI_URL_LITE_X13;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X14
	function X14($inwmtranid, $amount) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["trans"] = array(
			"inwmtranid" => $inwmtranid,
			"amount" => $amount,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["reqn"].implode("", array_values($data["trans"])));
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X14 : WMXI_URL_LITE_X14;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X15a
	function X15a($wmid) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["gettrustlist"] = array(
			"wmid" => $wmid,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign(implode("", array_values($data["gettrustlist"])).$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X15a : WMXI_URL_LITE_X15a;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X15b
	function X15b($wmid) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["gettrustlist"] = array(
			"wmid" => $wmid,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign(implode("", array_values($data["gettrustlist"])).$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X15b : WMXI_URL_LITE_X15b;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X15c
	function X15c($masterwmid, $slavewmid, $purse, $ainv, $atrans, $apurse, $atranshist, $limit, $daylimit, $weeklimit, $monthlimit) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["trust"] = array(
			"masterwmid" => $masterwmid,
			"slavewmid" => $slavewmid,
			"purse" => $purse,
			"limit" => $limit,
			"daylimit" => $daylimit,
			"weeklimit" => $weeklimit,
			"monthlimit" => $monthlimit,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["wmid"].$data["trust"]["purse"].$data["trust"]["masterwmid"].$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$attr = '<trust inv="'
				.($ainv ? "1" : "0").'" trans="'
				.($atrans ? "1" : "0").'" purse="'
				.($apurse ? "1" : "0").'" transhist="'
				.($atranshist ? "1" : "0").'">';

		$xml = str_replace("<trust>", $attr, $xml);
		$url = $this->classic ? WMXI_URL_CLASSIC_X15c : WMXI_URL_LITE_X15c;
		$result = $this->_request($url, $xml);
		return $result;
	}


	# interface X16
	function X16($wmid, $pursetype, $desc) {
		$data["reqn"] = $this->_reqn();
		if ($this->classic) { $data["wmid"] = $this->wmid; }
		if ($this->classic) { $data["sign"] = ""; }
		$data["createpurse"] = array(
			"wmid" => $wmid,
			"pursetype" => $pursetype,
			"desc" => $desc,
		);

		if ($this->classic) {
			$data["sign"] = $this->_sign($data["createpurse"]["wmid"].$data["createpurse"]["pursetype"].$data["reqn"]);
		}

		$xml = $this->_xml($data);
		$url = $this->classic ? WMXI_URL_CLASSIC_X16 : WMXI_URL_LITE_X16;
		$result = $this->_request($url, $xml);
		return $result;
	}


}
# WMXI class


	#    WMXI.  :
	# -   ,        
	# - ,   .    UTF-8
	$wmxi = new WMXI($define['bonus_cert_path'], DOC_ENCODING);
    
	#      
	#  Webmoney Keeper Classic.  :
	# - WMID -  
	# -       
	# -        164 
	#       
	$wmxi->Classic($define['bonus_wmid'], $define['bonus_pkwm'] , $define['bonus_kwm']);
	# $kwm = file_get_contents("../keys/000000000000.kwm");
	#$wmxi->Classic("000000000000", "password", $kwm);

	# http://www.webmoney.ru/rus/developers/interfaces/xml/xml_php/index.shtml
	#  "   WM Keeper Light (X.509)"
	#    
	#  Webmoney Keeper Lite.  :
	# -     
	# -    
	# -    
	# $wmxi->Lite("keyfile.key", "keyfile.cer", "pass");

	#       
	//include_once("../wmxiparser.php");
	################################################################################
#                                                                              #
# Webmoney XML Interfaces parser by DKameleon (http://dkameleon.com)           #
#                                                                              #
# Updates and new versions: http://my-tools.net/wmxi/                          #
#                                                                              #
# Server requirements:                                                         #
#  - Enabled XML support                                                       #
#                                                                              #
# History of changes:                                                          #
# 2007.02.24                                                                   #
# - initial release                                                            #
# 2007.04.19                                                                   #
# - set up default parser encoding to UTF-8                                    #
# - added encoding conversion support                                          #
# 2007.04.21                                                                   #
# - changed parser mechanism to more flexible one                              #
#                                                                              #
################################################################################


# WMXIParser class
class WMXIParser {

	var $parser_encoding = "UTF-8";
	var $parser;
	var $error_code;
	var $error_string;
	var $current_line;
	var $current_column;
	var $datas = array();
	var $data = array();


	function _tagOpen($parser, $tag, $attribs) {
		$node = array(
			'name' => strtolower($tag),
			'data' => '',
		);
		if (count($attribs) > 0) { $node["@"] = $attribs; }
		$this->data['node'][] = $node;
		$this->datas[] =& $this->data;
		$this->data =& $this->data['node'][count($this->data['node'])-1];
	}


	function _tagClose($parser, $tag) {
		$this->data =& $this->datas[count($this->datas)-1];
		array_pop($this->datas);
	}


	function _tagData($parser, $cdata) {
		$this->data['data'] .= $cdata;
	}


	function _change_encoding($data, $encoding) {
		$result = array();

		foreach($data as $k => $v) {
			$value = is_array($v) ? $this->_change_encoding($v, $encoding) : mb_convert_encoding($v, $encoding, $this->parser_encoding);
			$result[$k] = $value;
		}

		return $result;
	}


	function Parse($data, $encoding = "UTF-8") {
		if (!$this->parser = @xml_parser_create($this->parser_encoding)) {
			$this->parser = xml_parser_create();
		}
		xml_set_object($this->parser, $this);
		xml_parser_set_option($this->parser, XML_OPTION_SKIP_WHITE, 1);
		xml_set_element_handler($this->parser, '_tagOpen', '_tagClose');
		xml_set_character_data_handler($this->parser, '_tagData');
		if (!xml_parse($this->parser, $data)) {
			$this->data = array();
			$this->error_code = xml_get_error_code($this->parser);
			$this->error_string = xml_error_string($this->error_code);
			$this->current_line = xml_get_current_line_number($this->parser);
			$this->current_column = xml_get_current_column_number($this->parser);
		} else {
			$this->data = $this->data['node'];
		}
		xml_parser_free($this->parser);
		$this->data = $this->_change_encoding($this->data, $encoding);
		return $this->data;
	}


	function Reindex($data, $skip_attr = false) {
		$result = array();

		foreach($data as $k => $v) {
			$name = $v["name"];
			if ($skip_attr) {
				$result[$name] = isset($v["node"]) ? $this->Reindex($v["node"], $skip_attr) : $v["data"];
			} else {
				if (isset($v["@"]) && !$skip_attr) { $result[$name]["@"] = $v["@"]; }
				$result[$name]["data"] = isset($v["node"]) ? $this->Reindex($v["node"], $skip_attr) : $v["data"];
			}
		}

		return $result;
	}


}
# WMXIParser class
//=============================================================
?>