<?php

class sfStaticManager
{
    public static function buildChat()
    {
        $cacheKey = 'CHAT_LIST_LAST_20';
        if (!$items = sfCacheManager::get($cacheKey)) {

            $c = new Criteria();
            $c->add(ChatPeer::DT_CREATED, 'UNIX_TIMESTAMP(' . ChatPeer::DT_CREATED . ') >= ' . (time() - 60*60), Criteria::CUSTOM); // Сообщения не старше 1 часа
            $c->addDescendingOrderByColumn(ChatPeer::DT_CREATED);
            $c->setLimit(20);

            $items = ChatPeer::doSelect($c);

            sfCacheManager::set($cacheKey, $items, array('ChatList'));

        }

        $items = array_reverse($items);

        $data = array();
        foreach ($items as $item) {
            $user = sfCacheManager::getObject('sfGuardUser', $item->getUserId());

            $data[$item->getId()] = array(
                $item->getDtCreated('H:i:s'),
                $user->getId(),
                $user->getUsername(),
                $item->getMessage()
            );
        }

        file_put_contents(dirname(__FILE__) . '/../web/static/chat.html', json_encode($data));
    }

    public static function buildLotsStatus()
    {
        $cacheKey = 'LOT_IDS_LIST_FULL';
        if (!$lotIds = sfCacheManager::get($cacheKey)) {

            $c = new Criteria();
            $c->add(LotPeer::IS_CLOSED, false);
            $c->addAscendingOrderByColumn(LotPeer::DT_START);

            $lots = LotPeer::doSelect($c);

            $lotIds = array();
            foreach ($lots as $lot)
                $lotIds[] = $lot->getId();

            sfCacheManager::set($cacheKey, $lotIds, array('LotList'));

        }

        $data = array();
        foreach ($lotIds as $lotId) {
            $lot = sfCacheManager::getObject('Lot', $lotId);
            $betLast = sfCacheManager::getObject('Bet', $lot->getBetLastId(), 60);

            // История ставок
            $cacheKey = 'BETS_HISTORY_LOT_' . $lot->getId();
            if (!sfCacheManager::has($cacheKey)) {

                $c = new Criteria();
                $c->add(BetPeer::LOT_ID, $lot->getId());
                $c->addDescendingOrderByColumn(BetPeer::ID);
                $c->setLimit(5);

                $bets = BetPeer::doSelect($c);

                sfCacheManager::set($cacheKey, $bets, array('BetList'));

            } else {

                $bets = sfCacheManager::get($cacheKey);

            }

            $betsList = array();
            foreach ($bets as $bet) {
                $user = sfCacheManager::getObject('sfGuardUser', $bet->getUserId());
                $betsList[] = array($bet->getPriceFormatted(), $user->getUsername(), sfConfig::get('app_lot_bet_type_auto_id') == $bet->getAuctionBetTypeId() ? 1 : 0, $user->getId());
            }

            $data[$lot->getId()] = array(
                $lot->getId(),
                strtotime($lot->getDtEnd()),
                $lot->getPriceFormatted(),
                $lot->getProfitPercentage(),
                $lot->getUser(),
                $betLast ? $betLast->getUserId() : 0,
                $betLast ? $betLast->getId() : 0,
                ($betLast && sfConfig::get('app_lot_bet_type_auto_id') == $betLast->getAuctionBetTypeId()) ? 1 : 0,
                $betsList
            );
        }

        file_put_contents(dirname(__FILE__) . '/../web/static/status.html', json_encode($data));
    }
}