<?php

class sfAuctionApi
{
    public static function betRequestAdd($userId, $lotId)
    {
        $user = sfGuardUserPeer::retrieveByPk($userId);

        if (0 >= $user->getBalanceBets())
            return 'ERR_NO_BETS';

        $betRequest = new BetRequest();
        $betRequest->setLotId($lotId);
        $betRequest->setUserId($userId);
        $betRequest->setDtCreated(time());
        $betRequest->save();

        return true;
    }

    /**
     * !!! Должна возвращать true в случае успеха
     *
     * @param int $userId
     * @param int $lotId
     * @return mixed
     */
    public static function betAdd($userId, $lotId, $isAuto = false)
    {
        sfGuardUserPeer::removeInstanceFromPool($userId); // Скрипт, обрабатывающий ставки постоянно висит в памяти => внешние изменения для него не видны.

        $user = sfGuardUserPeer::retrieveByPk($userId);
        $lot = LotPeer::retrieveByPK($lotId);
        $betLast = BetPeer::retrieveByPK($lot->getBetLastId());

//        $lot = sfCacheManager::getObject('Lot', $lotId);
//        $betLast = sfCacheManager::getObject('Bet', $lot->getBetLastId(), 60);

        if ($betLast && $user->getId() == $betLast->getUserId())
            return 'ERR_BET_LAST';

        if ($lot->isClosedByTime())
            return 'ERR_LOT_CLOSED';

        if (0 >= $user->getBalanceBets())
            return 'ERR_NO_BETS';

        $bet = new Bet();
        $bet->setAuctionBetTypeId($isAuto ? sfConfig::get('app_lot_bet_type_auto_id') : sfConfig::get('app_lot_bet_type_manual_id'));
        $bet->setLotId($lot->getId());
        $bet->setUserId($user->getId());
        $bet->setPrice($lot->getPrice() + sfConfig::get('app_lot_price_step'));
        $bet->setDtCreated(time());
        $bet->save();

        $timeStep = 0;
        if ($lot->getPrice() < 3000)
            $timeStep = 90;
        else if ($lot->getPrice() < 6000)
            $timeStep = 60;
        else if ($lot->getPrice() < 10000)
            $timeStep = 45;
        else if ($lot->getPrice() < 15000)
            $timeStep = 35;
        else if ($lot->getPrice() < 25000)
            $timeStep = 25;
        else if ($lot->getPrice() < 50000)
            $timeStep = 15;
        else if ($lot->getPrice() < 100000)
            $timeStep = 10;
        else
            $timeStep = 5;

        $lot->setPrice($bet->getPrice());
        $lot->setUser($user->getUsername());
        $lot->setDtEnd(strtotime($lot->getDtEnd()) + $timeStep);
        $lot->setBetLastId($bet->getId());
        $lot->save();

        $user->setBalanceBets($user->getBalanceBets()-1);
        $user->save();

        return true;
    }

    public static function autobetAdd($userId, $lotId, $priceFrom, $priceTo, $betsLimit)
    {
        $user = sfGuardUserPeer::retrieveByPk($userId);
        $lot = sfCacheManager::getObject('Lot', $lotId);

        if ($lot->isClosedByTime())
            return 'ERR_LOT_CLOSED';

        if ($betsLimit > $user->getBalanceBets())
            return 'ERR_AUTOBETS_NOT_ENOUGH_BETS';

        $cacheKey = 'AUTOBET_LOT_' . $lotId . '_USER_' . $userId;
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(LotAutobetPeer::USER_ID, $userId);
            $c->add(LotAutobetPeer::LOT_ID, $lotId);

            $lotAutobet = LotAutobetPeer::doSelectOne($c);

            sfCacheManager::set($cacheKey, $lotAutobet, array('LotList', 'LotAutobetList'), 24*3600);

        } else {

            $lotAutobet = sfCacheManager::get($cacheKey);

        }

        if (!$lotAutobet) { // Создаем новый объект
            $lotAutobet = new LotAutobet();
            $lotAutobet->setUserId($userId);
            $lotAutobet->setLotId($lotId);
        }

        $lotAutobet->setPriceFrom($priceFrom);
        $lotAutobet->setPriceTo($priceTo);
        $lotAutobet->setBetsLimit($betsLimit);
        $lotAutobet->setBetsCompleted(0);
        $lotAutobet->save();

        sfCacheManager::remove($cacheKey);

        return true;
    }

    public static function autobetRemove($userId, $lotId)
    {
        $user = sfGuardUserPeer::retrieveByPk($userId);
        $lot = sfCacheManager::getObject('Lot', $lotId);

        $cacheKey = 'AUTOBET_LOT_' . $lotId . '_USER_' . $userId;
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(LotAutobetPeer::USER_ID, $userId);
            $c->add(LotAutobetPeer::LOT_ID, $lotId);
            $c->add(LotAutobetPeer::BETS_LIMIT, LotAutobetPeer::BETS_LIMIT . ' > ' . LotAutobetPeer::BETS_COMPLETED, Criteria::CUSTOM);

            $lotAutobet = LotAutobetPeer::doSelectOne($c);

            sfCacheManager::set($cacheKey, $lotAutobet, array('LotList', 'LotAutobetList'), 24*3600);

        } else {

            $lotAutobet = sfCacheManager::get($cacheKey);

        }

        if ($lotAutobet)
            $lotAutobet->delete();

        return true;
    }

    /**
     * !!! Должна возвращать true в случае успеха
     *
     */
    public static function chatAdd($userId, $message)
    {
        //$user = sfGuardUserPeer::retrieveByPk($userId);
        $user = sfCacheManager::getObject('sfGuardUser', $userId);

        if (!$user->isPayable())
            return 'ERR_CHAT_NOT_PAYABLE';

        $chat = new Chat();
        $chat->setUserId($userId);
        $chat->setDtCreated(time());
        $chat->setMessage($message);
        $chat->save();

        return true;
    }
}