<?php

/**
 * Base class that represents a row from the 'promo_code' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * 04/06/09 03:38:50
 *
 * @package    lib.model.om
 */
abstract class BasePromoCode extends BaseObject  implements Persistent {


  const PEER = 'PromoCodePeer';

	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        PromoCodePeer
	 */
	protected static $peer;

	/**
	 * The value for the id field.
	 * @var        int
	 */
	protected $id;

	/**
	 * The value for the code field.
	 * @var        string
	 */
	protected $code;

	/**
	 * The value for the use_limit field.
	 * @var        int
	 */
	protected $use_limit;

	/**
	 * The value for the dt_limit field.
	 * @var        string
	 */
	protected $dt_limit;

	/**
	 * @var        array PromoCodeBetsPackage[] Collection to store aggregation of PromoCodeBetsPackage objects.
	 */
	protected $collPromoCodeBetsPackages;

	/**
	 * @var        Criteria The criteria used to select the current contents of collPromoCodeBetsPackages.
	 */
	private $lastPromoCodeBetsPackageCriteria = null;

	/**
	 * @var        array PromoCodeVoucher[] Collection to store aggregation of PromoCodeVoucher objects.
	 */
	protected $collPromoCodeVouchers;

	/**
	 * @var        Criteria The criteria used to select the current contents of collPromoCodeVouchers.
	 */
	private $lastPromoCodeVoucherCriteria = null;

	/**
	 * @var        array UserPromoCode[] Collection to store aggregation of UserPromoCode objects.
	 */
	protected $collUserPromoCodes;

	/**
	 * @var        Criteria The criteria used to select the current contents of collUserPromoCodes.
	 */
	private $lastUserPromoCodeCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BasePromoCode object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [id] column value.
	 * 
	 * @return     int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * Get the [code] column value.
	 * 
	 * @return     string
	 */
	public function getCode()
	{
		return $this->code;
	}

	/**
	 * Get the [use_limit] column value.
	 * 
	 * @return     int
	 */
	public function getUseLimit()
	{
		return $this->use_limit;
	}

	/**
	 * Get the [optionally formatted] temporal [dt_limit] column value.
	 * 
	 *
	 * @param      string $format The date/time format string (either date()-style or strftime()-style).
	 *							If format is NULL, then the raw DateTime object will be returned.
	 * @return     mixed Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
	 * @throws     PropelException - if unable to parse/validate the date/time value.
	 */
	public function getDtLimit($format = 'Y-m-d H:i:s')
	{
		if ($this->dt_limit === null) {
			return null;
		}


		if ($this->dt_limit === '0000-00-00 00:00:00') {
			// while technically this is not a default value of NULL,
			// this seems to be closest in meaning.
			return null;
		} else {
			try {
				$dt = new DateTime($this->dt_limit);
			} catch (Exception $x) {
				throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->dt_limit, true), $x);
			}
		}

		if ($format === null) {
			// Because propel.useDateTimeClass is TRUE, we return a DateTime object.
			return $dt;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $dt->format('U'));
		} else {
			return $dt->format($format);
		}
	}

	/**
	 * Set the value of [id] column.
	 * 
	 * @param      int $v new value
	 * @return     PromoCode The current object (for fluent API support)
	 */
	public function setId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->id !== $v) {
			$this->id = $v;
			$this->modifiedColumns[] = PromoCodePeer::ID;
		}

		return $this;
	} // setId()

	/**
	 * Set the value of [code] column.
	 * 
	 * @param      string $v new value
	 * @return     PromoCode The current object (for fluent API support)
	 */
	public function setCode($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->code !== $v) {
			$this->code = $v;
			$this->modifiedColumns[] = PromoCodePeer::CODE;
		}

		return $this;
	} // setCode()

	/**
	 * Set the value of [use_limit] column.
	 * 
	 * @param      int $v new value
	 * @return     PromoCode The current object (for fluent API support)
	 */
	public function setUseLimit($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->use_limit !== $v) {
			$this->use_limit = $v;
			$this->modifiedColumns[] = PromoCodePeer::USE_LIMIT;
		}

		return $this;
	} // setUseLimit()

	/**
	 * Sets the value of [dt_limit] column to a normalized version of the date/time value specified.
	 * 
	 * @param      mixed $v string, integer (timestamp), or DateTime value.  Empty string will
	 *						be treated as NULL for temporal objects.
	 * @return     PromoCode The current object (for fluent API support)
	 */
	public function setDtLimit($v)
	{
		// we treat '' as NULL for temporal objects because DateTime('') == DateTime('now')
		// -- which is unexpected, to say the least.
		if ($v === null || $v === '') {
			$dt = null;
		} elseif ($v instanceof DateTime) {
			$dt = $v;
		} else {
			// some string/numeric value passed; we normalize that so that we can
			// validate it.
			try {
				if (is_numeric($v)) { // if it's a unix timestamp
					$dt = new DateTime('@'.$v, new DateTimeZone('UTC'));
					// We have to explicitly specify and then change the time zone because of a
					// DateTime bug: http://bugs.php.net/bug.php?id=43003
					$dt->setTimeZone(new DateTimeZone(date_default_timezone_get()));
				} else {
					$dt = new DateTime($v);
				}
			} catch (Exception $x) {
				throw new PropelException('Error parsing date/time value: ' . var_export($v, true), $x);
			}
		}

		if ( $this->dt_limit !== null || $dt !== null ) {
			// (nested ifs are a little easier to read in this case)

			$currNorm = ($this->dt_limit !== null && $tmpDt = new DateTime($this->dt_limit)) ? $tmpDt->format('Y-m-d H:i:s') : null;
			$newNorm = ($dt !== null) ? $dt->format('Y-m-d H:i:s') : null;

			if ( ($currNorm !== $newNorm) // normalized values don't match 
					)
			{
				$this->dt_limit = ($dt ? $dt->format('Y-m-d H:i:s') : null);
				$this->modifiedColumns[] = PromoCodePeer::DT_LIMIT;
			}
		} // if either are not null

		return $this;
	} // setDtLimit()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->code = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->use_limit = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
			$this->dt_limit = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 4; // 4 = PromoCodePeer::NUM_COLUMNS - PromoCodePeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating PromoCode object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PromoCodePeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = PromoCodePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->collPromoCodeBetsPackages = null;
			$this->lastPromoCodeBetsPackageCriteria = null;

			$this->collPromoCodeVouchers = null;
			$this->lastPromoCodeVoucherCriteria = null;

			$this->collUserPromoCodes = null;
			$this->lastUserPromoCodeCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BasePromoCode:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PromoCodePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			PromoCodePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BasePromoCode:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BasePromoCode:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(PromoCodePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
    foreach (sfMixer::getCallables('BasePromoCode:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			PromoCodePeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			if ($this->isNew() ) {
				$this->modifiedColumns[] = PromoCodePeer::ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = PromoCodePeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += PromoCodePeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collPromoCodeBetsPackages !== null) {
				foreach ($this->collPromoCodeBetsPackages as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collPromoCodeVouchers !== null) {
				foreach ($this->collPromoCodeVouchers as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collUserPromoCodes !== null) {
				foreach ($this->collUserPromoCodes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = PromoCodePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collPromoCodeBetsPackages !== null) {
					foreach ($this->collPromoCodeBetsPackages as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collPromoCodeVouchers !== null) {
					foreach ($this->collPromoCodeVouchers as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collUserPromoCodes !== null) {
					foreach ($this->collUserPromoCodes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PromoCodePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getCode();
				break;
			case 2:
				return $this->getUseLimit();
				break;
			case 3:
				return $this->getDtLimit();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = PromoCodePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getCode(),
			$keys[2] => $this->getUseLimit(),
			$keys[3] => $this->getDtLimit(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = PromoCodePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setCode($value);
				break;
			case 2:
				$this->setUseLimit($value);
				break;
			case 3:
				$this->setDtLimit($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = PromoCodePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setCode($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setUseLimit($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setDtLimit($arr[$keys[3]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);

		if ($this->isColumnModified(PromoCodePeer::ID)) $criteria->add(PromoCodePeer::ID, $this->id);
		if ($this->isColumnModified(PromoCodePeer::CODE)) $criteria->add(PromoCodePeer::CODE, $this->code);
		if ($this->isColumnModified(PromoCodePeer::USE_LIMIT)) $criteria->add(PromoCodePeer::USE_LIMIT, $this->use_limit);
		if ($this->isColumnModified(PromoCodePeer::DT_LIMIT)) $criteria->add(PromoCodePeer::DT_LIMIT, $this->dt_limit);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);

		$criteria->add(PromoCodePeer::ID, $this->id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	/**
	 * Generic method to set the primary key (id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of PromoCode (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCode($this->code);

		$copyObj->setUseLimit($this->use_limit);

		$copyObj->setDtLimit($this->dt_limit);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getPromoCodeBetsPackages() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addPromoCodeBetsPackage($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getPromoCodeVouchers() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addPromoCodeVoucher($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getUserPromoCodes() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addUserPromoCode($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     PromoCode Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     PromoCodePeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new PromoCodePeer();
		}
		return self::$peer;
	}

	/**
	 * Clears out the collPromoCodeBetsPackages collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addPromoCodeBetsPackages()
	 */
	public function clearPromoCodeBetsPackages()
	{
		$this->collPromoCodeBetsPackages = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collPromoCodeBetsPackages collection (array).
	 *
	 * By default this just sets the collPromoCodeBetsPackages collection to an empty array (like clearcollPromoCodeBetsPackages());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initPromoCodeBetsPackages()
	{
		$this->collPromoCodeBetsPackages = array();
	}

	/**
	 * Gets an array of PromoCodeBetsPackage objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this PromoCode has previously been saved, it will retrieve
	 * related PromoCodeBetsPackages from storage. If this PromoCode is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array PromoCodeBetsPackage[]
	 * @throws     PropelException
	 */
	public function getPromoCodeBetsPackages($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPromoCodeBetsPackages === null) {
			if ($this->isNew()) {
			   $this->collPromoCodeBetsPackages = array();
			} else {

				$criteria->add(PromoCodeBetsPackagePeer::PROMO_CODE_ID, $this->id);

				PromoCodeBetsPackagePeer::addSelectColumns($criteria);
				$this->collPromoCodeBetsPackages = PromoCodeBetsPackagePeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(PromoCodeBetsPackagePeer::PROMO_CODE_ID, $this->id);

				PromoCodeBetsPackagePeer::addSelectColumns($criteria);
				if (!isset($this->lastPromoCodeBetsPackageCriteria) || !$this->lastPromoCodeBetsPackageCriteria->equals($criteria)) {
					$this->collPromoCodeBetsPackages = PromoCodeBetsPackagePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPromoCodeBetsPackageCriteria = $criteria;
		return $this->collPromoCodeBetsPackages;
	}

	/**
	 * Returns the number of related PromoCodeBetsPackage objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related PromoCodeBetsPackage objects.
	 * @throws     PropelException
	 */
	public function countPromoCodeBetsPackages(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collPromoCodeBetsPackages === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(PromoCodeBetsPackagePeer::PROMO_CODE_ID, $this->id);

				$count = PromoCodeBetsPackagePeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(PromoCodeBetsPackagePeer::PROMO_CODE_ID, $this->id);

				if (!isset($this->lastPromoCodeBetsPackageCriteria) || !$this->lastPromoCodeBetsPackageCriteria->equals($criteria)) {
					$count = PromoCodeBetsPackagePeer::doCount($criteria, $con);
				} else {
					$count = count($this->collPromoCodeBetsPackages);
				}
			} else {
				$count = count($this->collPromoCodeBetsPackages);
			}
		}
		$this->lastPromoCodeBetsPackageCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a PromoCodeBetsPackage object to this object
	 * through the PromoCodeBetsPackage foreign key attribute.
	 *
	 * @param      PromoCodeBetsPackage $l PromoCodeBetsPackage
	 * @return     void
	 * @throws     PropelException
	 */
	public function addPromoCodeBetsPackage(PromoCodeBetsPackage $l)
	{
		if ($this->collPromoCodeBetsPackages === null) {
			$this->initPromoCodeBetsPackages();
		}
		if (!in_array($l, $this->collPromoCodeBetsPackages, true)) { // only add it if the **same** object is not already associated
			array_push($this->collPromoCodeBetsPackages, $l);
			$l->setPromoCode($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this PromoCode is new, it will return
	 * an empty collection; or if this PromoCode has previously
	 * been saved, it will retrieve related PromoCodeBetsPackages from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in PromoCode.
	 */
	public function getPromoCodeBetsPackagesJoinBetsPackage($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPromoCodeBetsPackages === null) {
			if ($this->isNew()) {
				$this->collPromoCodeBetsPackages = array();
			} else {

				$criteria->add(PromoCodeBetsPackagePeer::PROMO_CODE_ID, $this->id);

				$this->collPromoCodeBetsPackages = PromoCodeBetsPackagePeer::doSelectJoinBetsPackage($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(PromoCodeBetsPackagePeer::PROMO_CODE_ID, $this->id);

			if (!isset($this->lastPromoCodeBetsPackageCriteria) || !$this->lastPromoCodeBetsPackageCriteria->equals($criteria)) {
				$this->collPromoCodeBetsPackages = PromoCodeBetsPackagePeer::doSelectJoinBetsPackage($criteria, $con, $join_behavior);
			}
		}
		$this->lastPromoCodeBetsPackageCriteria = $criteria;

		return $this->collPromoCodeBetsPackages;
	}

	/**
	 * Clears out the collPromoCodeVouchers collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addPromoCodeVouchers()
	 */
	public function clearPromoCodeVouchers()
	{
		$this->collPromoCodeVouchers = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collPromoCodeVouchers collection (array).
	 *
	 * By default this just sets the collPromoCodeVouchers collection to an empty array (like clearcollPromoCodeVouchers());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initPromoCodeVouchers()
	{
		$this->collPromoCodeVouchers = array();
	}

	/**
	 * Gets an array of PromoCodeVoucher objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this PromoCode has previously been saved, it will retrieve
	 * related PromoCodeVouchers from storage. If this PromoCode is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array PromoCodeVoucher[]
	 * @throws     PropelException
	 */
	public function getPromoCodeVouchers($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPromoCodeVouchers === null) {
			if ($this->isNew()) {
			   $this->collPromoCodeVouchers = array();
			} else {

				$criteria->add(PromoCodeVoucherPeer::PROMO_CODE_ID, $this->id);

				PromoCodeVoucherPeer::addSelectColumns($criteria);
				$this->collPromoCodeVouchers = PromoCodeVoucherPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(PromoCodeVoucherPeer::PROMO_CODE_ID, $this->id);

				PromoCodeVoucherPeer::addSelectColumns($criteria);
				if (!isset($this->lastPromoCodeVoucherCriteria) || !$this->lastPromoCodeVoucherCriteria->equals($criteria)) {
					$this->collPromoCodeVouchers = PromoCodeVoucherPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPromoCodeVoucherCriteria = $criteria;
		return $this->collPromoCodeVouchers;
	}

	/**
	 * Returns the number of related PromoCodeVoucher objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related PromoCodeVoucher objects.
	 * @throws     PropelException
	 */
	public function countPromoCodeVouchers(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collPromoCodeVouchers === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(PromoCodeVoucherPeer::PROMO_CODE_ID, $this->id);

				$count = PromoCodeVoucherPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(PromoCodeVoucherPeer::PROMO_CODE_ID, $this->id);

				if (!isset($this->lastPromoCodeVoucherCriteria) || !$this->lastPromoCodeVoucherCriteria->equals($criteria)) {
					$count = PromoCodeVoucherPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collPromoCodeVouchers);
				}
			} else {
				$count = count($this->collPromoCodeVouchers);
			}
		}
		$this->lastPromoCodeVoucherCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a PromoCodeVoucher object to this object
	 * through the PromoCodeVoucher foreign key attribute.
	 *
	 * @param      PromoCodeVoucher $l PromoCodeVoucher
	 * @return     void
	 * @throws     PropelException
	 */
	public function addPromoCodeVoucher(PromoCodeVoucher $l)
	{
		if ($this->collPromoCodeVouchers === null) {
			$this->initPromoCodeVouchers();
		}
		if (!in_array($l, $this->collPromoCodeVouchers, true)) { // only add it if the **same** object is not already associated
			array_push($this->collPromoCodeVouchers, $l);
			$l->setPromoCode($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this PromoCode is new, it will return
	 * an empty collection; or if this PromoCode has previously
	 * been saved, it will retrieve related PromoCodeVouchers from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in PromoCode.
	 */
	public function getPromoCodeVouchersJoinVoucher($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPromoCodeVouchers === null) {
			if ($this->isNew()) {
				$this->collPromoCodeVouchers = array();
			} else {

				$criteria->add(PromoCodeVoucherPeer::PROMO_CODE_ID, $this->id);

				$this->collPromoCodeVouchers = PromoCodeVoucherPeer::doSelectJoinVoucher($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(PromoCodeVoucherPeer::PROMO_CODE_ID, $this->id);

			if (!isset($this->lastPromoCodeVoucherCriteria) || !$this->lastPromoCodeVoucherCriteria->equals($criteria)) {
				$this->collPromoCodeVouchers = PromoCodeVoucherPeer::doSelectJoinVoucher($criteria, $con, $join_behavior);
			}
		}
		$this->lastPromoCodeVoucherCriteria = $criteria;

		return $this->collPromoCodeVouchers;
	}

	/**
	 * Clears out the collUserPromoCodes collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addUserPromoCodes()
	 */
	public function clearUserPromoCodes()
	{
		$this->collUserPromoCodes = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collUserPromoCodes collection (array).
	 *
	 * By default this just sets the collUserPromoCodes collection to an empty array (like clearcollUserPromoCodes());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initUserPromoCodes()
	{
		$this->collUserPromoCodes = array();
	}

	/**
	 * Gets an array of UserPromoCode objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this PromoCode has previously been saved, it will retrieve
	 * related UserPromoCodes from storage. If this PromoCode is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array UserPromoCode[]
	 * @throws     PropelException
	 */
	public function getUserPromoCodes($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserPromoCodes === null) {
			if ($this->isNew()) {
			   $this->collUserPromoCodes = array();
			} else {

				$criteria->add(UserPromoCodePeer::PROMO_CODE_ID, $this->id);

				UserPromoCodePeer::addSelectColumns($criteria);
				$this->collUserPromoCodes = UserPromoCodePeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(UserPromoCodePeer::PROMO_CODE_ID, $this->id);

				UserPromoCodePeer::addSelectColumns($criteria);
				if (!isset($this->lastUserPromoCodeCriteria) || !$this->lastUserPromoCodeCriteria->equals($criteria)) {
					$this->collUserPromoCodes = UserPromoCodePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserPromoCodeCriteria = $criteria;
		return $this->collUserPromoCodes;
	}

	/**
	 * Returns the number of related UserPromoCode objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related UserPromoCode objects.
	 * @throws     PropelException
	 */
	public function countUserPromoCodes(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collUserPromoCodes === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(UserPromoCodePeer::PROMO_CODE_ID, $this->id);

				$count = UserPromoCodePeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(UserPromoCodePeer::PROMO_CODE_ID, $this->id);

				if (!isset($this->lastUserPromoCodeCriteria) || !$this->lastUserPromoCodeCriteria->equals($criteria)) {
					$count = UserPromoCodePeer::doCount($criteria, $con);
				} else {
					$count = count($this->collUserPromoCodes);
				}
			} else {
				$count = count($this->collUserPromoCodes);
			}
		}
		$this->lastUserPromoCodeCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a UserPromoCode object to this object
	 * through the UserPromoCode foreign key attribute.
	 *
	 * @param      UserPromoCode $l UserPromoCode
	 * @return     void
	 * @throws     PropelException
	 */
	public function addUserPromoCode(UserPromoCode $l)
	{
		if ($this->collUserPromoCodes === null) {
			$this->initUserPromoCodes();
		}
		if (!in_array($l, $this->collUserPromoCodes, true)) { // only add it if the **same** object is not already associated
			array_push($this->collUserPromoCodes, $l);
			$l->setPromoCode($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this PromoCode is new, it will return
	 * an empty collection; or if this PromoCode has previously
	 * been saved, it will retrieve related UserPromoCodes from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in PromoCode.
	 */
	public function getUserPromoCodesJoinsfGuardUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(PromoCodePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserPromoCodes === null) {
			if ($this->isNew()) {
				$this->collUserPromoCodes = array();
			} else {

				$criteria->add(UserPromoCodePeer::PROMO_CODE_ID, $this->id);

				$this->collUserPromoCodes = UserPromoCodePeer::doSelectJoinsfGuardUser($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(UserPromoCodePeer::PROMO_CODE_ID, $this->id);

			if (!isset($this->lastUserPromoCodeCriteria) || !$this->lastUserPromoCodeCriteria->equals($criteria)) {
				$this->collUserPromoCodes = UserPromoCodePeer::doSelectJoinsfGuardUser($criteria, $con, $join_behavior);
			}
		}
		$this->lastUserPromoCodeCriteria = $criteria;

		return $this->collUserPromoCodes;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collPromoCodeBetsPackages) {
				foreach ((array) $this->collPromoCodeBetsPackages as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collPromoCodeVouchers) {
				foreach ((array) $this->collPromoCodeVouchers as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collUserPromoCodes) {
				foreach ((array) $this->collUserPromoCodes as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collPromoCodeBetsPackages = null;
		$this->collPromoCodeVouchers = null;
		$this->collUserPromoCodes = null;
	}


  public function __call($method, $arguments)
  {
    if (!$callable = sfMixer::getCallable('BasePromoCode:'.$method))
    {
      throw new sfException(sprintf('Call to undefined method BasePromoCode::%s', $method));
    }

    array_unshift($arguments, $this);

    return call_user_func_array($callable, $arguments);
  }


} // BasePromoCode
