<?php


/**
 * This class adds structure of 'lot' table to 'propel' DatabaseMap object.
 *
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * 04/06/09 03:38:49
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    lib.model.map
 */
class LotMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'lib.model.map.LotMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(LotPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(LotPeer::TABLE_NAME);
		$tMap->setPhpName('Lot');
		$tMap->setClassname('Lot');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('ID', 'Id', 'INTEGER', true, 11);

		$tMap->addForeignKey('AUCTION_TYPE_ID', 'AuctionTypeId', 'INTEGER', 'auction_type', 'ID', false, 11);

		$tMap->addForeignKey('PRODUCT_ID', 'ProductId', 'INTEGER', 'product', 'ID', false, 11);

		$tMap->addColumn('DT_START', 'DtStart', 'TIMESTAMP', false, null);

		$tMap->addColumn('DT_END', 'DtEnd', 'TIMESTAMP', false, null);

		$tMap->addColumn('DT_AUTOBET', 'DtAutobet', 'TIMESTAMP', false, null);

		$tMap->addColumn('IS_CLOSED', 'IsClosed', 'BOOLEAN', false, 1);

		$tMap->addColumn('PRICE', 'Price', 'INTEGER', false, 11);

		$tMap->addColumn('USER', 'User', 'CHAR', false, 100);

		$tMap->addForeignKey('BET_LAST_ID', 'BetLastId', 'INTEGER', 'bet', 'ID', false, 11);

	} // doBuild()

} // LotMapBuilder
