<?php

class UserBetsPackage extends BaseUserBetsPackage
{
    private $_monthName = array('января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря');

    public function getDtCreatedFormatted()
    {
        if (!$this->getDtCreated())
            return '-';

        return sprintf(
            '%s %s в %s:%s',
            $this->getDtCreated('j'),
            $this->_monthName[$this->getDtCreated('n')-1],
            $this->getDtCreated('G'),
            $this->getDtCreated('i')
        );
    }

    public function save(PropelPDO $con = null)
    {
        if ($this->isNew()) {
            $user = $this->getsfGuardUser();
            $user->setBalanceBets($user->getBalanceBets() + $this->getBetsPackage()->getBetsCount());
            $user->save();
        }

        parent::save();
    }
}
