<?php

class News extends BaseNews
{
    private $_monthName = array('января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря');

    public function getDtCreatedFormatted()
    {
        return sprintf(
            '%s %s',
            $this->getDtCreated('j'),
            $this->_monthName[$this->getDtCreated('n')-1]
        );
    }

    public function save(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::save($con);
    }

    public function delete(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::delete($con);
    }

    private function clearCache()
    {
        // Сам объект
        sfCacheManager::removeObject('News', $this->getId());

        // Все списки
        sfCacheManager::removeTag('NewsList');
    }
}
