<?php

class Mail extends BaseMail
{
    private $_monthName = array('января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря');

    public function getDtCreatedFormatted()
    {
        return sprintf(
            '%s %s в %s:%s',
            $this->getDtCreated('j'),
            $this->_monthName[$this->getDtCreated('n')-1],
            $this->getDtCreated('G'),
            $this->getDtCreated('i')
        );
    }

    public function save(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::save($con);
    }

    public function delete(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::delete($con);
    }

    private function clearCache()
    {
        // Сам объект
        sfCacheManager::removeObject('Mail', $this->getId());

        // Все списки
        sfCacheManager::removeTag('MailList');
    }
}
