<?php

class LotAutobet extends BaseLotAutobet
{
    public function getUserTitle()
    {
        return ($user = $this->getsfGuardUser()) ? $user->getUsername() : '-';
    }

    public function getLotTitle()
    {
        return ($lot = $this->getLot()) ? (string) $lot : '-';
    }

    public function getPriceFromFormatted()
    {
        return number_format($this->getPriceFrom(), 0, ',', ' ');
    }

    public function getPriceToFormatted()
    {
        return number_format($this->getPriceTo(), 0, ',', ' ');
    }

	public function save(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::save($con);
    }

    public function delete(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::delete($con);
    }

    private function clearCache()
    {
        // Сам объект
        sfCacheManager::removeObject('LotAutobet', $this->getId());

        // Все списки
        sfCacheManager::removeTag('LotAutobetList');

        // Список автоставок для лота
        sfCacheManager::remove('AUTOBETS_LIST_LOT_' . $this->getLotId() . '_BOTS');
        sfCacheManager::remove('AUTOBETS_LIST_LOT_' . $this->getLotId() . '_NO_BOTS');
    }
}
