<?php

class BetsPackage extends BaseBetsPackage
{
    public function __toString()
    {
        return $this->getTitle();
    }

    public function getBetsCountFull()
    {
        $value = 0 + $this->getBetsCount();

        if ( (10 <= $value && 20 >= $value) || (in_array($value%10, array(0, 5, 6, 7, 8, 9))) )
            return $value . ' ставок';

        if (1 == $value%10)
            return $value . ' ставка';

        return $value . ' ставки';
    }

    public function getPriceFormatted()
    {
        return number_format($this->getPrice(), 0, ',', ' ');
    }

    public function getPricePerBetFormatted()
    {
        return number_format($this->getPricePerBet(), 0, ',', ' ');
    }

    public function getPricePerBet()
    {
        return $this->getPrice() / $this->getBetsCount();
    }

    public function save(PropelPDO $con = null)
    {
        parent::save($con);

        $this->clearCache();
    }

    public function delete(PropelPDO $con = null)
    {
        parent::delete($con);

        $this->clearCache();
    }

    private function clearCache()
    {
        // Сам объект
        sfCacheManager::removeObject('BetsPackage', $this->getId());

        // Все списки
        sfCacheManager::removeTag('BetsPackageList');
    }
}
