<?php

class Bet extends BaseBet
{
    private $_monthName = array('января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря');

    public function getPriceFormatted()
    {
        return number_format($this->getPrice(), 0, ',', ' ');
    }

    public function getDtCreatedFormattedExt()
    {
        return sprintf(
            '%s %s в %s:%s:%s',
            $this->getDtCreated('j'),
            $this->_monthName[$this->getDtCreated('n')-1],
            $this->getDtCreated('G'),
            $this->getDtCreated('i'),
            $this->getDtCreated('s')
        );
    }

    public function getDtCreatedFormatted()
    {
        return sprintf(
            '%s %s в %s:%s',
            $this->getDtCreated('j'),
            $this->_monthName[$this->getDtCreated('n')-1],
            $this->getDtCreated('G'),
            $this->getDtCreated('i')
        );
    }

    public function getAuctionBetTypeText()
    {
        return sfConfig::get('app_lot_bet_type_manual_id') == $this->getAuctionBetTypeId() ? 'ручная' : 'авто';
    }

    public function save(PropelPDO $con = null)
    {
        parent::save($con);

        $this->clearCache();
    }

    public function delete(PropelPDO $con = null)
    {
        parent::delete($con);

        $this->clearCache();
    }

    private function clearCache()
    {
        // Сам объект
        sfCacheManager::removeObject('Bet', $this->getId());

        // Все списки
        sfCacheManager::removeTag('BetList');
    }
}
