<?php

/**
 * Payment form base class.
 *
 * @package    auction
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormGeneratedTemplate.php 12815 2008-11-09 10:43:58Z fabien $
 */
class BasePaymentForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'              => new sfWidgetFormInputHidden(),
      'user_id'         => new sfWidgetFormPropelChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'payment_type_id' => new sfWidgetFormPropelChoice(array('model' => 'PaymentType', 'add_empty' => true)),
      'bets_package_id' => new sfWidgetFormPropelChoice(array('model' => 'BetsPackage', 'add_empty' => true)),
      'status'          => new sfWidgetFormInput(),
      'dt_created'      => new sfWidgetFormDateTime(),
      'description'     => new sfWidgetFormInput(),
    ));

    $this->setValidators(array(
      'id'              => new sfValidatorPropelChoice(array('model' => 'Payment', 'column' => 'id', 'required' => false)),
      'user_id'         => new sfValidatorPropelChoice(array('model' => 'sfGuardUser', 'column' => 'id', 'required' => false)),
      'payment_type_id' => new sfValidatorPropelChoice(array('model' => 'PaymentType', 'column' => 'id', 'required' => false)),
      'bets_package_id' => new sfValidatorPropelChoice(array('model' => 'BetsPackage', 'column' => 'id', 'required' => false)),
      'status'          => new sfValidatorInteger(array('required' => false)),
      'dt_created'      => new sfValidatorDateTime(array('required' => false)),
      'description'     => new sfValidatorString(array('max_length' => 255, 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Payment', 'column' => array('id')))
    );

    $this->widgetSchema->setNameFormat('payment[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Payment';
  }


}
