<?php

/**
 * LotAutobet form base class.
 *
 * @package    auction
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormGeneratedTemplate.php 12815 2008-11-09 10:43:58Z fabien $
 */
class BaseLotAutobetForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'             => new sfWidgetFormInputHidden(),
      'lot_id'         => new sfWidgetFormPropelChoice(array('model' => 'Lot', 'add_empty' => true)),
      'user_id'        => new sfWidgetFormPropelChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'price_from'     => new sfWidgetFormInput(),
      'price_to'       => new sfWidgetFormInput(),
      'bets_limit'     => new sfWidgetFormInput(),
      'bets_completed' => new sfWidgetFormInput(),
    ));

    $this->setValidators(array(
      'id'             => new sfValidatorPropelChoice(array('model' => 'LotAutobet', 'column' => 'id', 'required' => false)),
      'lot_id'         => new sfValidatorPropelChoice(array('model' => 'Lot', 'column' => 'id', 'required' => false)),
      'user_id'        => new sfValidatorPropelChoice(array('model' => 'sfGuardUser', 'column' => 'id', 'required' => false)),
      'price_from'     => new sfValidatorInteger(array('required' => false)),
      'price_to'       => new sfValidatorInteger(array('required' => false)),
      'bets_limit'     => new sfValidatorInteger(array('required' => false)),
      'bets_completed' => new sfValidatorInteger(array('required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'LotAutobet', 'column' => array('id')))
    );

    $this->widgetSchema->setNameFormat('lot_autobet[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'LotAutobet';
  }


}
