<?php

/**
 * Bet form base class.
 *
 * @package    auction
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormGeneratedTemplate.php 12815 2008-11-09 10:43:58Z fabien $
 */
class BaseBetForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'                  => new sfWidgetFormInputHidden(),
      'lot_id'              => new sfWidgetFormInput(),
      'user_id'             => new sfWidgetFormPropelChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'auction_bet_type_id' => new sfWidgetFormPropelChoice(array('model' => 'AuctionBetType', 'add_empty' => true)),
      'price'               => new sfWidgetFormInput(),
      'dt_created'          => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'                  => new sfValidatorPropelChoice(array('model' => 'Bet', 'column' => 'id', 'required' => false)),
      'lot_id'              => new sfValidatorInteger(array('required' => false)),
      'user_id'             => new sfValidatorPropelChoice(array('model' => 'sfGuardUser', 'column' => 'id', 'required' => false)),
      'auction_bet_type_id' => new sfValidatorPropelChoice(array('model' => 'AuctionBetType', 'column' => 'id', 'required' => false)),
      'price'               => new sfValidatorInteger(array('required' => false)),
      'dt_created'          => new sfValidatorDateTime(array('required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Bet', 'column' => array('id')))
    );

    $this->widgetSchema->setNameFormat('bet[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Bet';
  }


}
