<?php

/**
 * Mail form.
 *
 * @package    auction
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormTemplate.php 10377 2008-07-21 07:10:32Z dwhittle $
 */
class MailForm extends BaseMailForm
{
    public function configure()
    {
        $this->widgetSchema['user_to_id']->setLabel('Кому');
        $this->widgetSchema['subject']->setLabel('Тема');
        $this->widgetSchema['email']->setLabel('E-Mail');
        $this->widgetSchema['message']->setLabel('Сообщение');

        $this->validatorSchema['subject'] = new sfValidatorString(array('required' => true));
        $this->validatorSchema['email'] = new sfValidatorEmail(array('required' => true));
        $this->validatorSchema['message'] = new sfValidatorString(array('required' => true));

        $this->validatorSchema['user_to_id']->setMessage('required', 'Поле обязательно для заполнения.');
        $this->validatorSchema['subject']->setMessage('required', 'Поле обязательно для заполнения.');
        $this->validatorSchema['email']->setMessage('required', 'Поле обязательно для заполнения.');
        $this->validatorSchema['email']->setMessage('invalid', 'Некорректный адрес электронной почты.');
        $this->validatorSchema['message']->setMessage('required', 'Поле обязательно для заполнения.');

        $this->widgetSchema['user_to_id']->setOption('renderer_class', 'sfWidgetFormPropelJQueryAutocompleter');
        $this->widgetSchema['user_to_id']->setOption('renderer_options', array(
            'model' => 'sfGuardUser',
            'url'   => $this->getOption('url'),
        ));
    }
}
