<?php

/**
 * HelpTopic form.
 *
 * @package    auction
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormTemplate.php 10377 2008-07-21 07:10:32Z dwhittle $
 */
class HelpTopicForm extends BaseHelpTopicForm
{
    public function configure()
    {
        if (!$this->isNew()) {

            foreach ($this->getObject()->getHelps() as $help) {

                $helpForm = new HelpForm($help);

                $this->embedForm('help_' . $help->getId(), $helpForm);

                $this->widgetSchema['help_' . $help->getId()]->setLabel($help->getTitle() . '<br /><br /><a style="color: red;" href="' . sfContext::getInstance()->getController()->genUrl('help_topic/deleteHelp?id=' . $help->getId()) . '">Удалить</a>');
                $this->widgetSchema['help_' . $help->getId()]['help_topic_id'] = new sfWidgetFormInputHidden();
                $this->widgetSchema['help_' . $help->getId()]['content'] = new sfWidgetFormTextareaTinyMCE(
                    array(
                        'width'  => 400,
                        'height' => 200,
                        'config' => 'theme_advanced_disable: "anchor"'
                    ),
                    array(
                        'class' => 'TinyMCE_' . $help->getId()
                    )
                );

            }

        }

        $helpForm = new HelpForm();
        $helpForm->setDefault('help_topic_id', $this->getObject()->getId());

        $this->embedForm('help', $helpForm);

        $this->widgetSchema['help']['help_topic_id'] = new sfWidgetFormInputHidden();
        $this->widgetSchema['help']['content'] = new sfWidgetFormTextareaTinyMCE(
            array(
                'width'  => 400,
                'height' => 200,
                'config' => 'theme_advanced_disable: "anchor"'
            ),
            array(
                'class' => 'TinyMCE'
            )
        );
    }

    public function bind(array $taintedValues = null, array $taintedFiles = null) {

        // remove the embedded new form if the name field was not provided
        if (is_null($taintedValues['help']['title']) || strlen($taintedValues['help']['title']) === 0 ) {

            unset($this->embeddedForms['help'], $taintedValues['help']);

            // pass the new form validations
            $this->validatorSchema['help'] = new sfValidatorPass();

        } else {

            // set the help item of the new subcategory form object
            $this->embeddedForms['help']->getObject()->setHelpTopic($this->getObject());

        }

        // call parent bind method
        parent::bind($taintedValues, $taintedFiles);

    }
}
