<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * PromoCode filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BasePromoCodeFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'code'      => new sfWidgetFormFilterInput(),
      'use_limit' => new sfWidgetFormFilterInput(),
      'dt_limit'  => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
    ));

    $this->setValidators(array(
      'code'      => new sfValidatorPass(array('required' => false)),
      'use_limit' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'dt_limit'  => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('promo_code_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'PromoCode';
  }

  public function getFields()
  {
    return array(
      'id'        => 'Number',
      'code'      => 'Text',
      'use_limit' => 'Number',
      'dt_limit'  => 'Date',
    );
  }
}
