<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * Payment filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BasePaymentFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'user_id'         => new sfWidgetFormPropelChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'payment_type_id' => new sfWidgetFormPropelChoice(array('model' => 'PaymentType', 'add_empty' => true)),
      'bets_package_id' => new sfWidgetFormPropelChoice(array('model' => 'BetsPackage', 'add_empty' => true)),
      'status'          => new sfWidgetFormFilterInput(),
      'dt_created'      => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
      'description'     => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'user_id'         => new sfValidatorPropelChoice(array('required' => false, 'model' => 'sfGuardUser', 'column' => 'id')),
      'payment_type_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'PaymentType', 'column' => 'id')),
      'bets_package_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'BetsPackage', 'column' => 'id')),
      'status'          => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'dt_created'      => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'description'     => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('payment_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Payment';
  }

  public function getFields()
  {
    return array(
      'id'              => 'Number',
      'user_id'         => 'ForeignKey',
      'payment_type_id' => 'ForeignKey',
      'bets_package_id' => 'ForeignKey',
      'status'          => 'Number',
      'dt_created'      => 'Date',
      'description'     => 'Text',
    );
  }
}
