<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * LotAutobet filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BaseLotAutobetFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'lot_id'         => new sfWidgetFormPropelChoice(array('model' => 'Lot', 'add_empty' => true)),
      'user_id'        => new sfWidgetFormPropelChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'price_from'     => new sfWidgetFormFilterInput(),
      'price_to'       => new sfWidgetFormFilterInput(),
      'bets_limit'     => new sfWidgetFormFilterInput(),
      'bets_completed' => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'lot_id'         => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Lot', 'column' => 'id')),
      'user_id'        => new sfValidatorPropelChoice(array('required' => false, 'model' => 'sfGuardUser', 'column' => 'id')),
      'price_from'     => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'price_to'       => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'bets_limit'     => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'bets_completed' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
    ));

    $this->widgetSchema->setNameFormat('lot_autobet_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'LotAutobet';
  }

  public function getFields()
  {
    return array(
      'id'             => 'Number',
      'lot_id'         => 'ForeignKey',
      'user_id'        => 'ForeignKey',
      'price_from'     => 'Number',
      'price_to'       => 'Number',
      'bets_limit'     => 'Number',
      'bets_completed' => 'Number',
    );
  }
}
