<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * Bet filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BaseBetFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'lot_id'              => new sfWidgetFormFilterInput(),
      'user_id'             => new sfWidgetFormPropelChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'auction_bet_type_id' => new sfWidgetFormPropelChoice(array('model' => 'AuctionBetType', 'add_empty' => true)),
      'price'               => new sfWidgetFormFilterInput(),
      'dt_created'          => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
    ));

    $this->setValidators(array(
      'lot_id'              => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'user_id'             => new sfValidatorPropelChoice(array('required' => false, 'model' => 'sfGuardUser', 'column' => 'id')),
      'auction_bet_type_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'AuctionBetType', 'column' => 'id')),
      'price'               => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'dt_created'          => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
    ));

    $this->widgetSchema->setNameFormat('bet_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Bet';
  }

  public function getFields()
  {
    return array(
      'id'                  => 'Number',
      'lot_id'              => 'Number',
      'user_id'             => 'ForeignKey',
      'auction_bet_type_id' => 'ForeignKey',
      'price'               => 'Number',
      'dt_created'          => 'Date',
    );
  }
}
