trustdev.provide('lots');
trustdev.provide('lots.config');

lots.updaterTimer = null;
lots.updaterLock = false;
lots.betLock = false;
lots.price = new Array();
lots.betLastUserId = new Array();

lots.serverTime = null;

lots.config.animationFadeTime = 150;

lots.updater = function() {

	if (!lots.updaterLock) {
		
		lots.updaterLock = true;
		
		var request = $.get('/static/status.html?random=' + Math.random(), function (jsonData) {

            // (!!!) Время сервера, используется для отсчета
            lots.serverTime = request.getResponseHeader('Date');
			
			if (jsonData) {
			
				data = $.evalJSON(jsonData);
				
				for (var lotId in data) {

                    lots.betLastUserId[lotId] = data[lotId][5];

                    // ***** КРАТКИЙ ВИД АУКЦИОНА *****
                    if ($('#lot_' + lotId + '_time').html()) {
                    	
                        var timeNewFormatted = lots.getLotTimeFormatted(data[lotId][1]);
                        var timeNew = lots.getLotTime(data[lotId][1]);

                        if (timeNew < 15)
                            $('#lot_' + lotId + '_time').css('color', '#F70027');
                        else
                            $('#lot_' + lotId + '_time').css('color', '');

                        if (timeNewFormatted) {

                            $('#lot_' + lotId + '_time').html(timeNewFormatted);
                            
                        } else if ('Завершен' != $('#lot_' + lotId + '_time').text()) {
                        	
                        	$('#lot_' + lotId + '_button').fadeOut(lots.config.animationFadeTime);

                            $('#lot_' + lotId + '_time').fadeOut(lots.config.animationFadeTime, function() {

                                $(this)
                                    .html('Завершен')
                                    .fadeIn(lots.config.animationFadeTime);

                            });

                        }

                        if (lots.price[lotId] != data[lotId][2]) { // Обновляем информацию только при необходимости

                            // Обновляем цену
                            lots.price[lotId] = data[lotId][2];
                            
                            $('#lot_' + lotId + '_author_url').attr('href', '/profile/' + data[lotId][5]);
//                            $('#lot_' + lotId + '_author').html(data[lotId][4] ? data[lotId][4] : '<br />');
                            $('#lot_' + lotId + '_author').contents().filter(function(){ return this.nodeType != 1; }).replaceWith(data[lotId][4] ? data[lotId][4] + ' ' : '<br />');
                            $('#lot_' + lotId + '_price').html(data[lotId][2] + ' руб.');
                            $('#lot_' + lotId + '_price').shake(3, 5, 1000);

                            if (userId == data[lotId][5]) {
                                $('#lot_' + lotId + '_price').parent().css('backgroundColor', '#F70027');
                            } else {
                                $('#lot_' + lotId + '_price').parent().css('backgroundColor', '#74A600');
                            }
                            
                            // Обновляем инфу в хедере если пришла ставка текущего юзера
                            if (userId == data[lotId][5]) {

                                betsRemaining--;

                                lots.updateBetsRemaining();

                            }

                        }
                    }


                    // ***** ПОЛНЫЙ ВИД АУКЦИОНА *****
                    if ($('#lot_full_' + lotId + '_time').html()) {
                    	
                        var timeNewFormatted = lots.getLotTimeFormatted(data[lotId][1]);
                        var timeNew = lots.getLotTime(data[lotId][1]);

                        if (timeNew < 15)
                            $('#lot_full_' + lotId + '_time').css('color', '#F70027');
                        else
                            $('#lot_full_' + lotId + '_time').css('color', '');

                        if (timeNewFormatted) {

                            $('#lot_full_' + lotId + '_time').html(timeNewFormatted);

                        } else if ('Завершен' != $('#lot_full_' + lotId + '_time').text()) {
                        	
                        	$('#autobets_off').fadeOut(lots.config.animationFadeTime);
                        	$('#autobets_on').fadeOut(lots.config.animationFadeTime);

                            $('#lot_full_' + lotId + '_time').fadeOut(lots.config.animationFadeTime, function() {

                                $('#lot_full_' + lotId + '_time')
                                    .html('Завершен')
                                    .fadeIn(lots.config.animationFadeTime/2);

                            });

                        }

                        $('#lot_full_' + lotId + '_author_url').attr('href', '/profile/' + data[lotId][5]);
                        $('#lot_full_' + lotId + '_author').contents().filter(function(){ return this.nodeType != 1; }).replaceWith(data[lotId][4] ? data[lotId][4] + ' ' : '<br />');
                        $('#lot_full_' + lotId + '_price').html('&nbsp;' + data[lotId][2] + ' руб.');
                        $('#lot_full_' + lotId + '_profit').html(data[lotId][3] + '%');

                        if (userId == data[lotId][5])
                            $('#lot_full_' + lotId + '_price').parent().css('backgroundColor', '#F70027');
                        else
                            $('#lot_full_' + lotId + '_price').parent().css('backgroundColor', '#74A600');

                        if (betLastId != data[lotId][6]) { // Пришла новая ставка
                        	
                        	$('#lot_full_' + lotId + '_price').shake(3, 5, 1000);
                        	
                        	betLastId = data[lotId][6];
                        	
                        	// Обновляем историю
                        	var history = data[lotId][8];
                        	var historyHtml = '';
                        	
                        	for (var i = 0; i < history.length; i++)
                        		historyHtml += '<tr><td class="first">' + history[i][0] + ' руб.</td><td><a onmouseover="$(this).find(\'img\').attr(\'src\', \'/images/info_sm_over.png\');" onmouseout="$(this).find(\'img\').attr(\'src\', \'/images/info_sm.png\');" href="/profile/' + history[i][3] + '" title="Профиль участника"><img src="/images/info_sm.png" width="13" height="13" style="margin-bottom: -1px;" alt="Профиль участника" /></a></td><td width="90" height="16"> &nbsp; <strong>' + history[i][1] + '</strong></td><td>' + (1 == history[i][2] ? 'авто' : 'ручная') +'</td></tr>';

                        	$('#bets_log').html(historyHtml);

                            // Пришла ставка от текущего юзера => уменьшаем общее кол-во ставок
                            if (userId == data[lotId][5]) {
                            	
                                betsRemaining--;

                                lots.updateBetsRemaining();
                                
                                if (betsPayed) { // Аукцион с компенсацией
                                	
                                	betsPayed += 500;
                                	
                                	$('#lot_full_' + lotId + '_payed').html(betsPayed);
                                	$('#lot_full_' + lotId + '_payed').format({format:'#,###', locale:'fr'});
                                
                                }
                            	
                            }

                            // Пришла автоставка текущего юзера => обновляем инфу об авоставках
                            if (userId == data[lotId][5] && 1 == data[lotId][7]) { // Пришла автоставка текущего юзера

                                $('#autobet_bets_remaining').html($('#autobet_bets_remaining').html()-1);

                            } 
                        }

                    }

				}
			
			}
			
			lots.updaterLock = false;
			
		});
		
	}

    lots.updaterTimer = setTimeout("lots.updater()", 700);
	
}

lots.betAdd = function (lotId) {

    if (userId == lots.betLastUserId[lotId]) {
        messages.show('ERR_BET_LAST');
        return;
    }

    if (lots.betLock) {
        messages.show('ERR_BET_WAIT');
        return;
    }

    lots.betLock = true;

	$.get('/api/bet_add.php?random=' + Math.random(), {'lotId': lotId}, function(data) {
        lots.betLock = false;

        if (1 != data)
        	
            messages.show(data);
        
        else {

            messages.show('BET_SUCCESS');
        }
    });
	
}

lots.autobetAdd = function (lotId) {

    $('#popup_autobets').fadeOut('fast');

    $.get('/api/autobet_add.php?random=' + Math.random(), {
        'lotId':     lotId,
        'priceFrom': $('#autobet_input_price_from').val(),
        'priceTo':   $('#autobet_input_price_to').val(),
        'betsLimit': $('#autobet_input_bets_limit').val()
    }, function (data) {
        
        if (1 == data) {
        		
        	autobetsRemaining = $('#autobet_input_bets_limit').val();
            
            $('#autobet_price_from').html($('#autobet_input_price_from').val());
            $('#autobet_price_to').html($('#autobet_input_price_to').val());
            $('#autobet_bets_remaining').html($('#autobet_input_bets_limit').val());
            $('#autobet_bets_limit').html($('#autobet_input_bets_limit').val());

            $('#autobets_on').fadeIn('fast');
            
        } else {

            messages.show(data);

        }

    });

}

lots.autobetRemove = function (lotId) {

    $.get('/api/autobet_remove.php?random=' + Math.random(), {
        'lotId':     lotId
    }, function (data) {

        $('#autobets_on').fadeOut('fast', function() {
            $('#autobets_off').fadeIn('fast');
        });

    });

}

lots.updateBetsRemaining = function() {
	
    var output = '';
    
    if ( (10 <= betsRemaining && 20 >= betsRemaining) || (-1 != jQuery.inArray(betsRemaining%10, [ 0, 5, 6, 7, 8, 9 ])) )
        output = '' + betsRemaining + ' ставок';

    else if (1 == betsRemaining%10)
        output = '' + betsRemaining + ' ставка';
    
    else
        output = '' + betsRemaining + ' ставки';

    $('#balance_header').html(output);
    
}

lots.getLotTime = function (dtEnd) {

	var dtNow = parseInt(getCurrentTimestamp());

	return dtEnd - dtNow;
}

lots.getLotTimeFormatted = function (dtEnd) {
	
	var timeToEnd = lots.getLotTime(dtEnd);

    if (timeToEnd < 0)
        return false;
	
	var h = Math.floor(timeToEnd/3600);
	var m = Math.floor((timeToEnd%3600)/60);
	var s = timeToEnd%60;
	
	if (m<10) m = '0' + m; 
	if (s<10) s = '0' + s;
	
	return '' + h + ':' + m + ':' + s;
}

lots.toggleExcept = function () {
	
    if (1 == $.cookie('except_index_enabled'))
        $.cookie('except_index_enabled', 0, { expires: 31, path: '/' });
    else
        $.cookie('except_index_enabled', 1, { expires: 31, path: '/' });
	
	$('#except_list').slideToggle();
	$('#except_arrow').html('↓' == $('#except_arrow').html() ? '↑' : '↓');

}

function getCurrentTimestamp()
{
	var dt = new Date();
//	return dt.getTime()/1000.0;
	return Date.parse(lots.serverTime)/1000.0;
}