<?php

require_once(dirname(__FILE__).'/../../config/ProjectConfiguration.class.php');

$configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'prod', false);
//$configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'dev', true);
sfContext::createInstance($configuration);

$databaseManager = new sfDatabaseManager($configuration);
$databaseManager->loadConfiguration();

$request = sfContext::getInstance()->getRequest();

if (!$request->hasParameter('message'))
    die('Произошла ошибка. Попробуйте перезапустить браузер или очистить кеш.');

// Автологин
$securityFilter = new sfGuardBasicSecurityFilter(sfContext::getInstance());
$securityFilter->execute(null);

if (!sfContext::getInstance()->getUser()->isMember())
    die('ERR_LOGIN');

$user = sfContext::getInstance()->getUser()->getGuardUser();

if (!$user)
    die('ERR_NO_LOGIN');

// Обновляем последнюю активность
$user->setLastLogin(time());
$user->save();

// Добавление сообщения
print sfAuctionApi::chatAdd($user->getId(), $request->getParameter('message'));