<?php

require_once(dirname(__FILE__) . '/../../config/ProjectConfiguration.class.php');

$configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'prod', false);
//$configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'dev', true);
sfContext::createInstance($configuration);

$databaseManager = new sfDatabaseManager($configuration);
$databaseManager->loadConfiguration();

$request = sfContext::getInstance()->getRequest();

if (!$request->hasParameter('lotId'))
    die('Произошла ошибка. Попробуйте перезапустить браузер или очистить кеш.');

// Автологин
$securityFilter = new sfGuardBasicSecurityFilter(sfContext::getInstance());
$securityFilter->execute(null);

if (!sfContext::getInstance()->getUser()->isMember())
    die('ERR_LOGIN');

$user = sfContext::getInstance()->getUser()->getGuardUser();

//file_put_contents('log.txt', time() . ' - ' . $user->getId() . ' - ' . $request->getParameter('lotId') . "\r\n", FILE_APPEND);

if (!$user)
    die('ERR_NO_LOGIN');

if ($user->getBalanceBets() < 2 && !$user->getIsActive())
    die('ERR_NO_ACTIVATION');

$lotId = (int) $request->getParameter('lotId');

$lot = sfCacheManager::getObject('Lot', $lotId);

if ($lot->isOptionNovice() && $user->getIsWinner())
    die('ERR_ONLY_NOVICE');

// Обновляем последнюю активность
//$user->setLastLogin(time());
//$user->save();

// Добавление ставки
print sfAuctionApi::betRequestAdd($user->getId(), $lotId);