<?php

require_once(dirname(__FILE__).'/../../config/ProjectConfiguration.class.php');

$configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'prod', false);
//$configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'dev', true);
sfContext::createInstance($configuration);

$databaseManager = new sfDatabaseManager($configuration);
$databaseManager->loadConfiguration();

$request = sfContext::getInstance()->getRequest();

if (!$request->hasParameter('lotId') ||
    !$request->hasParameter('priceFrom') ||
    !$request->hasParameter('priceTo') ||
    !$request->hasParameter('betsLimit'))
    die('Произошла ошибка. Попробуйте перезапустить браузер или очистить кеш.');

// Автологин
$securityFilter = new sfGuardBasicSecurityFilter(sfContext::getInstance());
$securityFilter->execute(null);

if (!sfContext::getInstance()->getUser()->isMember())
    die('ERR_LOGIN');

$user = sfContext::getInstance()->getUser()->getGuardUser();

if (!$user)
    die('ERR_LOGIN');

if ($user->getBalanceBets() < 2 && !$user->getIsActive())
    die('ERR_NO_ACTIVATION');

$betsLimit = (int) $request->getParameter('betsLimit');
$priceFrom = (int) $request->getParameter('priceFrom');
$priceTo = (int) $request->getParameter('priceTo');
$lotId = (int) $request->getParameter('lotId');

if ($betsLimit <= 0)
    die('ERR_BETS_LIMIT');

if ($priceFrom <= 0)
    die('ERR_PRICE_FROM');

if ($priceTo <= 0)
    die('ERR_PRICE_TO');

if ($priceTo <= $priceFrom)
    die('ERR_PRICE_FROM_PRICE_TO');

$lot = sfCacheManager::getObject('Lot', $lotId);

if ($lot->isOptionManual())
    die('ERR_ONLY_MANUAL');

if ($lot->isOptionNovice() && $user->getIsWinner())
    die('ERR_ONLY_NOVICE');

// Обновляем последнюю активность
//$user->setLastLogin(time());
//$user->save();

// Добавление автоставки
$result = sfAuctionApi::autobetAdd(
    $user->getId(),
    $lotId,
    $priceFrom,
    $priceTo,
    $betsLimit
);

print $result ? $result : 1;