<?php

/*
 * This file is part of the symfony package.
 * (c) Fabien Potencier <fabien.potencier@symfony-project.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 *
 * @package    symfony
 * @subpackage plugin
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: sfGuardValidatorUser.class.php 12075 2008-10-08 16:15:03Z noel $
 */
class sfGuardValidatorUser extends sfValidatorBase
{

    public function configure ($options = array(), $messages = array())
    {
        $this->addOption('username_field', 'username');
        $this->addOption('password_field', 'password');
        $this->addOption('rememeber_checkbox', 'remember');
        $this->addOption('throw_global_error', false);
        
        $this->setMessage('invalid', 'Пользователя с такими логином и паролем не существует<br /> или учетная запись не активирована');
    }

    protected function doClean ($values)
    {
        $username = isset($values[$this->getOption('username_field')]) ? $values[$this->getOption('username_field')] : '';
        $password = isset($values[$this->getOption('password_field')]) ? $values[$this->getOption('password_field')] : '';
        $remember = isset($values[$this->getOption('rememeber_checkbox')]) ? $values[$this->getOption('rememeber_checkbox')] : '';
        
        // user exists?
        if ($user = sfGuardUserPeer::retrieveByUsername($username)) {
            // password is ok?
            if ($user->checkPassword($password)) {
                return array_merge($values, array(
                    'user' => $user
                ));
            }
        }
        
        if ($this->getOption('throw_global_error')) {
            throw new sfValidatorError($this, 'invalid');
        }
        
        throw new sfValidatorErrorSchema($this, array(
            $this->getOption('username_field') => new sfValidatorError($this, 'invalid')
        ));
    }
}
