<?php

/*
 * This file is part of the symfony package.
 * (c) 2004-2006 Fabien Potencier <fabien.potencier@symfony-project.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 *
 * @package    symfony
 * @subpackage plugin
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: sfGuardUser.php 9999 2008-06-29 21:24:44Z fabien $
 */
class sfGuardUser extends PluginsfGuardUser
{
    private $_monthName = array('января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря');

    public function getNameFull()
    {
        return $this->getUsername();
    }

    public function getBalanceBets()
    {
        return 0 + parent::getBalanceBets();
    }

    public function getBalanceBetsFull()
    {
        $value = 0 + $this->getBalanceBets();

        if ( (10 <= $value && 20 >= $value) || (in_array($value%10, array(0, 5, 6, 7, 8, 9))) )
            return $value . ' ставок';

        if (1 == $value%10)
            return $value . ' ставка';

        return $value . ' ставки';
    }

    public function getBalanceMoneyFormatted()
    {
        return number_format($this->getBalanceMoney(), 0, ',', ' ');
    }

    public function getTitleOrUsername()
    {
        return $this->getTitle() ? $this->getTitle() : $this->getUsername();
    }

    public function getRatingWeekFormatted()
    {
        return number_format($this->getRatingWeek(), 2, '.', ' ');
    }

    public function getRatingFormatted()
    {
        return number_format($this->getRating(), 2, '.', ' ');
    }

    public function getCreatedAtFormatted()
    {
        $createdAtTimestamp = strtotime($this->getCreatedAt());

        if (strtotime(strftime('%Y-%m-%d')) <= $createdAtTimestamp)
            return sprintf(
                'сегодня в %s:%s',
                $this->getCreatedAt('G'),
                $this->getCreatedAt('i')
            );
        else if (strtotime(strftime('%Y-%m-%d')) - 24*3600 <= $createdAtTimestamp)
            return sprintf(
                'вчера в %s:%s',
                $this->getCreatedAt('G'),
                $this->getCreatedAt('i')
            );
        else
            return sprintf(
                '%s %s в %s:%s',
                $this->getCreatedAt('j'),
                $this->_monthName[$this->getCreatedAt('n')-1],
                $this->getCreatedAt('G'),
                $this->getCreatedAt('i')
            );
    }

    public function getLastLoginFormatted()
    {
        $createdAtTimestamp = strtotime($this->getLastLogin());

        if (strtotime(strftime('%Y-%m-%d')) <= $createdAtTimestamp)
            return sprintf(
                'сегодня в %s:%s',
                $this->getLastLogin('G'),
                $this->getLastLogin('i')
            );
        else if (strtotime(strftime('%Y-%m-%d')) - 24*3600 <= $createdAtTimestamp)
            return sprintf(
                'вчера в %s:%s',
                $this->getLastLogin('G'),
                $this->getLastLogin('i')
            );
        else
            return sprintf(
                '%s %s в %s:%s',
                $this->getLastLogin('j'),
                $this->_monthName[$this->getLastLogin('n')-1],
                $this->getLastLogin('G'),
                $this->getLastLogin('i')
            );
    }

    public function getNewMailCount()
    {
        $cacheKey = 'USER_' . $this->getId() . '_NEW_MAIL_COUNT_UPD2';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(MailPeer::USER_TO_ID, $this->getId());
            $c->add(MailPeer::USER_FROM_ID, 0, Criteria::GREATER_THAN);

            $criterion = $c->getNewCriterion(MailPeer::IS_READ, false);
            $criterion->addOr($c->getNewCriterion(MailPeer::IS_READ, null));

            $c->add($criterion);

            $newMailCount = MailPeer::doCount($c);

            sfCacheManager::set($cacheKey, $newMailCount, array('MailList'), 30*24*3600);

        } else

            $newMailCount = sfCacheManager::get($cacheKey);

        return $newMailCount;
    }

    public function isOnline()
    {
        return strtotime($this->getLastLogin()) + sfConfig::get('app_profile_online_time') * 60 > time();
    }

    public function isPayable()
    {
        if (in_array($this->getId(), sfConfig::get('app_profile_administrator_ids')) ||
            in_array($this->getId(), sfConfig::get('app_profile_support_ids')))

            return true;

        if ($this->getBalanceBets() > 1)
            return true;

        $cacheKey = 'USER_' . $this->getId() . '_IS_PAYABLE';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(PaymentPeer::USER_ID, $this->getId());

            $isPayable = !!PaymentPeer::doCount($c);

            sfCacheManager::set($cacheKey, $isPayable, array('PaymentList'), 30*24*3600);

        } else

            $isPayable = sfCacheManager::get($cacheKey);

        return $isPayable;
    }

    public function save(PropelPDO $con = null)
    {
        parent::save($con);

        $this->clearCache();
    }

    public function delete(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::delete($con);
    }

    private function clearCache()
    {
        // Сам объект
        sfCacheManager::removeObject('sfGuardUser', $this->getId());

        // Все списки
        sfCacheManager::removeTag('sfGuardUserList');
    }
}
