<?php

/**
 * Base class that represents a row from the 'sf_guard_user' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * 04/09/09 20:26:39
 *
 * @package    plugins.sfGuardPlugin.lib.model.om
 */
abstract class BasesfGuardUser extends BaseObject  implements Persistent {


  const PEER = 'sfGuardUserPeer';

	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        sfGuardUserPeer
	 */
	protected static $peer;

	/**
	 * The value for the id field.
	 * @var        int
	 */
	protected $id;

	/**
	 * The value for the user_partner_id field.
	 * @var        int
	 */
	protected $user_partner_id;

	/**
	 * The value for the username field.
	 * @var        string
	 */
	protected $username;

	/**
	 * The value for the title field.
	 * @var        string
	 */
	protected $title;

	/**
	 * The value for the algorithm field.
	 * Note: this column has a database default value of: 'sha1'
	 * @var        string
	 */
	protected $algorithm;

	/**
	 * The value for the salt field.
	 * @var        string
	 */
	protected $salt;

	/**
	 * The value for the password field.
	 * @var        string
	 */
	protected $password;

	/**
	 * The value for the created_at field.
	 * @var        string
	 */
	protected $created_at;

	/**
	 * The value for the email field.
	 * @var        string
	 */
	protected $email;

	/**
	 * The value for the phone field.
	 * @var        string
	 */
	protected $phone;

	/**
	 * The value for the last_login field.
	 * @var        string
	 */
	protected $last_login;

	/**
	 * The value for the is_active field.
	 * Note: this column has a database default value of: true
	 * @var        boolean
	 */
	protected $is_active;

	/**
	 * The value for the is_super_admin field.
	 * Note: this column has a database default value of: false
	 * @var        boolean
	 */
	protected $is_super_admin;

	/**
	 * The value for the is_bot field.
	 * Note: this column has a database default value of: false
	 * @var        boolean
	 */
	protected $is_bot;

	/**
	 * The value for the is_winner field.
	 * Note: this column has a database default value of: false
	 * @var        boolean
	 */
	protected $is_winner;

	/**
	 * The value for the balance_bets field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $balance_bets;

	/**
	 * The value for the balance_money field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $balance_money;

	/**
	 * The value for the balance_partner_total field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $balance_partner_total;

	/**
	 * The value for the balance_partner_used field.
	 * Note: this column has a database default value of: 0
	 * @var        int
	 */
	protected $balance_partner_used;

	/**
	 * The value for the name field.
	 * @var        string
	 */
	protected $name;

	/**
	 * The value for the avatar field.
	 * @var        string
	 */
	protected $avatar;

	/**
	 * The value for the rating field.
	 * @var        double
	 */
	protected $rating;

	/**
	 * The value for the rating_week field.
	 * @var        double
	 */
	protected $rating_week;

	/**
	 * @var        sfGuardUser
	 */
	protected $asfGuardUserRelatedByUserPartnerId;

	/**
	 * @var        array Bet[] Collection to store aggregation of Bet objects.
	 */
	protected $collBets;

	/**
	 * @var        Criteria The criteria used to select the current contents of collBets.
	 */
	private $lastBetCriteria = null;

	/**
	 * @var        array BetRequest[] Collection to store aggregation of BetRequest objects.
	 */
	protected $collBetRequests;

	/**
	 * @var        Criteria The criteria used to select the current contents of collBetRequests.
	 */
	private $lastBetRequestCriteria = null;

	/**
	 * @var        array Chat[] Collection to store aggregation of Chat objects.
	 */
	protected $collChats;

	/**
	 * @var        Criteria The criteria used to select the current contents of collChats.
	 */
	private $lastChatCriteria = null;

	/**
	 * @var        array LotAutobet[] Collection to store aggregation of LotAutobet objects.
	 */
	protected $collLotAutobets;

	/**
	 * @var        Criteria The criteria used to select the current contents of collLotAutobets.
	 */
	private $lastLotAutobetCriteria = null;

	/**
	 * @var        array Mail[] Collection to store aggregation of Mail objects.
	 */
	protected $collMailsRelatedByUserFromId;

	/**
	 * @var        Criteria The criteria used to select the current contents of collMailsRelatedByUserFromId.
	 */
	private $lastMailRelatedByUserFromIdCriteria = null;

	/**
	 * @var        array Mail[] Collection to store aggregation of Mail objects.
	 */
	protected $collMailsRelatedByUserToId;

	/**
	 * @var        Criteria The criteria used to select the current contents of collMailsRelatedByUserToId.
	 */
	private $lastMailRelatedByUserToIdCriteria = null;

	/**
	 * @var        array PartnerPayment[] Collection to store aggregation of PartnerPayment objects.
	 */
	protected $collPartnerPayments;

	/**
	 * @var        Criteria The criteria used to select the current contents of collPartnerPayments.
	 */
	private $lastPartnerPaymentCriteria = null;

	/**
	 * @var        array Payment[] Collection to store aggregation of Payment objects.
	 */
	protected $collPayments;

	/**
	 * @var        Criteria The criteria used to select the current contents of collPayments.
	 */
	private $lastPaymentCriteria = null;

	/**
	 * @var        array UserBetsPackage[] Collection to store aggregation of UserBetsPackage objects.
	 */
	protected $collUserBetsPackages;

	/**
	 * @var        Criteria The criteria used to select the current contents of collUserBetsPackages.
	 */
	private $lastUserBetsPackageCriteria = null;

	/**
	 * @var        array UserPromoCode[] Collection to store aggregation of UserPromoCode objects.
	 */
	protected $collUserPromoCodes;

	/**
	 * @var        Criteria The criteria used to select the current contents of collUserPromoCodes.
	 */
	private $lastUserPromoCodeCriteria = null;

	/**
	 * @var        array UserVoucher[] Collection to store aggregation of UserVoucher objects.
	 */
	protected $collUserVouchers;

	/**
	 * @var        Criteria The criteria used to select the current contents of collUserVouchers.
	 */
	private $lastUserVoucherCriteria = null;

	/**
	 * @var        array sfGuardUser[] Collection to store aggregation of sfGuardUser objects.
	 */
	protected $collsfGuardUsersRelatedByUserPartnerId;

	/**
	 * @var        Criteria The criteria used to select the current contents of collsfGuardUsersRelatedByUserPartnerId.
	 */
	private $lastsfGuardUserRelatedByUserPartnerIdCriteria = null;

	/**
	 * @var        array sfGuardUserPermission[] Collection to store aggregation of sfGuardUserPermission objects.
	 */
	protected $collsfGuardUserPermissions;

	/**
	 * @var        Criteria The criteria used to select the current contents of collsfGuardUserPermissions.
	 */
	private $lastsfGuardUserPermissionCriteria = null;

	/**
	 * @var        array sfGuardUserGroup[] Collection to store aggregation of sfGuardUserGroup objects.
	 */
	protected $collsfGuardUserGroups;

	/**
	 * @var        Criteria The criteria used to select the current contents of collsfGuardUserGroups.
	 */
	private $lastsfGuardUserGroupCriteria = null;

	/**
	 * @var        array sfGuardRememberKey[] Collection to store aggregation of sfGuardRememberKey objects.
	 */
	protected $collsfGuardRememberKeys;

	/**
	 * @var        Criteria The criteria used to select the current contents of collsfGuardRememberKeys.
	 */
	private $lastsfGuardRememberKeyCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BasesfGuardUser object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
		$this->algorithm = 'sha1';
		$this->is_active = true;
		$this->is_super_admin = false;
		$this->is_bot = false;
		$this->is_winner = false;
		$this->balance_bets = 0;
		$this->balance_money = 0;
		$this->balance_partner_total = 0;
		$this->balance_partner_used = 0;
	}

	/**
	 * Get the [id] column value.
	 * 
	 * @return     int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * Get the [user_partner_id] column value.
	 * 
	 * @return     int
	 */
	public function getUserPartnerId()
	{
		return $this->user_partner_id;
	}

	/**
	 * Get the [username] column value.
	 * 
	 * @return     string
	 */
	public function getUsername()
	{
		return $this->username;
	}

	/**
	 * Get the [title] column value.
	 * 
	 * @return     string
	 */
	public function getTitle()
	{
		return $this->title;
	}

	/**
	 * Get the [algorithm] column value.
	 * 
	 * @return     string
	 */
	public function getAlgorithm()
	{
		return $this->algorithm;
	}

	/**
	 * Get the [salt] column value.
	 * 
	 * @return     string
	 */
	public function getSalt()
	{
		return $this->salt;
	}

	/**
	 * Get the [password] column value.
	 * 
	 * @return     string
	 */
	public function getPassword()
	{
		return $this->password;
	}

	/**
	 * Get the [optionally formatted] temporal [created_at] column value.
	 * 
	 *
	 * @param      string $format The date/time format string (either date()-style or strftime()-style).
	 *							If format is NULL, then the raw DateTime object will be returned.
	 * @return     mixed Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
	 * @throws     PropelException - if unable to parse/validate the date/time value.
	 */
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{
		if ($this->created_at === null) {
			return null;
		}


		if ($this->created_at === '0000-00-00 00:00:00') {
			// while technically this is not a default value of NULL,
			// this seems to be closest in meaning.
			return null;
		} else {
			try {
				$dt = new DateTime($this->created_at);
			} catch (Exception $x) {
				throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->created_at, true), $x);
			}
		}

		if ($format === null) {
			// Because propel.useDateTimeClass is TRUE, we return a DateTime object.
			return $dt;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $dt->format('U'));
		} else {
			return $dt->format($format);
		}
	}

	/**
	 * Get the [email] column value.
	 * 
	 * @return     string
	 */
	public function getEmail()
	{
		return $this->email;
	}

	/**
	 * Get the [phone] column value.
	 * 
	 * @return     string
	 */
	public function getPhone()
	{
		return $this->phone;
	}

	/**
	 * Get the [optionally formatted] temporal [last_login] column value.
	 * 
	 *
	 * @param      string $format The date/time format string (either date()-style or strftime()-style).
	 *							If format is NULL, then the raw DateTime object will be returned.
	 * @return     mixed Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
	 * @throws     PropelException - if unable to parse/validate the date/time value.
	 */
	public function getLastLogin($format = 'Y-m-d H:i:s')
	{
		if ($this->last_login === null) {
			return null;
		}


		if ($this->last_login === '0000-00-00 00:00:00') {
			// while technically this is not a default value of NULL,
			// this seems to be closest in meaning.
			return null;
		} else {
			try {
				$dt = new DateTime($this->last_login);
			} catch (Exception $x) {
				throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->last_login, true), $x);
			}
		}

		if ($format === null) {
			// Because propel.useDateTimeClass is TRUE, we return a DateTime object.
			return $dt;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $dt->format('U'));
		} else {
			return $dt->format($format);
		}
	}

	/**
	 * Get the [is_active] column value.
	 * 
	 * @return     boolean
	 */
	public function getIsActive()
	{
		return $this->is_active;
	}

	/**
	 * Get the [is_super_admin] column value.
	 * 
	 * @return     boolean
	 */
	public function getIsSuperAdmin()
	{
		return $this->is_super_admin;
	}

	/**
	 * Get the [is_bot] column value.
	 * 
	 * @return     boolean
	 */
	public function getIsBot()
	{
		return $this->is_bot;
	}

	/**
	 * Get the [is_winner] column value.
	 * 
	 * @return     boolean
	 */
	public function getIsWinner()
	{
		return $this->is_winner;
	}

	/**
	 * Get the [balance_bets] column value.
	 * 
	 * @return     int
	 */
	public function getBalanceBets()
	{
		return $this->balance_bets;
	}

	/**
	 * Get the [balance_money] column value.
	 * 
	 * @return     int
	 */
	public function getBalanceMoney()
	{
		return $this->balance_money;
	}

	/**
	 * Get the [balance_partner_total] column value.
	 * 
	 * @return     int
	 */
	public function getBalancePartnerTotal()
	{
		return $this->balance_partner_total;
	}

	/**
	 * Get the [balance_partner_used] column value.
	 * 
	 * @return     int
	 */
	public function getBalancePartnerUsed()
	{
		return $this->balance_partner_used;
	}

	/**
	 * Get the [name] column value.
	 * 
	 * @return     string
	 */
	public function getName()
	{
		return $this->name;
	}

	/**
	 * Get the [avatar] column value.
	 * 
	 * @return     string
	 */
	public function getAvatar()
	{
		return $this->avatar;
	}

	/**
	 * Get the [rating] column value.
	 * 
	 * @return     double
	 */
	public function getRating()
	{
		return $this->rating;
	}

	/**
	 * Get the [rating_week] column value.
	 * 
	 * @return     double
	 */
	public function getRatingWeek()
	{
		return $this->rating_week;
	}

	/**
	 * Set the value of [id] column.
	 * 
	 * @param      int $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->id !== $v) {
			$this->id = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::ID;
		}

		return $this;
	} // setId()

	/**
	 * Set the value of [user_partner_id] column.
	 * 
	 * @param      int $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setUserPartnerId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->user_partner_id !== $v) {
			$this->user_partner_id = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::USER_PARTNER_ID;
		}

		if ($this->asfGuardUserRelatedByUserPartnerId !== null && $this->asfGuardUserRelatedByUserPartnerId->getId() !== $v) {
			$this->asfGuardUserRelatedByUserPartnerId = null;
		}

		return $this;
	} // setUserPartnerId()

	/**
	 * Set the value of [username] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setUsername($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->username !== $v) {
			$this->username = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::USERNAME;
		}

		return $this;
	} // setUsername()

	/**
	 * Set the value of [title] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setTitle($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->title !== $v) {
			$this->title = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::TITLE;
		}

		return $this;
	} // setTitle()

	/**
	 * Set the value of [algorithm] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setAlgorithm($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->algorithm !== $v || $v === 'sha1') {
			$this->algorithm = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::ALGORITHM;
		}

		return $this;
	} // setAlgorithm()

	/**
	 * Set the value of [salt] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setSalt($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->salt !== $v) {
			$this->salt = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::SALT;
		}

		return $this;
	} // setSalt()

	/**
	 * Set the value of [password] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setPassword($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->password !== $v) {
			$this->password = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::PASSWORD;
		}

		return $this;
	} // setPassword()

	/**
	 * Sets the value of [created_at] column to a normalized version of the date/time value specified.
	 * 
	 * @param      mixed $v string, integer (timestamp), or DateTime value.  Empty string will
	 *						be treated as NULL for temporal objects.
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setCreatedAt($v)
	{
		// we treat '' as NULL for temporal objects because DateTime('') == DateTime('now')
		// -- which is unexpected, to say the least.
		if ($v === null || $v === '') {
			$dt = null;
		} elseif ($v instanceof DateTime) {
			$dt = $v;
		} else {
			// some string/numeric value passed; we normalize that so that we can
			// validate it.
			try {
				if (is_numeric($v)) { // if it's a unix timestamp
					$dt = new DateTime('@'.$v, new DateTimeZone('UTC'));
					// We have to explicitly specify and then change the time zone because of a
					// DateTime bug: http://bugs.php.net/bug.php?id=43003
					$dt->setTimeZone(new DateTimeZone(date_default_timezone_get()));
				} else {
					$dt = new DateTime($v);
				}
			} catch (Exception $x) {
				throw new PropelException('Error parsing date/time value: ' . var_export($v, true), $x);
			}
		}

		if ( $this->created_at !== null || $dt !== null ) {
			// (nested ifs are a little easier to read in this case)

			$currNorm = ($this->created_at !== null && $tmpDt = new DateTime($this->created_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
			$newNorm = ($dt !== null) ? $dt->format('Y-m-d H:i:s') : null;

			if ( ($currNorm !== $newNorm) // normalized values don't match 
					)
			{
				$this->created_at = ($dt ? $dt->format('Y-m-d H:i:s') : null);
				$this->modifiedColumns[] = sfGuardUserPeer::CREATED_AT;
			}
		} // if either are not null

		return $this;
	} // setCreatedAt()

	/**
	 * Set the value of [email] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setEmail($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->email !== $v) {
			$this->email = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::EMAIL;
		}

		return $this;
	} // setEmail()

	/**
	 * Set the value of [phone] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setPhone($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->phone !== $v) {
			$this->phone = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::PHONE;
		}

		return $this;
	} // setPhone()

	/**
	 * Sets the value of [last_login] column to a normalized version of the date/time value specified.
	 * 
	 * @param      mixed $v string, integer (timestamp), or DateTime value.  Empty string will
	 *						be treated as NULL for temporal objects.
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setLastLogin($v)
	{
		// we treat '' as NULL for temporal objects because DateTime('') == DateTime('now')
		// -- which is unexpected, to say the least.
		if ($v === null || $v === '') {
			$dt = null;
		} elseif ($v instanceof DateTime) {
			$dt = $v;
		} else {
			// some string/numeric value passed; we normalize that so that we can
			// validate it.
			try {
				if (is_numeric($v)) { // if it's a unix timestamp
					$dt = new DateTime('@'.$v, new DateTimeZone('UTC'));
					// We have to explicitly specify and then change the time zone because of a
					// DateTime bug: http://bugs.php.net/bug.php?id=43003
					$dt->setTimeZone(new DateTimeZone(date_default_timezone_get()));
				} else {
					$dt = new DateTime($v);
				}
			} catch (Exception $x) {
				throw new PropelException('Error parsing date/time value: ' . var_export($v, true), $x);
			}
		}

		if ( $this->last_login !== null || $dt !== null ) {
			// (nested ifs are a little easier to read in this case)

			$currNorm = ($this->last_login !== null && $tmpDt = new DateTime($this->last_login)) ? $tmpDt->format('Y-m-d H:i:s') : null;
			$newNorm = ($dt !== null) ? $dt->format('Y-m-d H:i:s') : null;

			if ( ($currNorm !== $newNorm) // normalized values don't match 
					)
			{
				$this->last_login = ($dt ? $dt->format('Y-m-d H:i:s') : null);
				$this->modifiedColumns[] = sfGuardUserPeer::LAST_LOGIN;
			}
		} // if either are not null

		return $this;
	} // setLastLogin()

	/**
	 * Set the value of [is_active] column.
	 * 
	 * @param      boolean $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setIsActive($v)
	{
		if ($v !== null) {
			$v = (boolean) $v;
		}

		if ($this->is_active !== $v || $v === true) {
			$this->is_active = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::IS_ACTIVE;
		}

		return $this;
	} // setIsActive()

	/**
	 * Set the value of [is_super_admin] column.
	 * 
	 * @param      boolean $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setIsSuperAdmin($v)
	{
		if ($v !== null) {
			$v = (boolean) $v;
		}

		if ($this->is_super_admin !== $v || $v === false) {
			$this->is_super_admin = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::IS_SUPER_ADMIN;
		}

		return $this;
	} // setIsSuperAdmin()

	/**
	 * Set the value of [is_bot] column.
	 * 
	 * @param      boolean $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setIsBot($v)
	{
		if ($v !== null) {
			$v = (boolean) $v;
		}

		if ($this->is_bot !== $v || $v === false) {
			$this->is_bot = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::IS_BOT;
		}

		return $this;
	} // setIsBot()

	/**
	 * Set the value of [is_winner] column.
	 * 
	 * @param      boolean $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setIsWinner($v)
	{
		if ($v !== null) {
			$v = (boolean) $v;
		}

		if ($this->is_winner !== $v || $v === false) {
			$this->is_winner = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::IS_WINNER;
		}

		return $this;
	} // setIsWinner()

	/**
	 * Set the value of [balance_bets] column.
	 * 
	 * @param      int $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setBalanceBets($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->balance_bets !== $v || $v === 0) {
			$this->balance_bets = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::BALANCE_BETS;
		}

		return $this;
	} // setBalanceBets()

	/**
	 * Set the value of [balance_money] column.
	 * 
	 * @param      int $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setBalanceMoney($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->balance_money !== $v || $v === 0) {
			$this->balance_money = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::BALANCE_MONEY;
		}

		return $this;
	} // setBalanceMoney()

	/**
	 * Set the value of [balance_partner_total] column.
	 * 
	 * @param      int $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setBalancePartnerTotal($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->balance_partner_total !== $v || $v === 0) {
			$this->balance_partner_total = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::BALANCE_PARTNER_TOTAL;
		}

		return $this;
	} // setBalancePartnerTotal()

	/**
	 * Set the value of [balance_partner_used] column.
	 * 
	 * @param      int $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setBalancePartnerUsed($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->balance_partner_used !== $v || $v === 0) {
			$this->balance_partner_used = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::BALANCE_PARTNER_USED;
		}

		return $this;
	} // setBalancePartnerUsed()

	/**
	 * Set the value of [name] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setName($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->name !== $v) {
			$this->name = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::NAME;
		}

		return $this;
	} // setName()

	/**
	 * Set the value of [avatar] column.
	 * 
	 * @param      string $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setAvatar($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->avatar !== $v) {
			$this->avatar = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::AVATAR;
		}

		return $this;
	} // setAvatar()

	/**
	 * Set the value of [rating] column.
	 * 
	 * @param      double $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setRating($v)
	{
		if ($v !== null) {
			$v = (double) $v;
		}

		if ($this->rating !== $v) {
			$this->rating = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::RATING;
		}

		return $this;
	} // setRating()

	/**
	 * Set the value of [rating_week] column.
	 * 
	 * @param      double $v new value
	 * @return     sfGuardUser The current object (for fluent API support)
	 */
	public function setRatingWeek($v)
	{
		if ($v !== null) {
			$v = (double) $v;
		}

		if ($this->rating_week !== $v) {
			$this->rating_week = $v;
			$this->modifiedColumns[] = sfGuardUserPeer::RATING_WEEK;
		}

		return $this;
	} // setRatingWeek()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array(sfGuardUserPeer::ALGORITHM,sfGuardUserPeer::IS_ACTIVE,sfGuardUserPeer::IS_SUPER_ADMIN,sfGuardUserPeer::IS_BOT,sfGuardUserPeer::IS_WINNER,sfGuardUserPeer::BALANCE_BETS,sfGuardUserPeer::BALANCE_MONEY,sfGuardUserPeer::BALANCE_PARTNER_TOTAL,sfGuardUserPeer::BALANCE_PARTNER_USED))) {
				return false;
			}

			if ($this->algorithm !== 'sha1') {
				return false;
			}

			if ($this->is_active !== true) {
				return false;
			}

			if ($this->is_super_admin !== false) {
				return false;
			}

			if ($this->is_bot !== false) {
				return false;
			}

			if ($this->is_winner !== false) {
				return false;
			}

			if ($this->balance_bets !== 0) {
				return false;
			}

			if ($this->balance_money !== 0) {
				return false;
			}

			if ($this->balance_partner_total !== 0) {
				return false;
			}

			if ($this->balance_partner_used !== 0) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->user_partner_id = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->username = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->title = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->algorithm = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->salt = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
			$this->password = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
			$this->created_at = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
			$this->email = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
			$this->phone = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
			$this->last_login = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
			$this->is_active = ($row[$startcol + 11] !== null) ? (boolean) $row[$startcol + 11] : null;
			$this->is_super_admin = ($row[$startcol + 12] !== null) ? (boolean) $row[$startcol + 12] : null;
			$this->is_bot = ($row[$startcol + 13] !== null) ? (boolean) $row[$startcol + 13] : null;
			$this->is_winner = ($row[$startcol + 14] !== null) ? (boolean) $row[$startcol + 14] : null;
			$this->balance_bets = ($row[$startcol + 15] !== null) ? (int) $row[$startcol + 15] : null;
			$this->balance_money = ($row[$startcol + 16] !== null) ? (int) $row[$startcol + 16] : null;
			$this->balance_partner_total = ($row[$startcol + 17] !== null) ? (int) $row[$startcol + 17] : null;
			$this->balance_partner_used = ($row[$startcol + 18] !== null) ? (int) $row[$startcol + 18] : null;
			$this->name = ($row[$startcol + 19] !== null) ? (string) $row[$startcol + 19] : null;
			$this->avatar = ($row[$startcol + 20] !== null) ? (string) $row[$startcol + 20] : null;
			$this->rating = ($row[$startcol + 21] !== null) ? (double) $row[$startcol + 21] : null;
			$this->rating_week = ($row[$startcol + 22] !== null) ? (double) $row[$startcol + 22] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 23; // 23 = sfGuardUserPeer::NUM_COLUMNS - sfGuardUserPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating sfGuardUser object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->asfGuardUserRelatedByUserPartnerId !== null && $this->user_partner_id !== $this->asfGuardUserRelatedByUserPartnerId->getId()) {
			$this->asfGuardUserRelatedByUserPartnerId = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(sfGuardUserPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = sfGuardUserPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->asfGuardUserRelatedByUserPartnerId = null;
			$this->collBets = null;
			$this->lastBetCriteria = null;

			$this->collBetRequests = null;
			$this->lastBetRequestCriteria = null;

			$this->collChats = null;
			$this->lastChatCriteria = null;

			$this->collLotAutobets = null;
			$this->lastLotAutobetCriteria = null;

			$this->collMailsRelatedByUserFromId = null;
			$this->lastMailRelatedByUserFromIdCriteria = null;

			$this->collMailsRelatedByUserToId = null;
			$this->lastMailRelatedByUserToIdCriteria = null;

			$this->collPartnerPayments = null;
			$this->lastPartnerPaymentCriteria = null;

			$this->collPayments = null;
			$this->lastPaymentCriteria = null;

			$this->collUserBetsPackages = null;
			$this->lastUserBetsPackageCriteria = null;

			$this->collUserPromoCodes = null;
			$this->lastUserPromoCodeCriteria = null;

			$this->collUserVouchers = null;
			$this->lastUserVoucherCriteria = null;

			$this->collsfGuardUsersRelatedByUserPartnerId = null;
			$this->lastsfGuardUserRelatedByUserPartnerIdCriteria = null;

			$this->collsfGuardUserPermissions = null;
			$this->lastsfGuardUserPermissionCriteria = null;

			$this->collsfGuardUserGroups = null;
			$this->lastsfGuardUserGroupCriteria = null;

			$this->collsfGuardRememberKeys = null;
			$this->lastsfGuardRememberKeyCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BasesfGuardUser:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(sfGuardUserPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			sfGuardUserPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BasesfGuardUser:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BasesfGuardUser:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(sfGuardUserPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(sfGuardUserPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
    foreach (sfMixer::getCallables('BasesfGuardUser:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			sfGuardUserPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->asfGuardUserRelatedByUserPartnerId !== null) {
				if ($this->asfGuardUserRelatedByUserPartnerId->isModified() || $this->asfGuardUserRelatedByUserPartnerId->isNew()) {
					$affectedRows += $this->asfGuardUserRelatedByUserPartnerId->save($con);
				}
				$this->setsfGuardUserRelatedByUserPartnerId($this->asfGuardUserRelatedByUserPartnerId);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = sfGuardUserPeer::ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = sfGuardUserPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += sfGuardUserPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collBets !== null) {
				foreach ($this->collBets as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collBetRequests !== null) {
				foreach ($this->collBetRequests as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collChats !== null) {
				foreach ($this->collChats as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collLotAutobets !== null) {
				foreach ($this->collLotAutobets as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collMailsRelatedByUserFromId !== null) {
				foreach ($this->collMailsRelatedByUserFromId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collMailsRelatedByUserToId !== null) {
				foreach ($this->collMailsRelatedByUserToId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collPartnerPayments !== null) {
				foreach ($this->collPartnerPayments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collPayments !== null) {
				foreach ($this->collPayments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collUserBetsPackages !== null) {
				foreach ($this->collUserBetsPackages as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collUserPromoCodes !== null) {
				foreach ($this->collUserPromoCodes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collUserVouchers !== null) {
				foreach ($this->collUserVouchers as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collsfGuardUsersRelatedByUserPartnerId !== null) {
				foreach ($this->collsfGuardUsersRelatedByUserPartnerId as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collsfGuardUserPermissions !== null) {
				foreach ($this->collsfGuardUserPermissions as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collsfGuardUserGroups !== null) {
				foreach ($this->collsfGuardUserGroups as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collsfGuardRememberKeys !== null) {
				foreach ($this->collsfGuardRememberKeys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->asfGuardUserRelatedByUserPartnerId !== null) {
				if (!$this->asfGuardUserRelatedByUserPartnerId->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUserRelatedByUserPartnerId->getValidationFailures());
				}
			}


			if (($retval = sfGuardUserPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collBets !== null) {
					foreach ($this->collBets as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collBetRequests !== null) {
					foreach ($this->collBetRequests as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collChats !== null) {
					foreach ($this->collChats as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collLotAutobets !== null) {
					foreach ($this->collLotAutobets as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collMailsRelatedByUserFromId !== null) {
					foreach ($this->collMailsRelatedByUserFromId as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collMailsRelatedByUserToId !== null) {
					foreach ($this->collMailsRelatedByUserToId as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collPartnerPayments !== null) {
					foreach ($this->collPartnerPayments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collPayments !== null) {
					foreach ($this->collPayments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collUserBetsPackages !== null) {
					foreach ($this->collUserBetsPackages as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collUserPromoCodes !== null) {
					foreach ($this->collUserPromoCodes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collUserVouchers !== null) {
					foreach ($this->collUserVouchers as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collsfGuardUsersRelatedByUserPartnerId !== null) {
					foreach ($this->collsfGuardUsersRelatedByUserPartnerId as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collsfGuardUserPermissions !== null) {
					foreach ($this->collsfGuardUserPermissions as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collsfGuardUserGroups !== null) {
					foreach ($this->collsfGuardUserGroups as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collsfGuardRememberKeys !== null) {
					foreach ($this->collsfGuardRememberKeys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = sfGuardUserPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getUserPartnerId();
				break;
			case 2:
				return $this->getUsername();
				break;
			case 3:
				return $this->getTitle();
				break;
			case 4:
				return $this->getAlgorithm();
				break;
			case 5:
				return $this->getSalt();
				break;
			case 6:
				return $this->getPassword();
				break;
			case 7:
				return $this->getCreatedAt();
				break;
			case 8:
				return $this->getEmail();
				break;
			case 9:
				return $this->getPhone();
				break;
			case 10:
				return $this->getLastLogin();
				break;
			case 11:
				return $this->getIsActive();
				break;
			case 12:
				return $this->getIsSuperAdmin();
				break;
			case 13:
				return $this->getIsBot();
				break;
			case 14:
				return $this->getIsWinner();
				break;
			case 15:
				return $this->getBalanceBets();
				break;
			case 16:
				return $this->getBalanceMoney();
				break;
			case 17:
				return $this->getBalancePartnerTotal();
				break;
			case 18:
				return $this->getBalancePartnerUsed();
				break;
			case 19:
				return $this->getName();
				break;
			case 20:
				return $this->getAvatar();
				break;
			case 21:
				return $this->getRating();
				break;
			case 22:
				return $this->getRatingWeek();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = sfGuardUserPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getUserPartnerId(),
			$keys[2] => $this->getUsername(),
			$keys[3] => $this->getTitle(),
			$keys[4] => $this->getAlgorithm(),
			$keys[5] => $this->getSalt(),
			$keys[6] => $this->getPassword(),
			$keys[7] => $this->getCreatedAt(),
			$keys[8] => $this->getEmail(),
			$keys[9] => $this->getPhone(),
			$keys[10] => $this->getLastLogin(),
			$keys[11] => $this->getIsActive(),
			$keys[12] => $this->getIsSuperAdmin(),
			$keys[13] => $this->getIsBot(),
			$keys[14] => $this->getIsWinner(),
			$keys[15] => $this->getBalanceBets(),
			$keys[16] => $this->getBalanceMoney(),
			$keys[17] => $this->getBalancePartnerTotal(),
			$keys[18] => $this->getBalancePartnerUsed(),
			$keys[19] => $this->getName(),
			$keys[20] => $this->getAvatar(),
			$keys[21] => $this->getRating(),
			$keys[22] => $this->getRatingWeek(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = sfGuardUserPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setUserPartnerId($value);
				break;
			case 2:
				$this->setUsername($value);
				break;
			case 3:
				$this->setTitle($value);
				break;
			case 4:
				$this->setAlgorithm($value);
				break;
			case 5:
				$this->setSalt($value);
				break;
			case 6:
				$this->setPassword($value);
				break;
			case 7:
				$this->setCreatedAt($value);
				break;
			case 8:
				$this->setEmail($value);
				break;
			case 9:
				$this->setPhone($value);
				break;
			case 10:
				$this->setLastLogin($value);
				break;
			case 11:
				$this->setIsActive($value);
				break;
			case 12:
				$this->setIsSuperAdmin($value);
				break;
			case 13:
				$this->setIsBot($value);
				break;
			case 14:
				$this->setIsWinner($value);
				break;
			case 15:
				$this->setBalanceBets($value);
				break;
			case 16:
				$this->setBalanceMoney($value);
				break;
			case 17:
				$this->setBalancePartnerTotal($value);
				break;
			case 18:
				$this->setBalancePartnerUsed($value);
				break;
			case 19:
				$this->setName($value);
				break;
			case 20:
				$this->setAvatar($value);
				break;
			case 21:
				$this->setRating($value);
				break;
			case 22:
				$this->setRatingWeek($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = sfGuardUserPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUserPartnerId($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setUsername($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setTitle($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setAlgorithm($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setSalt($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setPassword($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setCreatedAt($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setEmail($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setPhone($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setLastLogin($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setIsActive($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setIsSuperAdmin($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setIsBot($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setIsWinner($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setBalanceBets($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setBalanceMoney($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setBalancePartnerTotal($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setBalancePartnerUsed($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setName($arr[$keys[19]]);
		if (array_key_exists($keys[20], $arr)) $this->setAvatar($arr[$keys[20]]);
		if (array_key_exists($keys[21], $arr)) $this->setRating($arr[$keys[21]]);
		if (array_key_exists($keys[22], $arr)) $this->setRatingWeek($arr[$keys[22]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);

		if ($this->isColumnModified(sfGuardUserPeer::ID)) $criteria->add(sfGuardUserPeer::ID, $this->id);
		if ($this->isColumnModified(sfGuardUserPeer::USER_PARTNER_ID)) $criteria->add(sfGuardUserPeer::USER_PARTNER_ID, $this->user_partner_id);
		if ($this->isColumnModified(sfGuardUserPeer::USERNAME)) $criteria->add(sfGuardUserPeer::USERNAME, $this->username);
		if ($this->isColumnModified(sfGuardUserPeer::TITLE)) $criteria->add(sfGuardUserPeer::TITLE, $this->title);
		if ($this->isColumnModified(sfGuardUserPeer::ALGORITHM)) $criteria->add(sfGuardUserPeer::ALGORITHM, $this->algorithm);
		if ($this->isColumnModified(sfGuardUserPeer::SALT)) $criteria->add(sfGuardUserPeer::SALT, $this->salt);
		if ($this->isColumnModified(sfGuardUserPeer::PASSWORD)) $criteria->add(sfGuardUserPeer::PASSWORD, $this->password);
		if ($this->isColumnModified(sfGuardUserPeer::CREATED_AT)) $criteria->add(sfGuardUserPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(sfGuardUserPeer::EMAIL)) $criteria->add(sfGuardUserPeer::EMAIL, $this->email);
		if ($this->isColumnModified(sfGuardUserPeer::PHONE)) $criteria->add(sfGuardUserPeer::PHONE, $this->phone);
		if ($this->isColumnModified(sfGuardUserPeer::LAST_LOGIN)) $criteria->add(sfGuardUserPeer::LAST_LOGIN, $this->last_login);
		if ($this->isColumnModified(sfGuardUserPeer::IS_ACTIVE)) $criteria->add(sfGuardUserPeer::IS_ACTIVE, $this->is_active);
		if ($this->isColumnModified(sfGuardUserPeer::IS_SUPER_ADMIN)) $criteria->add(sfGuardUserPeer::IS_SUPER_ADMIN, $this->is_super_admin);
		if ($this->isColumnModified(sfGuardUserPeer::IS_BOT)) $criteria->add(sfGuardUserPeer::IS_BOT, $this->is_bot);
		if ($this->isColumnModified(sfGuardUserPeer::IS_WINNER)) $criteria->add(sfGuardUserPeer::IS_WINNER, $this->is_winner);
		if ($this->isColumnModified(sfGuardUserPeer::BALANCE_BETS)) $criteria->add(sfGuardUserPeer::BALANCE_BETS, $this->balance_bets);
		if ($this->isColumnModified(sfGuardUserPeer::BALANCE_MONEY)) $criteria->add(sfGuardUserPeer::BALANCE_MONEY, $this->balance_money);
		if ($this->isColumnModified(sfGuardUserPeer::BALANCE_PARTNER_TOTAL)) $criteria->add(sfGuardUserPeer::BALANCE_PARTNER_TOTAL, $this->balance_partner_total);
		if ($this->isColumnModified(sfGuardUserPeer::BALANCE_PARTNER_USED)) $criteria->add(sfGuardUserPeer::BALANCE_PARTNER_USED, $this->balance_partner_used);
		if ($this->isColumnModified(sfGuardUserPeer::NAME)) $criteria->add(sfGuardUserPeer::NAME, $this->name);
		if ($this->isColumnModified(sfGuardUserPeer::AVATAR)) $criteria->add(sfGuardUserPeer::AVATAR, $this->avatar);
		if ($this->isColumnModified(sfGuardUserPeer::RATING)) $criteria->add(sfGuardUserPeer::RATING, $this->rating);
		if ($this->isColumnModified(sfGuardUserPeer::RATING_WEEK)) $criteria->add(sfGuardUserPeer::RATING_WEEK, $this->rating_week);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);

		$criteria->add(sfGuardUserPeer::ID, $this->id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	/**
	 * Generic method to set the primary key (id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of sfGuardUser (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setUserPartnerId($this->user_partner_id);

		$copyObj->setUsername($this->username);

		$copyObj->setTitle($this->title);

		$copyObj->setAlgorithm($this->algorithm);

		$copyObj->setSalt($this->salt);

		$copyObj->setPassword($this->password);

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setEmail($this->email);

		$copyObj->setPhone($this->phone);

		$copyObj->setLastLogin($this->last_login);

		$copyObj->setIsActive($this->is_active);

		$copyObj->setIsSuperAdmin($this->is_super_admin);

		$copyObj->setIsBot($this->is_bot);

		$copyObj->setIsWinner($this->is_winner);

		$copyObj->setBalanceBets($this->balance_bets);

		$copyObj->setBalanceMoney($this->balance_money);

		$copyObj->setBalancePartnerTotal($this->balance_partner_total);

		$copyObj->setBalancePartnerUsed($this->balance_partner_used);

		$copyObj->setName($this->name);

		$copyObj->setAvatar($this->avatar);

		$copyObj->setRating($this->rating);

		$copyObj->setRatingWeek($this->rating_week);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getBets() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addBet($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getBetRequests() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addBetRequest($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getChats() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addChat($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getLotAutobets() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addLotAutobet($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getMailsRelatedByUserFromId() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addMailRelatedByUserFromId($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getMailsRelatedByUserToId() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addMailRelatedByUserToId($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getPartnerPayments() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addPartnerPayment($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getPayments() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addPayment($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getUserBetsPackages() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addUserBetsPackage($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getUserPromoCodes() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addUserPromoCode($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getUserVouchers() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addUserVoucher($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getsfGuardUsersRelatedByUserPartnerId() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addsfGuardUserRelatedByUserPartnerId($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getsfGuardUserPermissions() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addsfGuardUserPermission($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getsfGuardUserGroups() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addsfGuardUserGroup($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getsfGuardRememberKeys() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addsfGuardRememberKey($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     sfGuardUser Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     sfGuardUserPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new sfGuardUserPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a sfGuardUser object.
	 *
	 * @param      sfGuardUser $v
	 * @return     sfGuardUser The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setsfGuardUserRelatedByUserPartnerId(sfGuardUser $v = null)
	{
		if ($v === null) {
			$this->setUserPartnerId(NULL);
		} else {
			$this->setUserPartnerId($v->getId());
		}

		$this->asfGuardUserRelatedByUserPartnerId = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the sfGuardUser object, it will not be re-added.
		if ($v !== null) {
			$v->addsfGuardUserRelatedByUserPartnerId($this);
		}

		return $this;
	}


	/**
	 * Get the associated sfGuardUser object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     sfGuardUser The associated sfGuardUser object.
	 * @throws     PropelException
	 */
	public function getsfGuardUserRelatedByUserPartnerId(PropelPDO $con = null)
	{
		if ($this->asfGuardUserRelatedByUserPartnerId === null && ($this->user_partner_id !== null)) {
			$c = new Criteria(sfGuardUserPeer::DATABASE_NAME);
			$c->add(sfGuardUserPeer::ID, $this->user_partner_id);
			$this->asfGuardUserRelatedByUserPartnerId = sfGuardUserPeer::doSelectOne($c, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->asfGuardUserRelatedByUserPartnerId->addsfGuardUsersRelatedByUserPartnerId($this);
			 */
		}
		return $this->asfGuardUserRelatedByUserPartnerId;
	}

	/**
	 * Clears out the collBets collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addBets()
	 */
	public function clearBets()
	{
		$this->collBets = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collBets collection (array).
	 *
	 * By default this just sets the collBets collection to an empty array (like clearcollBets());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initBets()
	{
		$this->collBets = array();
	}

	/**
	 * Gets an array of Bet objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related Bets from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Bet[]
	 * @throws     PropelException
	 */
	public function getBets($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBets === null) {
			if ($this->isNew()) {
			   $this->collBets = array();
			} else {

				$criteria->add(BetPeer::USER_ID, $this->id);

				BetPeer::addSelectColumns($criteria);
				$this->collBets = BetPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(BetPeer::USER_ID, $this->id);

				BetPeer::addSelectColumns($criteria);
				if (!isset($this->lastBetCriteria) || !$this->lastBetCriteria->equals($criteria)) {
					$this->collBets = BetPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBetCriteria = $criteria;
		return $this->collBets;
	}

	/**
	 * Returns the number of related Bet objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Bet objects.
	 * @throws     PropelException
	 */
	public function countBets(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collBets === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(BetPeer::USER_ID, $this->id);

				$count = BetPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(BetPeer::USER_ID, $this->id);

				if (!isset($this->lastBetCriteria) || !$this->lastBetCriteria->equals($criteria)) {
					$count = BetPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collBets);
				}
			} else {
				$count = count($this->collBets);
			}
		}
		$this->lastBetCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Bet object to this object
	 * through the Bet foreign key attribute.
	 *
	 * @param      Bet $l Bet
	 * @return     void
	 * @throws     PropelException
	 */
	public function addBet(Bet $l)
	{
		if ($this->collBets === null) {
			$this->initBets();
		}
		if (!in_array($l, $this->collBets, true)) { // only add it if the **same** object is not already associated
			array_push($this->collBets, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related Bets from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getBetsJoinAuctionBetType($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBets === null) {
			if ($this->isNew()) {
				$this->collBets = array();
			} else {

				$criteria->add(BetPeer::USER_ID, $this->id);

				$this->collBets = BetPeer::doSelectJoinAuctionBetType($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(BetPeer::USER_ID, $this->id);

			if (!isset($this->lastBetCriteria) || !$this->lastBetCriteria->equals($criteria)) {
				$this->collBets = BetPeer::doSelectJoinAuctionBetType($criteria, $con, $join_behavior);
			}
		}
		$this->lastBetCriteria = $criteria;

		return $this->collBets;
	}

	/**
	 * Clears out the collBetRequests collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addBetRequests()
	 */
	public function clearBetRequests()
	{
		$this->collBetRequests = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collBetRequests collection (array).
	 *
	 * By default this just sets the collBetRequests collection to an empty array (like clearcollBetRequests());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initBetRequests()
	{
		$this->collBetRequests = array();
	}

	/**
	 * Gets an array of BetRequest objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related BetRequests from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array BetRequest[]
	 * @throws     PropelException
	 */
	public function getBetRequests($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBetRequests === null) {
			if ($this->isNew()) {
			   $this->collBetRequests = array();
			} else {

				$criteria->add(BetRequestPeer::USER_ID, $this->id);

				BetRequestPeer::addSelectColumns($criteria);
				$this->collBetRequests = BetRequestPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(BetRequestPeer::USER_ID, $this->id);

				BetRequestPeer::addSelectColumns($criteria);
				if (!isset($this->lastBetRequestCriteria) || !$this->lastBetRequestCriteria->equals($criteria)) {
					$this->collBetRequests = BetRequestPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBetRequestCriteria = $criteria;
		return $this->collBetRequests;
	}

	/**
	 * Returns the number of related BetRequest objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related BetRequest objects.
	 * @throws     PropelException
	 */
	public function countBetRequests(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collBetRequests === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(BetRequestPeer::USER_ID, $this->id);

				$count = BetRequestPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(BetRequestPeer::USER_ID, $this->id);

				if (!isset($this->lastBetRequestCriteria) || !$this->lastBetRequestCriteria->equals($criteria)) {
					$count = BetRequestPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collBetRequests);
				}
			} else {
				$count = count($this->collBetRequests);
			}
		}
		$this->lastBetRequestCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a BetRequest object to this object
	 * through the BetRequest foreign key attribute.
	 *
	 * @param      BetRequest $l BetRequest
	 * @return     void
	 * @throws     PropelException
	 */
	public function addBetRequest(BetRequest $l)
	{
		if ($this->collBetRequests === null) {
			$this->initBetRequests();
		}
		if (!in_array($l, $this->collBetRequests, true)) { // only add it if the **same** object is not already associated
			array_push($this->collBetRequests, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related BetRequests from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getBetRequestsJoinLot($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBetRequests === null) {
			if ($this->isNew()) {
				$this->collBetRequests = array();
			} else {

				$criteria->add(BetRequestPeer::USER_ID, $this->id);

				$this->collBetRequests = BetRequestPeer::doSelectJoinLot($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(BetRequestPeer::USER_ID, $this->id);

			if (!isset($this->lastBetRequestCriteria) || !$this->lastBetRequestCriteria->equals($criteria)) {
				$this->collBetRequests = BetRequestPeer::doSelectJoinLot($criteria, $con, $join_behavior);
			}
		}
		$this->lastBetRequestCriteria = $criteria;

		return $this->collBetRequests;
	}

	/**
	 * Clears out the collChats collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addChats()
	 */
	public function clearChats()
	{
		$this->collChats = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collChats collection (array).
	 *
	 * By default this just sets the collChats collection to an empty array (like clearcollChats());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initChats()
	{
		$this->collChats = array();
	}

	/**
	 * Gets an array of Chat objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related Chats from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Chat[]
	 * @throws     PropelException
	 */
	public function getChats($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collChats === null) {
			if ($this->isNew()) {
			   $this->collChats = array();
			} else {

				$criteria->add(ChatPeer::USER_ID, $this->id);

				ChatPeer::addSelectColumns($criteria);
				$this->collChats = ChatPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(ChatPeer::USER_ID, $this->id);

				ChatPeer::addSelectColumns($criteria);
				if (!isset($this->lastChatCriteria) || !$this->lastChatCriteria->equals($criteria)) {
					$this->collChats = ChatPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastChatCriteria = $criteria;
		return $this->collChats;
	}

	/**
	 * Returns the number of related Chat objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Chat objects.
	 * @throws     PropelException
	 */
	public function countChats(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collChats === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(ChatPeer::USER_ID, $this->id);

				$count = ChatPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(ChatPeer::USER_ID, $this->id);

				if (!isset($this->lastChatCriteria) || !$this->lastChatCriteria->equals($criteria)) {
					$count = ChatPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collChats);
				}
			} else {
				$count = count($this->collChats);
			}
		}
		$this->lastChatCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Chat object to this object
	 * through the Chat foreign key attribute.
	 *
	 * @param      Chat $l Chat
	 * @return     void
	 * @throws     PropelException
	 */
	public function addChat(Chat $l)
	{
		if ($this->collChats === null) {
			$this->initChats();
		}
		if (!in_array($l, $this->collChats, true)) { // only add it if the **same** object is not already associated
			array_push($this->collChats, $l);
			$l->setsfGuardUser($this);
		}
	}

	/**
	 * Clears out the collLotAutobets collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addLotAutobets()
	 */
	public function clearLotAutobets()
	{
		$this->collLotAutobets = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collLotAutobets collection (array).
	 *
	 * By default this just sets the collLotAutobets collection to an empty array (like clearcollLotAutobets());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initLotAutobets()
	{
		$this->collLotAutobets = array();
	}

	/**
	 * Gets an array of LotAutobet objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related LotAutobets from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array LotAutobet[]
	 * @throws     PropelException
	 */
	public function getLotAutobets($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLotAutobets === null) {
			if ($this->isNew()) {
			   $this->collLotAutobets = array();
			} else {

				$criteria->add(LotAutobetPeer::USER_ID, $this->id);

				LotAutobetPeer::addSelectColumns($criteria);
				$this->collLotAutobets = LotAutobetPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(LotAutobetPeer::USER_ID, $this->id);

				LotAutobetPeer::addSelectColumns($criteria);
				if (!isset($this->lastLotAutobetCriteria) || !$this->lastLotAutobetCriteria->equals($criteria)) {
					$this->collLotAutobets = LotAutobetPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastLotAutobetCriteria = $criteria;
		return $this->collLotAutobets;
	}

	/**
	 * Returns the number of related LotAutobet objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related LotAutobet objects.
	 * @throws     PropelException
	 */
	public function countLotAutobets(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collLotAutobets === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(LotAutobetPeer::USER_ID, $this->id);

				$count = LotAutobetPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(LotAutobetPeer::USER_ID, $this->id);

				if (!isset($this->lastLotAutobetCriteria) || !$this->lastLotAutobetCriteria->equals($criteria)) {
					$count = LotAutobetPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collLotAutobets);
				}
			} else {
				$count = count($this->collLotAutobets);
			}
		}
		$this->lastLotAutobetCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a LotAutobet object to this object
	 * through the LotAutobet foreign key attribute.
	 *
	 * @param      LotAutobet $l LotAutobet
	 * @return     void
	 * @throws     PropelException
	 */
	public function addLotAutobet(LotAutobet $l)
	{
		if ($this->collLotAutobets === null) {
			$this->initLotAutobets();
		}
		if (!in_array($l, $this->collLotAutobets, true)) { // only add it if the **same** object is not already associated
			array_push($this->collLotAutobets, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related LotAutobets from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getLotAutobetsJoinLot($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLotAutobets === null) {
			if ($this->isNew()) {
				$this->collLotAutobets = array();
			} else {

				$criteria->add(LotAutobetPeer::USER_ID, $this->id);

				$this->collLotAutobets = LotAutobetPeer::doSelectJoinLot($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(LotAutobetPeer::USER_ID, $this->id);

			if (!isset($this->lastLotAutobetCriteria) || !$this->lastLotAutobetCriteria->equals($criteria)) {
				$this->collLotAutobets = LotAutobetPeer::doSelectJoinLot($criteria, $con, $join_behavior);
			}
		}
		$this->lastLotAutobetCriteria = $criteria;

		return $this->collLotAutobets;
	}

	/**
	 * Clears out the collMailsRelatedByUserFromId collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addMailsRelatedByUserFromId()
	 */
	public function clearMailsRelatedByUserFromId()
	{
		$this->collMailsRelatedByUserFromId = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collMailsRelatedByUserFromId collection (array).
	 *
	 * By default this just sets the collMailsRelatedByUserFromId collection to an empty array (like clearcollMailsRelatedByUserFromId());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initMailsRelatedByUserFromId()
	{
		$this->collMailsRelatedByUserFromId = array();
	}

	/**
	 * Gets an array of Mail objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related MailsRelatedByUserFromId from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Mail[]
	 * @throws     PropelException
	 */
	public function getMailsRelatedByUserFromId($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collMailsRelatedByUserFromId === null) {
			if ($this->isNew()) {
			   $this->collMailsRelatedByUserFromId = array();
			} else {

				$criteria->add(MailPeer::USER_FROM_ID, $this->id);

				MailPeer::addSelectColumns($criteria);
				$this->collMailsRelatedByUserFromId = MailPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(MailPeer::USER_FROM_ID, $this->id);

				MailPeer::addSelectColumns($criteria);
				if (!isset($this->lastMailRelatedByUserFromIdCriteria) || !$this->lastMailRelatedByUserFromIdCriteria->equals($criteria)) {
					$this->collMailsRelatedByUserFromId = MailPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastMailRelatedByUserFromIdCriteria = $criteria;
		return $this->collMailsRelatedByUserFromId;
	}

	/**
	 * Returns the number of related Mail objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Mail objects.
	 * @throws     PropelException
	 */
	public function countMailsRelatedByUserFromId(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collMailsRelatedByUserFromId === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(MailPeer::USER_FROM_ID, $this->id);

				$count = MailPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(MailPeer::USER_FROM_ID, $this->id);

				if (!isset($this->lastMailRelatedByUserFromIdCriteria) || !$this->lastMailRelatedByUserFromIdCriteria->equals($criteria)) {
					$count = MailPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collMailsRelatedByUserFromId);
				}
			} else {
				$count = count($this->collMailsRelatedByUserFromId);
			}
		}
		$this->lastMailRelatedByUserFromIdCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Mail object to this object
	 * through the Mail foreign key attribute.
	 *
	 * @param      Mail $l Mail
	 * @return     void
	 * @throws     PropelException
	 */
	public function addMailRelatedByUserFromId(Mail $l)
	{
		if ($this->collMailsRelatedByUserFromId === null) {
			$this->initMailsRelatedByUserFromId();
		}
		if (!in_array($l, $this->collMailsRelatedByUserFromId, true)) { // only add it if the **same** object is not already associated
			array_push($this->collMailsRelatedByUserFromId, $l);
			$l->setsfGuardUserRelatedByUserFromId($this);
		}
	}

	/**
	 * Clears out the collMailsRelatedByUserToId collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addMailsRelatedByUserToId()
	 */
	public function clearMailsRelatedByUserToId()
	{
		$this->collMailsRelatedByUserToId = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collMailsRelatedByUserToId collection (array).
	 *
	 * By default this just sets the collMailsRelatedByUserToId collection to an empty array (like clearcollMailsRelatedByUserToId());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initMailsRelatedByUserToId()
	{
		$this->collMailsRelatedByUserToId = array();
	}

	/**
	 * Gets an array of Mail objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related MailsRelatedByUserToId from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Mail[]
	 * @throws     PropelException
	 */
	public function getMailsRelatedByUserToId($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collMailsRelatedByUserToId === null) {
			if ($this->isNew()) {
			   $this->collMailsRelatedByUserToId = array();
			} else {

				$criteria->add(MailPeer::USER_TO_ID, $this->id);

				MailPeer::addSelectColumns($criteria);
				$this->collMailsRelatedByUserToId = MailPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(MailPeer::USER_TO_ID, $this->id);

				MailPeer::addSelectColumns($criteria);
				if (!isset($this->lastMailRelatedByUserToIdCriteria) || !$this->lastMailRelatedByUserToIdCriteria->equals($criteria)) {
					$this->collMailsRelatedByUserToId = MailPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastMailRelatedByUserToIdCriteria = $criteria;
		return $this->collMailsRelatedByUserToId;
	}

	/**
	 * Returns the number of related Mail objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Mail objects.
	 * @throws     PropelException
	 */
	public function countMailsRelatedByUserToId(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collMailsRelatedByUserToId === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(MailPeer::USER_TO_ID, $this->id);

				$count = MailPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(MailPeer::USER_TO_ID, $this->id);

				if (!isset($this->lastMailRelatedByUserToIdCriteria) || !$this->lastMailRelatedByUserToIdCriteria->equals($criteria)) {
					$count = MailPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collMailsRelatedByUserToId);
				}
			} else {
				$count = count($this->collMailsRelatedByUserToId);
			}
		}
		$this->lastMailRelatedByUserToIdCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Mail object to this object
	 * through the Mail foreign key attribute.
	 *
	 * @param      Mail $l Mail
	 * @return     void
	 * @throws     PropelException
	 */
	public function addMailRelatedByUserToId(Mail $l)
	{
		if ($this->collMailsRelatedByUserToId === null) {
			$this->initMailsRelatedByUserToId();
		}
		if (!in_array($l, $this->collMailsRelatedByUserToId, true)) { // only add it if the **same** object is not already associated
			array_push($this->collMailsRelatedByUserToId, $l);
			$l->setsfGuardUserRelatedByUserToId($this);
		}
	}

	/**
	 * Clears out the collPartnerPayments collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addPartnerPayments()
	 */
	public function clearPartnerPayments()
	{
		$this->collPartnerPayments = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collPartnerPayments collection (array).
	 *
	 * By default this just sets the collPartnerPayments collection to an empty array (like clearcollPartnerPayments());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initPartnerPayments()
	{
		$this->collPartnerPayments = array();
	}

	/**
	 * Gets an array of PartnerPayment objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related PartnerPayments from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array PartnerPayment[]
	 * @throws     PropelException
	 */
	public function getPartnerPayments($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPartnerPayments === null) {
			if ($this->isNew()) {
			   $this->collPartnerPayments = array();
			} else {

				$criteria->add(PartnerPaymentPeer::USER_ID, $this->id);

				PartnerPaymentPeer::addSelectColumns($criteria);
				$this->collPartnerPayments = PartnerPaymentPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(PartnerPaymentPeer::USER_ID, $this->id);

				PartnerPaymentPeer::addSelectColumns($criteria);
				if (!isset($this->lastPartnerPaymentCriteria) || !$this->lastPartnerPaymentCriteria->equals($criteria)) {
					$this->collPartnerPayments = PartnerPaymentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPartnerPaymentCriteria = $criteria;
		return $this->collPartnerPayments;
	}

	/**
	 * Returns the number of related PartnerPayment objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related PartnerPayment objects.
	 * @throws     PropelException
	 */
	public function countPartnerPayments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collPartnerPayments === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(PartnerPaymentPeer::USER_ID, $this->id);

				$count = PartnerPaymentPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(PartnerPaymentPeer::USER_ID, $this->id);

				if (!isset($this->lastPartnerPaymentCriteria) || !$this->lastPartnerPaymentCriteria->equals($criteria)) {
					$count = PartnerPaymentPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collPartnerPayments);
				}
			} else {
				$count = count($this->collPartnerPayments);
			}
		}
		$this->lastPartnerPaymentCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a PartnerPayment object to this object
	 * through the PartnerPayment foreign key attribute.
	 *
	 * @param      PartnerPayment $l PartnerPayment
	 * @return     void
	 * @throws     PropelException
	 */
	public function addPartnerPayment(PartnerPayment $l)
	{
		if ($this->collPartnerPayments === null) {
			$this->initPartnerPayments();
		}
		if (!in_array($l, $this->collPartnerPayments, true)) { // only add it if the **same** object is not already associated
			array_push($this->collPartnerPayments, $l);
			$l->setsfGuardUser($this);
		}
	}

	/**
	 * Clears out the collPayments collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addPayments()
	 */
	public function clearPayments()
	{
		$this->collPayments = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collPayments collection (array).
	 *
	 * By default this just sets the collPayments collection to an empty array (like clearcollPayments());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initPayments()
	{
		$this->collPayments = array();
	}

	/**
	 * Gets an array of Payment objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related Payments from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Payment[]
	 * @throws     PropelException
	 */
	public function getPayments($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
			   $this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::USER_ID, $this->id);

				PaymentPeer::addSelectColumns($criteria);
				$this->collPayments = PaymentPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(PaymentPeer::USER_ID, $this->id);

				PaymentPeer::addSelectColumns($criteria);
				if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
					$this->collPayments = PaymentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPaymentCriteria = $criteria;
		return $this->collPayments;
	}

	/**
	 * Returns the number of related Payment objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Payment objects.
	 * @throws     PropelException
	 */
	public function countPayments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(PaymentPeer::USER_ID, $this->id);

				$count = PaymentPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(PaymentPeer::USER_ID, $this->id);

				if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
					$count = PaymentPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collPayments);
				}
			} else {
				$count = count($this->collPayments);
			}
		}
		$this->lastPaymentCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Payment object to this object
	 * through the Payment foreign key attribute.
	 *
	 * @param      Payment $l Payment
	 * @return     void
	 * @throws     PropelException
	 */
	public function addPayment(Payment $l)
	{
		if ($this->collPayments === null) {
			$this->initPayments();
		}
		if (!in_array($l, $this->collPayments, true)) { // only add it if the **same** object is not already associated
			array_push($this->collPayments, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related Payments from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getPaymentsJoinPaymentType($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::USER_ID, $this->id);

				$this->collPayments = PaymentPeer::doSelectJoinPaymentType($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(PaymentPeer::USER_ID, $this->id);

			if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
				$this->collPayments = PaymentPeer::doSelectJoinPaymentType($criteria, $con, $join_behavior);
			}
		}
		$this->lastPaymentCriteria = $criteria;

		return $this->collPayments;
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related Payments from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getPaymentsJoinBetsPackage($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::USER_ID, $this->id);

				$this->collPayments = PaymentPeer::doSelectJoinBetsPackage($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(PaymentPeer::USER_ID, $this->id);

			if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
				$this->collPayments = PaymentPeer::doSelectJoinBetsPackage($criteria, $con, $join_behavior);
			}
		}
		$this->lastPaymentCriteria = $criteria;

		return $this->collPayments;
	}

	/**
	 * Clears out the collUserBetsPackages collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addUserBetsPackages()
	 */
	public function clearUserBetsPackages()
	{
		$this->collUserBetsPackages = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collUserBetsPackages collection (array).
	 *
	 * By default this just sets the collUserBetsPackages collection to an empty array (like clearcollUserBetsPackages());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initUserBetsPackages()
	{
		$this->collUserBetsPackages = array();
	}

	/**
	 * Gets an array of UserBetsPackage objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related UserBetsPackages from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array UserBetsPackage[]
	 * @throws     PropelException
	 */
	public function getUserBetsPackages($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserBetsPackages === null) {
			if ($this->isNew()) {
			   $this->collUserBetsPackages = array();
			} else {

				$criteria->add(UserBetsPackagePeer::USER_ID, $this->id);

				UserBetsPackagePeer::addSelectColumns($criteria);
				$this->collUserBetsPackages = UserBetsPackagePeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(UserBetsPackagePeer::USER_ID, $this->id);

				UserBetsPackagePeer::addSelectColumns($criteria);
				if (!isset($this->lastUserBetsPackageCriteria) || !$this->lastUserBetsPackageCriteria->equals($criteria)) {
					$this->collUserBetsPackages = UserBetsPackagePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserBetsPackageCriteria = $criteria;
		return $this->collUserBetsPackages;
	}

	/**
	 * Returns the number of related UserBetsPackage objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related UserBetsPackage objects.
	 * @throws     PropelException
	 */
	public function countUserBetsPackages(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collUserBetsPackages === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(UserBetsPackagePeer::USER_ID, $this->id);

				$count = UserBetsPackagePeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(UserBetsPackagePeer::USER_ID, $this->id);

				if (!isset($this->lastUserBetsPackageCriteria) || !$this->lastUserBetsPackageCriteria->equals($criteria)) {
					$count = UserBetsPackagePeer::doCount($criteria, $con);
				} else {
					$count = count($this->collUserBetsPackages);
				}
			} else {
				$count = count($this->collUserBetsPackages);
			}
		}
		$this->lastUserBetsPackageCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a UserBetsPackage object to this object
	 * through the UserBetsPackage foreign key attribute.
	 *
	 * @param      UserBetsPackage $l UserBetsPackage
	 * @return     void
	 * @throws     PropelException
	 */
	public function addUserBetsPackage(UserBetsPackage $l)
	{
		if ($this->collUserBetsPackages === null) {
			$this->initUserBetsPackages();
		}
		if (!in_array($l, $this->collUserBetsPackages, true)) { // only add it if the **same** object is not already associated
			array_push($this->collUserBetsPackages, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related UserBetsPackages from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getUserBetsPackagesJoinBetsPackage($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserBetsPackages === null) {
			if ($this->isNew()) {
				$this->collUserBetsPackages = array();
			} else {

				$criteria->add(UserBetsPackagePeer::USER_ID, $this->id);

				$this->collUserBetsPackages = UserBetsPackagePeer::doSelectJoinBetsPackage($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(UserBetsPackagePeer::USER_ID, $this->id);

			if (!isset($this->lastUserBetsPackageCriteria) || !$this->lastUserBetsPackageCriteria->equals($criteria)) {
				$this->collUserBetsPackages = UserBetsPackagePeer::doSelectJoinBetsPackage($criteria, $con, $join_behavior);
			}
		}
		$this->lastUserBetsPackageCriteria = $criteria;

		return $this->collUserBetsPackages;
	}

	/**
	 * Clears out the collUserPromoCodes collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addUserPromoCodes()
	 */
	public function clearUserPromoCodes()
	{
		$this->collUserPromoCodes = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collUserPromoCodes collection (array).
	 *
	 * By default this just sets the collUserPromoCodes collection to an empty array (like clearcollUserPromoCodes());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initUserPromoCodes()
	{
		$this->collUserPromoCodes = array();
	}

	/**
	 * Gets an array of UserPromoCode objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related UserPromoCodes from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array UserPromoCode[]
	 * @throws     PropelException
	 */
	public function getUserPromoCodes($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserPromoCodes === null) {
			if ($this->isNew()) {
			   $this->collUserPromoCodes = array();
			} else {

				$criteria->add(UserPromoCodePeer::USER_ID, $this->id);

				UserPromoCodePeer::addSelectColumns($criteria);
				$this->collUserPromoCodes = UserPromoCodePeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(UserPromoCodePeer::USER_ID, $this->id);

				UserPromoCodePeer::addSelectColumns($criteria);
				if (!isset($this->lastUserPromoCodeCriteria) || !$this->lastUserPromoCodeCriteria->equals($criteria)) {
					$this->collUserPromoCodes = UserPromoCodePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserPromoCodeCriteria = $criteria;
		return $this->collUserPromoCodes;
	}

	/**
	 * Returns the number of related UserPromoCode objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related UserPromoCode objects.
	 * @throws     PropelException
	 */
	public function countUserPromoCodes(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collUserPromoCodes === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(UserPromoCodePeer::USER_ID, $this->id);

				$count = UserPromoCodePeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(UserPromoCodePeer::USER_ID, $this->id);

				if (!isset($this->lastUserPromoCodeCriteria) || !$this->lastUserPromoCodeCriteria->equals($criteria)) {
					$count = UserPromoCodePeer::doCount($criteria, $con);
				} else {
					$count = count($this->collUserPromoCodes);
				}
			} else {
				$count = count($this->collUserPromoCodes);
			}
		}
		$this->lastUserPromoCodeCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a UserPromoCode object to this object
	 * through the UserPromoCode foreign key attribute.
	 *
	 * @param      UserPromoCode $l UserPromoCode
	 * @return     void
	 * @throws     PropelException
	 */
	public function addUserPromoCode(UserPromoCode $l)
	{
		if ($this->collUserPromoCodes === null) {
			$this->initUserPromoCodes();
		}
		if (!in_array($l, $this->collUserPromoCodes, true)) { // only add it if the **same** object is not already associated
			array_push($this->collUserPromoCodes, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related UserPromoCodes from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getUserPromoCodesJoinPromoCode($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserPromoCodes === null) {
			if ($this->isNew()) {
				$this->collUserPromoCodes = array();
			} else {

				$criteria->add(UserPromoCodePeer::USER_ID, $this->id);

				$this->collUserPromoCodes = UserPromoCodePeer::doSelectJoinPromoCode($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(UserPromoCodePeer::USER_ID, $this->id);

			if (!isset($this->lastUserPromoCodeCriteria) || !$this->lastUserPromoCodeCriteria->equals($criteria)) {
				$this->collUserPromoCodes = UserPromoCodePeer::doSelectJoinPromoCode($criteria, $con, $join_behavior);
			}
		}
		$this->lastUserPromoCodeCriteria = $criteria;

		return $this->collUserPromoCodes;
	}

	/**
	 * Clears out the collUserVouchers collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addUserVouchers()
	 */
	public function clearUserVouchers()
	{
		$this->collUserVouchers = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collUserVouchers collection (array).
	 *
	 * By default this just sets the collUserVouchers collection to an empty array (like clearcollUserVouchers());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initUserVouchers()
	{
		$this->collUserVouchers = array();
	}

	/**
	 * Gets an array of UserVoucher objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related UserVouchers from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array UserVoucher[]
	 * @throws     PropelException
	 */
	public function getUserVouchers($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserVouchers === null) {
			if ($this->isNew()) {
			   $this->collUserVouchers = array();
			} else {

				$criteria->add(UserVoucherPeer::USER_ID, $this->id);

				UserVoucherPeer::addSelectColumns($criteria);
				$this->collUserVouchers = UserVoucherPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(UserVoucherPeer::USER_ID, $this->id);

				UserVoucherPeer::addSelectColumns($criteria);
				if (!isset($this->lastUserVoucherCriteria) || !$this->lastUserVoucherCriteria->equals($criteria)) {
					$this->collUserVouchers = UserVoucherPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserVoucherCriteria = $criteria;
		return $this->collUserVouchers;
	}

	/**
	 * Returns the number of related UserVoucher objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related UserVoucher objects.
	 * @throws     PropelException
	 */
	public function countUserVouchers(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collUserVouchers === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(UserVoucherPeer::USER_ID, $this->id);

				$count = UserVoucherPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(UserVoucherPeer::USER_ID, $this->id);

				if (!isset($this->lastUserVoucherCriteria) || !$this->lastUserVoucherCriteria->equals($criteria)) {
					$count = UserVoucherPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collUserVouchers);
				}
			} else {
				$count = count($this->collUserVouchers);
			}
		}
		$this->lastUserVoucherCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a UserVoucher object to this object
	 * through the UserVoucher foreign key attribute.
	 *
	 * @param      UserVoucher $l UserVoucher
	 * @return     void
	 * @throws     PropelException
	 */
	public function addUserVoucher(UserVoucher $l)
	{
		if ($this->collUserVouchers === null) {
			$this->initUserVouchers();
		}
		if (!in_array($l, $this->collUserVouchers, true)) { // only add it if the **same** object is not already associated
			array_push($this->collUserVouchers, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related UserVouchers from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getUserVouchersJoinVoucher($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserVouchers === null) {
			if ($this->isNew()) {
				$this->collUserVouchers = array();
			} else {

				$criteria->add(UserVoucherPeer::USER_ID, $this->id);

				$this->collUserVouchers = UserVoucherPeer::doSelectJoinVoucher($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(UserVoucherPeer::USER_ID, $this->id);

			if (!isset($this->lastUserVoucherCriteria) || !$this->lastUserVoucherCriteria->equals($criteria)) {
				$this->collUserVouchers = UserVoucherPeer::doSelectJoinVoucher($criteria, $con, $join_behavior);
			}
		}
		$this->lastUserVoucherCriteria = $criteria;

		return $this->collUserVouchers;
	}

	/**
	 * Clears out the collsfGuardUsersRelatedByUserPartnerId collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addsfGuardUsersRelatedByUserPartnerId()
	 */
	public function clearsfGuardUsersRelatedByUserPartnerId()
	{
		$this->collsfGuardUsersRelatedByUserPartnerId = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collsfGuardUsersRelatedByUserPartnerId collection (array).
	 *
	 * By default this just sets the collsfGuardUsersRelatedByUserPartnerId collection to an empty array (like clearcollsfGuardUsersRelatedByUserPartnerId());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initsfGuardUsersRelatedByUserPartnerId()
	{
		$this->collsfGuardUsersRelatedByUserPartnerId = array();
	}

	/**
	 * Gets an array of sfGuardUser objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related sfGuardUsersRelatedByUserPartnerId from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array sfGuardUser[]
	 * @throws     PropelException
	 */
	public function getsfGuardUsersRelatedByUserPartnerId($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUsersRelatedByUserPartnerId === null) {
			if ($this->isNew()) {
			   $this->collsfGuardUsersRelatedByUserPartnerId = array();
			} else {

				$criteria->add(sfGuardUserPeer::USER_PARTNER_ID, $this->id);

				sfGuardUserPeer::addSelectColumns($criteria);
				$this->collsfGuardUsersRelatedByUserPartnerId = sfGuardUserPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(sfGuardUserPeer::USER_PARTNER_ID, $this->id);

				sfGuardUserPeer::addSelectColumns($criteria);
				if (!isset($this->lastsfGuardUserRelatedByUserPartnerIdCriteria) || !$this->lastsfGuardUserRelatedByUserPartnerIdCriteria->equals($criteria)) {
					$this->collsfGuardUsersRelatedByUserPartnerId = sfGuardUserPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastsfGuardUserRelatedByUserPartnerIdCriteria = $criteria;
		return $this->collsfGuardUsersRelatedByUserPartnerId;
	}

	/**
	 * Returns the number of related sfGuardUser objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related sfGuardUser objects.
	 * @throws     PropelException
	 */
	public function countsfGuardUsersRelatedByUserPartnerId(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collsfGuardUsersRelatedByUserPartnerId === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(sfGuardUserPeer::USER_PARTNER_ID, $this->id);

				$count = sfGuardUserPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(sfGuardUserPeer::USER_PARTNER_ID, $this->id);

				if (!isset($this->lastsfGuardUserRelatedByUserPartnerIdCriteria) || !$this->lastsfGuardUserRelatedByUserPartnerIdCriteria->equals($criteria)) {
					$count = sfGuardUserPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collsfGuardUsersRelatedByUserPartnerId);
				}
			} else {
				$count = count($this->collsfGuardUsersRelatedByUserPartnerId);
			}
		}
		$this->lastsfGuardUserRelatedByUserPartnerIdCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a sfGuardUser object to this object
	 * through the sfGuardUser foreign key attribute.
	 *
	 * @param      sfGuardUser $l sfGuardUser
	 * @return     void
	 * @throws     PropelException
	 */
	public function addsfGuardUserRelatedByUserPartnerId(sfGuardUser $l)
	{
		if ($this->collsfGuardUsersRelatedByUserPartnerId === null) {
			$this->initsfGuardUsersRelatedByUserPartnerId();
		}
		if (!in_array($l, $this->collsfGuardUsersRelatedByUserPartnerId, true)) { // only add it if the **same** object is not already associated
			array_push($this->collsfGuardUsersRelatedByUserPartnerId, $l);
			$l->setsfGuardUserRelatedByUserPartnerId($this);
		}
	}

	/**
	 * Clears out the collsfGuardUserPermissions collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addsfGuardUserPermissions()
	 */
	public function clearsfGuardUserPermissions()
	{
		$this->collsfGuardUserPermissions = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collsfGuardUserPermissions collection (array).
	 *
	 * By default this just sets the collsfGuardUserPermissions collection to an empty array (like clearcollsfGuardUserPermissions());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initsfGuardUserPermissions()
	{
		$this->collsfGuardUserPermissions = array();
	}

	/**
	 * Gets an array of sfGuardUserPermission objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related sfGuardUserPermissions from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array sfGuardUserPermission[]
	 * @throws     PropelException
	 */
	public function getsfGuardUserPermissions($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUserPermissions === null) {
			if ($this->isNew()) {
			   $this->collsfGuardUserPermissions = array();
			} else {

				$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->id);

				sfGuardUserPermissionPeer::addSelectColumns($criteria);
				$this->collsfGuardUserPermissions = sfGuardUserPermissionPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->id);

				sfGuardUserPermissionPeer::addSelectColumns($criteria);
				if (!isset($this->lastsfGuardUserPermissionCriteria) || !$this->lastsfGuardUserPermissionCriteria->equals($criteria)) {
					$this->collsfGuardUserPermissions = sfGuardUserPermissionPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastsfGuardUserPermissionCriteria = $criteria;
		return $this->collsfGuardUserPermissions;
	}

	/**
	 * Returns the number of related sfGuardUserPermission objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related sfGuardUserPermission objects.
	 * @throws     PropelException
	 */
	public function countsfGuardUserPermissions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collsfGuardUserPermissions === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->id);

				$count = sfGuardUserPermissionPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->id);

				if (!isset($this->lastsfGuardUserPermissionCriteria) || !$this->lastsfGuardUserPermissionCriteria->equals($criteria)) {
					$count = sfGuardUserPermissionPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collsfGuardUserPermissions);
				}
			} else {
				$count = count($this->collsfGuardUserPermissions);
			}
		}
		$this->lastsfGuardUserPermissionCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a sfGuardUserPermission object to this object
	 * through the sfGuardUserPermission foreign key attribute.
	 *
	 * @param      sfGuardUserPermission $l sfGuardUserPermission
	 * @return     void
	 * @throws     PropelException
	 */
	public function addsfGuardUserPermission(sfGuardUserPermission $l)
	{
		if ($this->collsfGuardUserPermissions === null) {
			$this->initsfGuardUserPermissions();
		}
		if (!in_array($l, $this->collsfGuardUserPermissions, true)) { // only add it if the **same** object is not already associated
			array_push($this->collsfGuardUserPermissions, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related sfGuardUserPermissions from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getsfGuardUserPermissionsJoinsfGuardPermission($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUserPermissions === null) {
			if ($this->isNew()) {
				$this->collsfGuardUserPermissions = array();
			} else {

				$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->id);

				$this->collsfGuardUserPermissions = sfGuardUserPermissionPeer::doSelectJoinsfGuardPermission($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->id);

			if (!isset($this->lastsfGuardUserPermissionCriteria) || !$this->lastsfGuardUserPermissionCriteria->equals($criteria)) {
				$this->collsfGuardUserPermissions = sfGuardUserPermissionPeer::doSelectJoinsfGuardPermission($criteria, $con, $join_behavior);
			}
		}
		$this->lastsfGuardUserPermissionCriteria = $criteria;

		return $this->collsfGuardUserPermissions;
	}

	/**
	 * Clears out the collsfGuardUserGroups collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addsfGuardUserGroups()
	 */
	public function clearsfGuardUserGroups()
	{
		$this->collsfGuardUserGroups = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collsfGuardUserGroups collection (array).
	 *
	 * By default this just sets the collsfGuardUserGroups collection to an empty array (like clearcollsfGuardUserGroups());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initsfGuardUserGroups()
	{
		$this->collsfGuardUserGroups = array();
	}

	/**
	 * Gets an array of sfGuardUserGroup objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related sfGuardUserGroups from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array sfGuardUserGroup[]
	 * @throws     PropelException
	 */
	public function getsfGuardUserGroups($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUserGroups === null) {
			if ($this->isNew()) {
			   $this->collsfGuardUserGroups = array();
			} else {

				$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->id);

				sfGuardUserGroupPeer::addSelectColumns($criteria);
				$this->collsfGuardUserGroups = sfGuardUserGroupPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->id);

				sfGuardUserGroupPeer::addSelectColumns($criteria);
				if (!isset($this->lastsfGuardUserGroupCriteria) || !$this->lastsfGuardUserGroupCriteria->equals($criteria)) {
					$this->collsfGuardUserGroups = sfGuardUserGroupPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastsfGuardUserGroupCriteria = $criteria;
		return $this->collsfGuardUserGroups;
	}

	/**
	 * Returns the number of related sfGuardUserGroup objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related sfGuardUserGroup objects.
	 * @throws     PropelException
	 */
	public function countsfGuardUserGroups(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collsfGuardUserGroups === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->id);

				$count = sfGuardUserGroupPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->id);

				if (!isset($this->lastsfGuardUserGroupCriteria) || !$this->lastsfGuardUserGroupCriteria->equals($criteria)) {
					$count = sfGuardUserGroupPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collsfGuardUserGroups);
				}
			} else {
				$count = count($this->collsfGuardUserGroups);
			}
		}
		$this->lastsfGuardUserGroupCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a sfGuardUserGroup object to this object
	 * through the sfGuardUserGroup foreign key attribute.
	 *
	 * @param      sfGuardUserGroup $l sfGuardUserGroup
	 * @return     void
	 * @throws     PropelException
	 */
	public function addsfGuardUserGroup(sfGuardUserGroup $l)
	{
		if ($this->collsfGuardUserGroups === null) {
			$this->initsfGuardUserGroups();
		}
		if (!in_array($l, $this->collsfGuardUserGroups, true)) { // only add it if the **same** object is not already associated
			array_push($this->collsfGuardUserGroups, $l);
			$l->setsfGuardUser($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this sfGuardUser is new, it will return
	 * an empty collection; or if this sfGuardUser has previously
	 * been saved, it will retrieve related sfGuardUserGroups from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in sfGuardUser.
	 */
	public function getsfGuardUserGroupsJoinsfGuardGroup($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUserGroups === null) {
			if ($this->isNew()) {
				$this->collsfGuardUserGroups = array();
			} else {

				$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->id);

				$this->collsfGuardUserGroups = sfGuardUserGroupPeer::doSelectJoinsfGuardGroup($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->id);

			if (!isset($this->lastsfGuardUserGroupCriteria) || !$this->lastsfGuardUserGroupCriteria->equals($criteria)) {
				$this->collsfGuardUserGroups = sfGuardUserGroupPeer::doSelectJoinsfGuardGroup($criteria, $con, $join_behavior);
			}
		}
		$this->lastsfGuardUserGroupCriteria = $criteria;

		return $this->collsfGuardUserGroups;
	}

	/**
	 * Clears out the collsfGuardRememberKeys collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addsfGuardRememberKeys()
	 */
	public function clearsfGuardRememberKeys()
	{
		$this->collsfGuardRememberKeys = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collsfGuardRememberKeys collection (array).
	 *
	 * By default this just sets the collsfGuardRememberKeys collection to an empty array (like clearcollsfGuardRememberKeys());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initsfGuardRememberKeys()
	{
		$this->collsfGuardRememberKeys = array();
	}

	/**
	 * Gets an array of sfGuardRememberKey objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this sfGuardUser has previously been saved, it will retrieve
	 * related sfGuardRememberKeys from storage. If this sfGuardUser is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array sfGuardRememberKey[]
	 * @throws     PropelException
	 */
	public function getsfGuardRememberKeys($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardRememberKeys === null) {
			if ($this->isNew()) {
			   $this->collsfGuardRememberKeys = array();
			} else {

				$criteria->add(sfGuardRememberKeyPeer::USER_ID, $this->id);

				sfGuardRememberKeyPeer::addSelectColumns($criteria);
				$this->collsfGuardRememberKeys = sfGuardRememberKeyPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(sfGuardRememberKeyPeer::USER_ID, $this->id);

				sfGuardRememberKeyPeer::addSelectColumns($criteria);
				if (!isset($this->lastsfGuardRememberKeyCriteria) || !$this->lastsfGuardRememberKeyCriteria->equals($criteria)) {
					$this->collsfGuardRememberKeys = sfGuardRememberKeyPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastsfGuardRememberKeyCriteria = $criteria;
		return $this->collsfGuardRememberKeys;
	}

	/**
	 * Returns the number of related sfGuardRememberKey objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related sfGuardRememberKey objects.
	 * @throws     PropelException
	 */
	public function countsfGuardRememberKeys(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collsfGuardRememberKeys === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(sfGuardRememberKeyPeer::USER_ID, $this->id);

				$count = sfGuardRememberKeyPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(sfGuardRememberKeyPeer::USER_ID, $this->id);

				if (!isset($this->lastsfGuardRememberKeyCriteria) || !$this->lastsfGuardRememberKeyCriteria->equals($criteria)) {
					$count = sfGuardRememberKeyPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collsfGuardRememberKeys);
				}
			} else {
				$count = count($this->collsfGuardRememberKeys);
			}
		}
		$this->lastsfGuardRememberKeyCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a sfGuardRememberKey object to this object
	 * through the sfGuardRememberKey foreign key attribute.
	 *
	 * @param      sfGuardRememberKey $l sfGuardRememberKey
	 * @return     void
	 * @throws     PropelException
	 */
	public function addsfGuardRememberKey(sfGuardRememberKey $l)
	{
		if ($this->collsfGuardRememberKeys === null) {
			$this->initsfGuardRememberKeys();
		}
		if (!in_array($l, $this->collsfGuardRememberKeys, true)) { // only add it if the **same** object is not already associated
			array_push($this->collsfGuardRememberKeys, $l);
			$l->setsfGuardUser($this);
		}
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collBets) {
				foreach ((array) $this->collBets as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collBetRequests) {
				foreach ((array) $this->collBetRequests as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collChats) {
				foreach ((array) $this->collChats as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collLotAutobets) {
				foreach ((array) $this->collLotAutobets as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collMailsRelatedByUserFromId) {
				foreach ((array) $this->collMailsRelatedByUserFromId as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collMailsRelatedByUserToId) {
				foreach ((array) $this->collMailsRelatedByUserToId as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collPartnerPayments) {
				foreach ((array) $this->collPartnerPayments as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collPayments) {
				foreach ((array) $this->collPayments as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collUserBetsPackages) {
				foreach ((array) $this->collUserBetsPackages as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collUserPromoCodes) {
				foreach ((array) $this->collUserPromoCodes as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collUserVouchers) {
				foreach ((array) $this->collUserVouchers as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collsfGuardUsersRelatedByUserPartnerId) {
				foreach ((array) $this->collsfGuardUsersRelatedByUserPartnerId as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collsfGuardUserPermissions) {
				foreach ((array) $this->collsfGuardUserPermissions as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collsfGuardUserGroups) {
				foreach ((array) $this->collsfGuardUserGroups as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collsfGuardRememberKeys) {
				foreach ((array) $this->collsfGuardRememberKeys as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collBets = null;
		$this->collBetRequests = null;
		$this->collChats = null;
		$this->collLotAutobets = null;
		$this->collMailsRelatedByUserFromId = null;
		$this->collMailsRelatedByUserToId = null;
		$this->collPartnerPayments = null;
		$this->collPayments = null;
		$this->collUserBetsPackages = null;
		$this->collUserPromoCodes = null;
		$this->collUserVouchers = null;
		$this->collsfGuardUsersRelatedByUserPartnerId = null;
		$this->collsfGuardUserPermissions = null;
		$this->collsfGuardUserGroups = null;
		$this->collsfGuardRememberKeys = null;
			$this->asfGuardUserRelatedByUserPartnerId = null;
	}


  public function __call($method, $arguments)
  {
    if (!$callable = sfMixer::getCallable('BasesfGuardUser:'.$method))
    {
      throw new sfException(sprintf('Call to undefined method BasesfGuardUser::%s', $method));
    }

    array_unshift($arguments, $this);

    return call_user_func_array($callable, $arguments);
  }


} // BasesfGuardUser
