<?php

/**
 * sfGuardUser form.
 *
 * @package    form
 * @subpackage sf_guard_user
 * @version    SVN: $Id: sfGuardUserForm.class.php 13001 2008-11-14 10:45:32Z noel $
 */
class sfGuardUserForm extends sfGuardUserAdminForm
{
    protected $pkName = null;

    public function configure ()
    {
        parent::configure();

        unset(
            $this['last_login'],
            $this['created_at'],
            $this['salt'],
            $this['algorithm'],
            $this['is_active'],
            $this['is_super_admin'],
            $this['sf_guard_user_group_list'],
            $this['sf_guard_user_permission_list']
        );

        $this->widgetSchema->setNameFormat('user[%s]');

        $this->widgetSchema['promo_code'] = new sfWidgetFormInput();

        $this->widgetSchema['username']->setLabel('Логин');
        $this->widgetSchema['phone']->setLabel('Мобильный телефон');
        $this->widgetSchema['name']->setLabel('Ваше имя');
        $this->widgetSchema['password']->setLabel('Пароль');
        $this->widgetSchema['password_again']->setLabel('Подтверждение пароля');
        $this->widgetSchema['email']->setLabel('Контактный e-mail');
        $this->widgetSchema['promo_code']->setLabel('Промо-код');

        $this->validatorSchema->setPostValidator(
            new sfValidatorAnd(array(
                new sfValidatorPropelUnique(array('model' => 'sfGuardUser', 'column' => array('username')), array('invalid' => 'Пользователь с таким логином уже зарегистрирован.')),
                new sfValidatorPropelUnique(array('model' => 'sfGuardUser', 'column' => array('phone')), array('invalid' => 'Пользователь с таким телефоном уже зарегистрирован.')),
                new sfValidatorPropelUnique(array('model' => 'sfGuardUser', 'column' => array('email')), array('invalid' => 'Пользователь с таким адресом E-Mail уже зарегистрирован.'))
            ))
        );

        $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::EQUAL, 'password_again', array(), array('invalid' => 'Подтверждение пароля должно совпадать с паролем.')));

        $this->validatorSchema['promo_code'] = new sfValidatorString(array('required' => false));

        $this->validatorSchema['username']->setOption('required', true);
        $this->validatorSchema['username']->setOption('min_length', 4);
        $this->validatorSchema['username']->setOption('max_length', 15);
        $this->validatorSchema['username']->setMessage('min_length', 'Поле должно включать не менее 4 символов.');
        $this->validatorSchema['username']->setMessage('max_length', 'Поле должно включать не более 15 символов.');

        $this->validatorSchema['username'] = new sfValidatorAnd(array(
            $this->validatorSchema['username'],
            new sfValidatorRegex(array('pattern' => '/^[\d\w_-]+$/i'), array('invalid' => 'Поле может содержать только из латинские символы, цифры, дефис и знак подчеркивани.')),
        ), array(), array('required' => 'Поле обязательно для заполнения.'));

        $this->validatorSchema['phone']->setOption('required', true);
        $this->validatorSchema['phone']->setMessage('required', 'Поле обязательно для заполнения.');

        $this->validatorSchema['password']->setOption('required', true);
        $this->validatorSchema['password']->setOption('min_length', 3);
        $this->validatorSchema['password']->setOption('max_length', 10);
        $this->validatorSchema['password']->setMessage('required', 'Поле обязательно для заполнения.');
        $this->validatorSchema['password']->setMessage('min_length', 'Поле должно включать не менее 3 символов.');
        $this->validatorSchema['password']->setMessage('max_length', 'Поле должно включать не более 10 символов.');

        $this->validatorSchema['email']->setOption('required', true);
        $this->validatorSchema['email']->setMessage('required', 'Поле обязательно для заполнения.');

        $this->validatorSchema['email'] = new sfValidatorAnd(array(
            $this->validatorSchema['email'],
            new sfValidatorEmail(array(), array('invalid' => 'Поле должно содержать корректный адрес E-Mail.'))
        ), array(), array('required' => 'Поле обязательно для заполнения.'));
    }
}
