<?php

/**
 * sfGuardUser form base class.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfPropelFormGeneratedTemplate.php 12815 2008-11-09 10:43:58Z fabien $
 */
class BasesfGuardUserForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'                            => new sfWidgetFormInputHidden(),
      'user_partner_id'               => new sfWidgetFormPropelChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'username'                      => new sfWidgetFormInput(),
      'title'                         => new sfWidgetFormInput(),
      'algorithm'                     => new sfWidgetFormInput(),
      'salt'                          => new sfWidgetFormInput(),
      'password'                      => new sfWidgetFormInput(),
      'created_at'                    => new sfWidgetFormDateTime(),
      'email'                         => new sfWidgetFormInput(),
      'phone'                         => new sfWidgetFormInput(),
      'last_login'                    => new sfWidgetFormDateTime(),
      'is_active'                     => new sfWidgetFormInputCheckbox(),
      'is_super_admin'                => new sfWidgetFormInputCheckbox(),
      'is_bot'                        => new sfWidgetFormInputCheckbox(),
      'is_winner'                     => new sfWidgetFormInputCheckbox(),
      'balance_bets'                  => new sfWidgetFormInput(),
      'balance_money'                 => new sfWidgetFormInput(),
      'balance_partner_total'         => new sfWidgetFormInput(),
      'balance_partner_used'          => new sfWidgetFormInput(),
      'name'                          => new sfWidgetFormInput(),
      'avatar'                        => new sfWidgetFormInput(),
      'rating'                        => new sfWidgetFormInput(),
      'rating_week'                   => new sfWidgetFormInput(),
      'sf_guard_user_group_list'      => new sfWidgetFormPropelChoiceMany(array('model' => 'sfGuardGroup')),
      'sf_guard_user_permission_list' => new sfWidgetFormPropelChoiceMany(array('model' => 'sfGuardPermission')),
    ));

    $this->setValidators(array(
      'id'                            => new sfValidatorPropelChoice(array('model' => 'sfGuardUser', 'column' => 'id', 'required' => false)),
      'user_partner_id'               => new sfValidatorPropelChoice(array('model' => 'sfGuardUser', 'column' => 'id', 'required' => false)),
      'username'                      => new sfValidatorString(array('max_length' => 128)),
      'title'                         => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'algorithm'                     => new sfValidatorString(array('max_length' => 128)),
      'salt'                          => new sfValidatorString(array('max_length' => 128)),
      'password'                      => new sfValidatorString(array('max_length' => 128)),
      'created_at'                    => new sfValidatorDateTime(array('required' => false)),
      'email'                         => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'phone'                         => new sfValidatorString(array('max_length' => 50, 'required' => false)),
      'last_login'                    => new sfValidatorDateTime(array('required' => false)),
      'is_active'                     => new sfValidatorBoolean(),
      'is_super_admin'                => new sfValidatorBoolean(),
      'is_bot'                        => new sfValidatorBoolean(),
      'is_winner'                     => new sfValidatorBoolean(),
      'balance_bets'                  => new sfValidatorInteger(array('required' => false)),
      'balance_money'                 => new sfValidatorInteger(array('required' => false)),
      'balance_partner_total'         => new sfValidatorInteger(array('required' => false)),
      'balance_partner_used'          => new sfValidatorInteger(array('required' => false)),
      'name'                          => new sfValidatorString(array('max_length' => 256, 'required' => false)),
      'avatar'                        => new sfValidatorString(array('max_length' => 256, 'required' => false)),
      'rating'                        => new sfValidatorNumber(array('required' => false)),
      'rating_week'                   => new sfValidatorNumber(array('required' => false)),
      'sf_guard_user_group_list'      => new sfValidatorPropelChoiceMany(array('model' => 'sfGuardGroup', 'required' => false)),
      'sf_guard_user_permission_list' => new sfValidatorPropelChoiceMany(array('model' => 'sfGuardPermission', 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'sfGuardUser', 'column' => array('username')))
    );

    $this->widgetSchema->setNameFormat('sf_guard_user[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'sfGuardUser';
  }


  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['sf_guard_user_group_list']))
    {
      $values = array();
      foreach ($this->object->getsfGuardUserGroups() as $obj)
      {
        $values[] = $obj->getGroupId();
      }

      $this->setDefault('sf_guard_user_group_list', $values);
    }

    if (isset($this->widgetSchema['sf_guard_user_permission_list']))
    {
      $values = array();
      foreach ($this->object->getsfGuardUserPermissions() as $obj)
      {
        $values[] = $obj->getPermissionId();
      }

      $this->setDefault('sf_guard_user_permission_list', $values);
    }

  }

  protected function doSave($con = null)
  {
    parent::doSave($con);

    $this->savesfGuardUserGroupList($con);
    $this->savesfGuardUserPermissionList($con);
  }

  public function savesfGuardUserGroupList($con = null)
  {
    if (!$this->isValid())
    {
      throw $this->getErrorSchema();
    }

    if (!isset($this->widgetSchema['sf_guard_user_group_list']))
    {
      // somebody has unset this widget
      return;
    }

    if (is_null($con))
    {
      $con = $this->getConnection();
    }

    $c = new Criteria();
    $c->add(sfGuardUserGroupPeer::USER_ID, $this->object->getPrimaryKey());
    sfGuardUserGroupPeer::doDelete($c, $con);

    $values = $this->getValue('sf_guard_user_group_list');
    if (is_array($values))
    {
      foreach ($values as $value)
      {
        $obj = new sfGuardUserGroup();
        $obj->setUserId($this->object->getPrimaryKey());
        $obj->setGroupId($value);
        $obj->save();
      }
    }
  }

  public function savesfGuardUserPermissionList($con = null)
  {
    if (!$this->isValid())
    {
      throw $this->getErrorSchema();
    }

    if (!isset($this->widgetSchema['sf_guard_user_permission_list']))
    {
      // somebody has unset this widget
      return;
    }

    if (is_null($con))
    {
      $con = $this->getConnection();
    }

    $c = new Criteria();
    $c->add(sfGuardUserPermissionPeer::USER_ID, $this->object->getPrimaryKey());
    sfGuardUserPermissionPeer::doDelete($c, $con);

    $values = $this->getValue('sf_guard_user_permission_list');
    if (is_array($values))
    {
      foreach ($values as $value)
      {
        $obj = new sfGuardUserPermission();
        $obj->setUserId($this->object->getPrimaryKey());
        $obj->setPermissionId($value);
        $obj->save();
      }
    }
  }

}
