<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * sfGuardUser filter form base class.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage filter
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BasesfGuardUserFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'user_partner_id'               => new sfWidgetFormPropelChoice(array('model' => 'sfGuardUser', 'add_empty' => true)),
      'username'                      => new sfWidgetFormFilterInput(),
      'title'                         => new sfWidgetFormFilterInput(),
      'algorithm'                     => new sfWidgetFormFilterInput(),
      'salt'                          => new sfWidgetFormFilterInput(),
      'password'                      => new sfWidgetFormFilterInput(),
      'created_at'                    => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
      'email'                         => new sfWidgetFormFilterInput(),
      'phone'                         => new sfWidgetFormFilterInput(),
      'last_login'                    => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
      'is_active'                     => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
      'is_super_admin'                => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
      'is_bot'                        => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
      'is_winner'                     => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
      'balance_bets'                  => new sfWidgetFormFilterInput(),
      'balance_money'                 => new sfWidgetFormFilterInput(),
      'balance_partner_total'         => new sfWidgetFormFilterInput(),
      'balance_partner_used'          => new sfWidgetFormFilterInput(),
      'name'                          => new sfWidgetFormFilterInput(),
      'avatar'                        => new sfWidgetFormFilterInput(),
      'rating'                        => new sfWidgetFormFilterInput(),
      'rating_week'                   => new sfWidgetFormFilterInput(),
      'sf_guard_user_group_list'      => new sfWidgetFormPropelChoice(array('model' => 'sfGuardGroup', 'add_empty' => true)),
      'sf_guard_user_permission_list' => new sfWidgetFormPropelChoice(array('model' => 'sfGuardPermission', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'user_partner_id'               => new sfValidatorPropelChoice(array('required' => false, 'model' => 'sfGuardUser', 'column' => 'id')),
      'username'                      => new sfValidatorPass(array('required' => false)),
      'title'                         => new sfValidatorPass(array('required' => false)),
      'algorithm'                     => new sfValidatorPass(array('required' => false)),
      'salt'                          => new sfValidatorPass(array('required' => false)),
      'password'                      => new sfValidatorPass(array('required' => false)),
      'created_at'                    => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'email'                         => new sfValidatorPass(array('required' => false)),
      'phone'                         => new sfValidatorPass(array('required' => false)),
      'last_login'                    => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'is_active'                     => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'is_super_admin'                => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'is_bot'                        => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'is_winner'                     => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'balance_bets'                  => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'balance_money'                 => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'balance_partner_total'         => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'balance_partner_used'          => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'name'                          => new sfValidatorPass(array('required' => false)),
      'avatar'                        => new sfValidatorPass(array('required' => false)),
      'rating'                        => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'rating_week'                   => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'sf_guard_user_group_list'      => new sfValidatorPropelChoice(array('model' => 'sfGuardGroup', 'required' => false)),
      'sf_guard_user_permission_list' => new sfValidatorPropelChoice(array('model' => 'sfGuardPermission', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('sf_guard_user_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function addsfGuardUserGroupListColumnCriteria(Criteria $criteria, $field, $values)
  {
    if (!is_array($values))
    {
      $values = array($values);
    }

    if (!count($values))
    {
      return;
    }

    $criteria->addJoin(sfGuardUserGroupPeer::USER_ID, sfGuardUserPeer::ID);

    $value = array_pop($values);
    $criterion = $criteria->getNewCriterion(sfGuardUserGroupPeer::GROUP_ID, $value);

    foreach ($values as $value)
    {
      $criterion->addOr($criteria->getNewCriterion(sfGuardUserGroupPeer::GROUP_ID, $value));
    }

    $criteria->add($criterion);
  }

  public function addsfGuardUserPermissionListColumnCriteria(Criteria $criteria, $field, $values)
  {
    if (!is_array($values))
    {
      $values = array($values);
    }

    if (!count($values))
    {
      return;
    }

    $criteria->addJoin(sfGuardUserPermissionPeer::USER_ID, sfGuardUserPeer::ID);

    $value = array_pop($values);
    $criterion = $criteria->getNewCriterion(sfGuardUserPermissionPeer::PERMISSION_ID, $value);

    foreach ($values as $value)
    {
      $criterion->addOr($criteria->getNewCriterion(sfGuardUserPermissionPeer::PERMISSION_ID, $value));
    }

    $criteria->add($criterion);
  }

  public function getModelName()
  {
    return 'sfGuardUser';
  }

  public function getFields()
  {
    return array(
      'id'                            => 'Number',
      'user_partner_id'               => 'ForeignKey',
      'username'                      => 'Text',
      'title'                         => 'Text',
      'algorithm'                     => 'Text',
      'salt'                          => 'Text',
      'password'                      => 'Text',
      'created_at'                    => 'Date',
      'email'                         => 'Text',
      'phone'                         => 'Text',
      'last_login'                    => 'Date',
      'is_active'                     => 'Boolean',
      'is_super_admin'                => 'Boolean',
      'is_bot'                        => 'Boolean',
      'is_winner'                     => 'Boolean',
      'balance_bets'                  => 'Number',
      'balance_money'                 => 'Number',
      'balance_partner_total'         => 'Number',
      'balance_partner_used'          => 'Number',
      'name'                          => 'Text',
      'avatar'                        => 'Text',
      'rating'                        => 'Number',
      'rating_week'                   => 'Number',
      'sf_guard_user_group_list'      => 'ManyKey',
      'sf_guard_user_permission_list' => 'ManyKey',
    );
  }
}
