<?php

class usersInitTask extends sfBaseTask
{
    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
        new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name', 'frontend'),
        new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
        new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
        // add your own options here
        ));

        $this->namespace        = 'users';
        $this->name             = 'init';
        $this->briefDescription = '';
        $this->detailedDescription = '';
    }

    protected function execute($arguments = array(), $options = array())
    {
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'] ? $options['connection'] : null)->getConnection();

        // add your code here
        $users = sfGuardUserPeer::doSelect(new Criteria());

        foreach ($users as $user)
            if ($user->getId() > 18) {

                $user->setBalanceBets(0);
                $user->setBalanceMoney(0);
                $user->save();

                if (in_array($user->getId(), array(151, 156, 171, 107, 45, 199, 82, 168))) {
                    $betsPackageId = 6;
                    $voucherId = 2;

                } else {

                    $betsPackageId = 1;
                    $voucherId = 1;

                }

                $userBetsPackage = new UserBetsPackage();
                $userBetsPackage->setUserId($user->getId());
                $userBetsPackage->setBetsPackageId($betsPackageId);
                $userBetsPackage->setDtCreated(time());
                $userBetsPackage->save();

                $userVoucher = new UserVoucher();
                $userVoucher->setUserId($user->getId());
                $userVoucher->setVoucherId($voucherId);
                $userVoucher->setDtCreated(time());
                $userVoucher->save();

            }
    }
}
