<?php

class usersCheckratingTask extends sfBaseTask
{
    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
        new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name', 'frontend'),
        new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
        new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
        // add your own options here
        ));

        $this->namespace        = 'users';
        $this->name             = 'check-rating';
        $this->briefDescription = '';
        $this->detailedDescription = '';
    }

    protected function execute($arguments = array(), $options = array())
    {
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'] ? $options['connection'] : null)->getConnection();

        $c = new Criteria();
        $c->addDescendingOrderByColumn(sfGuardUserPeer::RATING_WEEK);
        $c->setLimit(3);

        $users = sfGuardUserPeer::doSelect($c);

        $betsPackages = sfConfig::get('app_rating_bets_packages');

        $i = 0;
        foreach ($users as $user ) { $i++;

            $package = BetsPackagePeer::retrieveByPK($betsPackages[$i-1]);

            // Создание платежа
            $payment = new Payment();
            $payment->setUserId($user->getId());
            $payment->setPaymentTypeId(sfConfig::get('app_pay_type_free_id'));
            $payment->setBetsPackageId($package->getId());
            $payment->setStatus(sfConfig::get('app_pay_status_complete'));
            $payment->setDtCreated(time());
            $payment->setDescription($package->getTitle());
            $payment->save();

        }

        $this->log('Done');
    }
}
