<?php

class usersCheckpartnersTask extends sfBaseTask
{
    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
        new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name', 'frontend'),
        new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'prod'),
        new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
        // add your own options here
        ));

        $this->namespace        = 'users';
        $this->name             = 'check-partners';
        $this->briefDescription = '';
        $this->detailedDescription = '';
    }

    protected function execute($arguments = array(), $options = array())
    {
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'] ? $options['connection'] : null)->getConnection();

        $c = new Criteria();
        $c->add(sfGuardUserPeer::USER_PARTNER_ID, 0, Criteria::GREATER_THAN);

        $users = sfGuardUserPeer::doSelect($c);

        $partnersAmount = array();
        foreach ($users as $user) {

            $connection = Propel::getConnection();
            $query = sprintf(
                'SELECT SUM(bp.bets_count)
                 FROM bets_package bp
                 INNER JOIN payment p ON bp.id = p.bets_package_id
                 WHERE p.user_id = %d AND p.status = %d AND p.payment_type_id <> %d',
                $user->getId(),
                sfConfig::get('app_pay_status_complete'),
                sfConfig::get('app_pay_type_free_id'),
                strtotime(date('d.m.Y'))
            );
            $statement = $connection->prepare($query);
            $statement->execute();

            $amount = $statement->fetchColumn();

            if (!array_key_exists($user->getUserPartnerId(), $partnersAmount))
                $partnersAmount[$user->getUserPartnerId()] = 0;

            $partnersAmount[$user->getUserPartnerId()] += $amount;

        }

        foreach ($partnersAmount as $userId => $amount) {

            if (!$user)
                continue;

            $user = sfCacheManager::getObject('sfGuardUser', $userId);
            $user->setBalancePartnerTotal($amount);
            $user->save();

        }


        $users = sfGuardUserPeer::doSelect(new Criteria());

        foreach ($users as $user) {

            $amountPartner = floor( sfConfig::get('app_partner_percent') / 100 * ($user->getBalancePartnerTotal() - $user->getBalancePartnerUsed()) );

            if ($amountPartner > 0) {

                // Пополнение баланса
                $user->setBalanceBets($user->getBalanceBets() + $amountPartner);
                $user->setBalancePartnerUsed($user->getBalancePartnerUsed() + ($amountPartner * 100 / sfConfig::get('app_partner_percent')) );
                $user->save();

                // Сохранение для отчета
                $partnerPayment = new PartnerPayment();
                $partnerPayment->setUserId($user->getId());
                $partnerPayment->setDt(time());
                $partnerPayment->setAmountBets($amountPartner);
                $partnerPayment->save();

                $this->log(sprintf('#%d [%s] - %d bets (%d)', $user->getId(), $user->getUsername(), $amountPartner, $user->getBalancePartnerTotal() - $user->getBalancePartnerUsed()));

            }

        }

        $this->log('Done');
    }
}
