<?php

define('PACKAGE_WEIGHT', 2);
define('BET_WEIGHT', 3);
define('CHAT_WEIGHT', 0.01);
define('LOT_WON_DIVIDER', 100);

class usersBuildratingTask extends sfBaseTask
{
    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
        new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name', 'frontend'),
        new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'prod'),
        new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
        // add your own options here
        ));

        $this->namespace        = 'users';
        $this->name             = 'build-rating';
        $this->briefDescription = '';
        $this->detailedDescription = '';
    }

    protected function execute($arguments = array(), $options = array())
    {
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'] ? $options['connection'] : null)->getConnection();

        $users = sfGuardUserPeer::doSelect(new Criteria());

        $connection = Propel::getConnection();
        $query = 'SELECT id FROM sf_guard_user';
        $statement = $connection->prepare($query);
        $statement->execute();

        while ($row = $statement->fetch()) {

            $user = sfCacheManager::getObject('sfGuardUser', $row['id']);

            if (!$user->getIsActive()) {
                $user->setRatingWeek(0);
                $user->save();

                unset($user);

                continue;
            }

            // ***** Общий рейтинг *****
            $rating = 0;

            // Купленные пакеты ставок
            $userBetsPackages = $user->getUserBetsPackages();
            foreach ($userBetsPackages as $userBetsPackage) {

                $betsPackage = $userBetsPackage->getBetsPackage();
                $rating += $betsPackage->getBetsCount() * PACKAGE_WEIGHT;

            }

            // Сделанные ставки
            $betsCount = $user->countBets();
            $rating += $betsCount * BET_WEIGHT;

            // Выигранные аукционы
            $c = new Criteria();
            $c->addJoin(LotPeer::BET_LAST_ID, BetPeer::ID, Criteria::INNER_JOIN);
            $c->add(LotPeer::IS_CLOSED, true);
            $c->add(BetPeer::USER_ID, $user->getId());

            $lotsWon = LotPeer::doSelect($c);

            foreach ($lotsWon as $lot) {

                $rating += $lot->getPrice() / LOT_WON_DIVIDER;

            }

            // Сообщения в чате
            $chatsCount = $user->countChats();
            $rating += $chatsCount * CHAT_WEIGHT;

            // ***** Недельный рейтинг *****
            $ratingWeek = 0;

            // Купленные пакеты ставок
            $c = new Criteria();
            //$c->add(UserBetsPackagePeer::DT_CREATED, $this->getWeekStartTimestamp(), Criteria::GREATER_THAN);
            $c->add(UserBetsPackagePeer::DT_CREATED, 'UNIX_TIMESTAMP(' . UserBetsPackagePeer::DT_CREATED . ') >= ' . $this->getWeekStartTimestamp(), Criteria::CUSTOM);
            $userBetsPackages = $user->getUserBetsPackages($c);
            foreach ($userBetsPackages as $userBetsPackage) {

                $betsPackage = $userBetsPackage->getBetsPackage();
                $ratingWeek += $betsPackage->getBetsCount() * PACKAGE_WEIGHT;

            }

            // Сделанные ставки
            $c = new Criteria();
            //$c->add(BetPeer::DT_CREATED, $this->getWeekStartTimestamp(), Criteria::GREATER_THAN);
            $c->add(BetPeer::DT_CREATED, 'UNIX_TIMESTAMP(' . BetPeer::DT_CREATED . ') >= ' . $this->getWeekStartTimestamp(), Criteria::CUSTOM);
            $betsCount = $user->countBets($c);
            $ratingWeek += $betsCount * BET_WEIGHT;

            // Выигранные аукционы
            $c = new Criteria();
            $c->addJoin(LotPeer::BET_LAST_ID, BetPeer::ID, Criteria::INNER_JOIN);
            $c->add(LotPeer::IS_CLOSED, true);
            $c->add(BetPeer::USER_ID, $user->getId());
            //$c->add(LotPeer::DT_END, $this->getWeekStartTimestamp(), Criteria::GREATER_THAN);
            $c->add(LotPeer::DT_END, 'UNIX_TIMESTAMP(' . LotPeer::DT_END . ') >= ' . $this->getWeekStartTimestamp(), Criteria::CUSTOM);

            $lotsWon = LotPeer::doSelect($c);

            foreach ($lotsWon as $lot) {

                $ratingWeek += $lot->getPrice() / LOT_WON_DIVIDER;

            }

            // Сообщения в чате
            $c = new Criteria();
//            $c->add(ChatPeer::DT_CREATED, $this->getWeekStartTimestamp(), Criteria::GREATER_THAN);
            $c->add(ChatPeer::DT_CREATED, 'UNIX_TIMESTAMP(' . ChatPeer::DT_CREATED . ') >= ' . $this->getWeekStartTimestamp(), Criteria::CUSTOM);
            $chatsCount = $user->countChats($c);
            $ratingWeek += $chatsCount * CHAT_WEIGHT;

            $user->setRating($rating);
            $user->setRatingWeek($ratingWeek);
            $user->save();

            unset($user);

            usleep(200000);
        }

        $this->log('Done');
    }

    private function getWeekStartTimestamp()
    {
        return strtotime(date('d.m.Y')) - ((date('N')-1) * 3600 * 24);
    }
}
