<?php

class paymentCheckeasypayTask extends sfBaseTask
{
    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
        new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name', 'frontend'),
        new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
        new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
        // add your own options here
        ));

        $this->namespace        = 'payment';
        $this->name             = 'check-easypay';
        $this->briefDescription = '';
        $this->detailedDescription = '';
    }

    protected function execute($arguments = array(), $options = array())
    {
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'] ? $options['connection'] : null)->getConnection();

        $cacheKey = 'PAYMENTS_INCOMPLETE_EASYPAY_LIST';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(PaymentPeer::PAYMENT_TYPE_ID, sfConfig::get('app_pay_type_easypay_id'));
            $c->add(PaymentPeer::STATUS, sfConfig::get('app_pay_status_incomplete'));

            $payments = PaymentPeer::doSelect($c);

            sfCacheManager::set($cacheKey, $payments, array('PaymentList'), 24*3600);

        } else {

            $payments = sfCacheManager::get($cacheKey);

        }

        foreach ($payments as $payment) {

            // Формирование запроса
            $params = array(
                'mer_no'    => sfConfig::get('app_pay_easypay_mer_no'),   // тестовый ПТС
                'pass'      => sfConfig::get('app_pay_easypay_mer_pass'), // пароль на тестовый ПТС
                'order'     => $payment->getId()
            );

            $client = new SoapClient(sfConfig::get('app_pay_easypay_wsdl'),
                array(
                    'trace'    => 1,
                    'encoding' => 'windows-1251'
                )
            );

            try {

                $answer = $client->EP_IsInvoicePaid($params);

            } catch (SoapFault $fault) {

                print 'Error';

            }

            $code = (int) $answer->status->code;

            switch ($code) {
                case 200: // Счет оплачен
                    $payment->setStatus(sfConfig::get('app_pay_status_complete'));
                    $payment->save();

                    break;

                case 503: // Счет удален
                    $payment->setStatus(sfConfig::get('app_pay_status_cancelled'));
                    $payment->save();

                    break;
            }

            print $payment->getId() . ' - ' . $code . "\r\n";

        }
    }
}
