<?php

// CRON, интервал - 1 секунда

// 1. Для каждого аукциона, после каждой ставки заранее выставляется интервал для срабатывания автоставки
// 2. Данный скрипт запускается каждую секунду. Для каждого лота, в случае срабатывания условия подачи автоставки:
// 2.1. Получается список заявок на автоставки от реальных пользователей. Выбирается случайный.
// 2.2. В случае отстутствия реальных пользователей, выбирается случайный бот.

class lotsProcessbetsTask extends sfBaseTask
{
    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
                new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name', 'frontend'),
                new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'prod'),
                new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
                // add your own options here
            ));

        $this->namespace        = 'lots';
        $this->name             = 'process-bets';
        $this->briefDescription = '';
        $this->detailedDescription = '';
    }

    protected function execute($arguments = array(), $options = array())
    {
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'] ? $options['connection'] : null)->getConnection();

        while (true) {

            $lots = $this->getLots();

            foreach ($lots as $lot) { // $lot - не актуальный, возможно устаревший объект!

                LotPeer::removeInstanceFromPool($lot); // Удаляем информацию об устаревшем объекте
                //$lot = sfCacheManager::getObject('Lot', $lot->getId());
                $lot = LotPeer::retrieveByPK($lot->getId());

                // ********* РУЧНЫЕ СТАВКИ *********

                if (!$lot->isClosedByTime()) {

                    $c = new Criteria();
                    $c->addDescendingOrderByColumn(BetRequestPeer::ID);
                    $betRequests = BetRequestPeer::doSelect($c);

                    if ($betRequests) {

                        foreach ($betRequests as $betRequest) {

                            $result = sfAuctionApi::betAdd($betRequest->getUserId(), $betRequest->getLotId(), false);

                            $betRequest->delete();

                        }

                        continue;
                    }

                }

                // ********* АВТО СТАВКИ *********

                if (!$lot->isClosedByTime() && time() >= strtotime($lot->getDtAutobet())) {

//                    $autobets = $this->getAutobets($lot, true); // Реальные пользователи
//
//                    if (!$autobets || count($autobets) < 2)

                    $autobets = $this->getAutobets($lot, false); // Все пользователи

                    if (!$autobets)
                        continue;

                    $autobetIndex = rand(0, count($autobets)-1); // Случайная автоставка
                    $autobet = $autobets[$autobetIndex];

                    LotAutobetPeer::removeInstanceFromPool($autobet); // Удаляем информацию об устаревшем объекте
                    //$autobet = sfCacheManager::getObject('LotAutobet', $autobet->getId());
                    $autobet = LotAutobetPeer::retrieveByPK($autobet->getId());

                    $result = sfAuctionApi::betAdd($autobet->getUserId(), $lot->getId(), true);

                    if (true === $result) {

                        $autobet->setBetsCompleted($autobet->getBetsCompleted() + 1);
                        $autobet->save();

                    }

                }

            }

            usleep(500000);

        } // while

    }

    private function getLots()
    {
        $cache_key = 'LOTS_LIST_NOT_CLOSED_FULL';
        if (!sfCacheManager::has($cache_key)) {

            $c = new Criteria();
            $c->add(LotPeer::IS_CLOSED, false);

            $lots = LotPeer::doSelect($c);

            sfCacheManager::set($cache_key, $lots, array('LotList'), 24*3600);

        } else {

            $lots = sfCacheManager::get($cache_key);

        }

        return $lots;
    }

    private function getAutobets(Lot $lot, $isHumanOnly = false)
    {
        $c = new Criteria();
        $c->addJoin(LotAutobetPeer::USER_ID, sfGuardUserPeer::ID, Criteria::INNER_JOIN);
        $c->add(sfGuardUserPeer::BALANCE_BETS, 0, Criteria::GREATER_THAN);

        if ($bet = $lot->getBet()) // Если была хотя бы одна ставка
            $c->add(LotAutobetPeer::USER_ID, $bet->getUserId(), Criteria::NOT_EQUAL);

        $c->add(LotAutobetPeer::LOT_ID, $lot->getId());

        if ($isHumanOnly) {
            $c->add(sfGuardUserPeer::IS_BOT, false);
        }

        $criterionFrom = $c->getNewCriterion(LotAutobetPeer::PRICE_FROM, null);
        $criterionFrom->addOr($c->getNewCriterion(LotAutobetPeer::PRICE_FROM, 0));
        $criterionFrom->addOr($c->getNewCriterion(LotAutobetPeer::PRICE_FROM, $lot->getPrice(), Criteria::LESS_EQUAL));

        $criterionTo = $c->getNewCriterion(LotAutobetPeer::PRICE_TO, null);
        $criterionTo->addOr($c->getNewCriterion(LotAutobetPeer::PRICE_TO, 0));
        $criterionTo->addOr($c->getNewCriterion(LotAutobetPeer::PRICE_TO, $lot->getPrice(), Criteria::GREATER_EQUAL));

        $criterionCount = $c->getNewCriterion(LotAutobetPeer::BETS_LIMIT, null);
        $criterionCount->addOr($c->getNewCriterion(LotAutobetPeer::BETS_COMPLETED, null));
        $criterionCount->addOr($c->getNewCriterion(LotAutobetPeer::BETS_LIMIT, 0));
        $criterionCount->addOr($c->getNewCriterion(LotAutobetPeer::BETS_LIMIT, LotAutobetPeer::BETS_LIMIT . ' > ' . LotAutobetPeer::BETS_COMPLETED, Criteria::CUSTOM));

        $c->add($criterionFrom)
          ->add($criterionTo)
          ->add($criterionCount);

        $autobets = LotAutobetPeer::doSelect($c);

        return $autobets;
    }
}
