<?php

class lotsDeclinelotTask extends sfBaseTask
{
    protected function configure()
    {
        $this->addArguments(array(
            new sfCommandArgument('lot', sfCommandArgument::REQUIRED, 'Lot ID'),
        ));

        $this->addOptions(array(
            new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name', 'frontend'),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'prod'),
            new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
        ));

        $this->namespace        = 'lots';
        $this->name             = 'decline-lot';
        $this->briefDescription = '';
        $this->detailedDescription = '';
    }

    protected function execute($arguments = array(), $options = array())
    {
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'] ? $options['connection'] : null)->getConnection();

        $lotId = $arguments['lot'];

        $c = new Criteria();
        $c->add(BetPeer::LOT_ID, $lotId);

        $bets = BetPeer::doSelect($c);

        foreach ($bets as $bet) {

            $user = sfCacheManager::getObject('sfGuardUser', $bet->getUserId());
            $user->setBalanceBets($user->getBalanceBets() + 1);
            $user->save();

        }

        $this->log('Done. Processed ' . count($bets) . ' bets.');
    }
}
