<?php

// CRON, интервал - 10 минут

class lotsCheckstatusTask extends sfBaseTask
{
    protected function configure()
    {
        // // add your own arguments here
        // $this->addArguments(array(
        //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
        // ));

        $this->addOptions(array(
                new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name', 'frontend'),
                new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'prod'),
                new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'propel'),
                // add your own options here
            ));

        $this->namespace        = 'lots';
        $this->name             = 'check-status';
        $this->briefDescription = '';
        $this->detailedDescription = '';
    }

    protected function execute($arguments = array(), $options = array())
    {
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'] ? $options['connection'] : null)->getConnection();

        // Просматриваем завершенные только что аукционы
        $c = new Criteria();
        $c->add(LotPeer::IS_CLOSED, false);

        $lots = LotPeer::doSelect($c);

        $isChanged = false;
        foreach ($lots as $lot)
            if ($lot->isClosedByTime()) {

                $lot->setIsClosed(true);
                $lot->save();

                $isChanged = true;

            }

        if ($isChanged)
            sfCacheManager::removeTag('LotList');

        // Просматриваем все завершенные аукционы
        $c = new Criteria();
        $c->add(LotPeer::IS_CLOSED, true);

        $lots = LotPeer::doSelect($c);

        foreach ($lots as $lot) {

            $betLast = sfCacheManager::getObject('Bet', $lot->getBetLastId());

            if (!$betLast)
                continue;

            $user = sfCacheManager::getObject('sfGuardUser', $betLast->getUserId());

            if (!$user || $user->getIsWinner())
                continue;

            $user->setIsWinner(true);
            $user->save();

        }

        $this->log('Done');
    }
}
