<?php

class sfCachePager extends sfPropelPager
{
    protected $tag = null;

    public function __construct($class, $tag, $maxPerPage = 10)
    {
        $this->tag = $tag;

        parent::__construct($class, $maxPerPage);
    }

    public function init()
    {
        $hasMaxRecordLimit = ($this->getMaxRecordLimit() !== false);
        $maxRecordLimit = $this->getMaxRecordLimit();

        $cForCount = clone $this->getCriteria();
        $cForCount->setOffset(0);
        $cForCount->setLimit(0);
//        $cForCount->clearGroupByColumns();

        $cacheKey = $this->getCacheKey() . '_count_' . md5($cForCount->toString());
        if (!$count = sfCacheManager::get($cacheKey)) {

            $count = call_user_func(array($this->getClassPeer(), $this->getPeerCountMethod()), $cForCount);

            sfCacheManager::set($cacheKey, $count, array($this->tag, $this->getCacheTag()));
        }

        $this->setNbResults($hasMaxRecordLimit ? min($count, $maxRecordLimit) : $count);

        $c = $this->getCriteria();
        $c->setOffset(0);
        $c->setLimit(0);

        if (($this->getPage() == 0 || $this->getMaxPerPage() == 0))
        {
            $this->setLastPage(0);
        }
        else
        {
            $this->setLastPage(ceil($this->getNbResults() / $this->getMaxPerPage()));

            $offset = ($this->getPage() - 1) * $this->getMaxPerPage();
            $c->setOffset($offset);

            if ($hasMaxRecordLimit)
            {
                $maxRecordLimit = $maxRecordLimit - $offset;
                if ($maxRecordLimit > $this->getMaxPerPage())
                {
                    $c->setLimit($this->getMaxPerPage());
                }
                else
                {
                    $c->setLimit($maxRecordLimit);
                }
            }
            else
            {
                $c->setLimit($this->getMaxPerPage());
            }
        }
    }

    protected function retrieveObject($offset)
    {
        $cForRetrieve = clone $this->getCriteria();
        $cForRetrieve->setOffset($offset - 1);
        $cForRetrieve->setLimit(1);

        $cacheKey = $this->getCacheKey() . '_object_' . md5($cForRetrieve->toString());
        if (!$results = sfCacheManager::get($cacheKey)) {

            $results = call_user_func(array($this->getClassPeer(), $this->getPeerMethod()), $cForRetrieve);

            sfCacheManager::set($cacheKey, $results, array($this->tag, $this->getCacheTag()));
        }

        return is_array($results) && isset($results[0]) ? $results[0] : null;
    }

    public function getResults()
    {
        $c = $this->getCriteria();

        $cacheKey = $this->getCacheKey() . '_results_' . md5($c->toString());
        if (!$results = sfCacheManager::get($cacheKey)) {

            $results = call_user_func(array($this->getClassPeer(), $this->getPeerMethod()), $c);

            sfCacheManager::set($cacheKey, $results, array($this->tag, $this->getCacheTag()));
        }

        return $results;
    }

    static public function getObjectCacheTag ($class)
    {
        return 'TAG_PAGER_' . $class . 'Peer';
    }

    private function getCacheKey()
    {
        return 'PAGER_' . $this->getClassPeer() . $this->getPeerCountMethod() . md5(serialize($this->getCriteria()));
    }

    private function getCacheTag()
    {
        return 'TAG_PAGER_' . $this->getClassPeer();
    }
}