<?php

/**
 * Base class that represents a row from the 'product' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * 04/06/09 03:38:50
 *
 * @package    lib.model.om
 */
abstract class BaseProduct extends BaseObject  implements Persistent {


  const PEER = 'ProductPeer';

	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        ProductPeer
	 */
	protected static $peer;

	/**
	 * The value for the id field.
	 * @var        int
	 */
	protected $id;

	/**
	 * The value for the category_id field.
	 * @var        int
	 */
	protected $category_id;

	/**
	 * The value for the title field.
	 * @var        string
	 */
	protected $title;

	/**
	 * The value for the title_full field.
	 * @var        string
	 */
	protected $title_full;

	/**
	 * The value for the description_short field.
	 * @var        string
	 */
	protected $description_short;

	/**
	 * The value for the description_full field.
	 * @var        string
	 */
	protected $description_full;

	/**
	 * The value for the price field.
	 * @var        int
	 */
	protected $price;

	/**
	 * The value for the image_main field.
	 * @var        string
	 */
	protected $image_main;

	/**
	 * The value for the image_main_thumb field.
	 * @var        string
	 */
	protected $image_main_thumb;

	/**
	 * The value for the image_icon field.
	 * @var        string
	 */
	protected $image_icon;

	/**
	 * The value for the image1 field.
	 * @var        string
	 */
	protected $image1;

	/**
	 * The value for the image1_thumb field.
	 * @var        string
	 */
	protected $image1_thumb;

	/**
	 * The value for the image2 field.
	 * @var        string
	 */
	protected $image2;

	/**
	 * The value for the image2_thumb field.
	 * @var        string
	 */
	protected $image2_thumb;

	/**
	 * The value for the image3 field.
	 * @var        string
	 */
	protected $image3;

	/**
	 * The value for the image3_thumb field.
	 * @var        string
	 */
	protected $image3_thumb;

	/**
	 * The value for the image4 field.
	 * @var        string
	 */
	protected $image4;

	/**
	 * The value for the image4_thumb field.
	 * @var        string
	 */
	protected $image4_thumb;

	/**
	 * @var        Category
	 */
	protected $aCategory;

	/**
	 * @var        array Lot[] Collection to store aggregation of Lot objects.
	 */
	protected $collLots;

	/**
	 * @var        Criteria The criteria used to select the current contents of collLots.
	 */
	private $lastLotCriteria = null;

	/**
	 * @var        array ProductPhoto[] Collection to store aggregation of ProductPhoto objects.
	 */
	protected $collProductPhotos;

	/**
	 * @var        Criteria The criteria used to select the current contents of collProductPhotos.
	 */
	private $lastProductPhotoCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseProduct object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [id] column value.
	 * 
	 * @return     int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * Get the [category_id] column value.
	 * 
	 * @return     int
	 */
	public function getCategoryId()
	{
		return $this->category_id;
	}

	/**
	 * Get the [title] column value.
	 * 
	 * @return     string
	 */
	public function getTitle()
	{
		return $this->title;
	}

	/**
	 * Get the [title_full] column value.
	 * 
	 * @return     string
	 */
	public function getTitleFull()
	{
		return $this->title_full;
	}

	/**
	 * Get the [description_short] column value.
	 * 
	 * @return     string
	 */
	public function getDescriptionShort()
	{
		return $this->description_short;
	}

	/**
	 * Get the [description_full] column value.
	 * 
	 * @return     string
	 */
	public function getDescriptionFull()
	{
		return $this->description_full;
	}

	/**
	 * Get the [price] column value.
	 * 
	 * @return     int
	 */
	public function getPrice()
	{
		return $this->price;
	}

	/**
	 * Get the [image_main] column value.
	 * 
	 * @return     string
	 */
	public function getImageMain()
	{
		return $this->image_main;
	}

	/**
	 * Get the [image_main_thumb] column value.
	 * 
	 * @return     string
	 */
	public function getImageMainThumb()
	{
		return $this->image_main_thumb;
	}

	/**
	 * Get the [image_icon] column value.
	 * 
	 * @return     string
	 */
	public function getImageIcon()
	{
		return $this->image_icon;
	}

	/**
	 * Get the [image1] column value.
	 * 
	 * @return     string
	 */
	public function getImage1()
	{
		return $this->image1;
	}

	/**
	 * Get the [image1_thumb] column value.
	 * 
	 * @return     string
	 */
	public function getImage1Thumb()
	{
		return $this->image1_thumb;
	}

	/**
	 * Get the [image2] column value.
	 * 
	 * @return     string
	 */
	public function getImage2()
	{
		return $this->image2;
	}

	/**
	 * Get the [image2_thumb] column value.
	 * 
	 * @return     string
	 */
	public function getImage2Thumb()
	{
		return $this->image2_thumb;
	}

	/**
	 * Get the [image3] column value.
	 * 
	 * @return     string
	 */
	public function getImage3()
	{
		return $this->image3;
	}

	/**
	 * Get the [image3_thumb] column value.
	 * 
	 * @return     string
	 */
	public function getImage3Thumb()
	{
		return $this->image3_thumb;
	}

	/**
	 * Get the [image4] column value.
	 * 
	 * @return     string
	 */
	public function getImage4()
	{
		return $this->image4;
	}

	/**
	 * Get the [image4_thumb] column value.
	 * 
	 * @return     string
	 */
	public function getImage4Thumb()
	{
		return $this->image4_thumb;
	}

	/**
	 * Set the value of [id] column.
	 * 
	 * @param      int $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->id !== $v) {
			$this->id = $v;
			$this->modifiedColumns[] = ProductPeer::ID;
		}

		return $this;
	} // setId()

	/**
	 * Set the value of [category_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setCategoryId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->category_id !== $v) {
			$this->category_id = $v;
			$this->modifiedColumns[] = ProductPeer::CATEGORY_ID;
		}

		if ($this->aCategory !== null && $this->aCategory->getId() !== $v) {
			$this->aCategory = null;
		}

		return $this;
	} // setCategoryId()

	/**
	 * Set the value of [title] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setTitle($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->title !== $v) {
			$this->title = $v;
			$this->modifiedColumns[] = ProductPeer::TITLE;
		}

		return $this;
	} // setTitle()

	/**
	 * Set the value of [title_full] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setTitleFull($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->title_full !== $v) {
			$this->title_full = $v;
			$this->modifiedColumns[] = ProductPeer::TITLE_FULL;
		}

		return $this;
	} // setTitleFull()

	/**
	 * Set the value of [description_short] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setDescriptionShort($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->description_short !== $v) {
			$this->description_short = $v;
			$this->modifiedColumns[] = ProductPeer::DESCRIPTION_SHORT;
		}

		return $this;
	} // setDescriptionShort()

	/**
	 * Set the value of [description_full] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setDescriptionFull($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->description_full !== $v) {
			$this->description_full = $v;
			$this->modifiedColumns[] = ProductPeer::DESCRIPTION_FULL;
		}

		return $this;
	} // setDescriptionFull()

	/**
	 * Set the value of [price] column.
	 * 
	 * @param      int $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setPrice($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->price !== $v) {
			$this->price = $v;
			$this->modifiedColumns[] = ProductPeer::PRICE;
		}

		return $this;
	} // setPrice()

	/**
	 * Set the value of [image_main] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImageMain($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image_main !== $v) {
			$this->image_main = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE_MAIN;
		}

		return $this;
	} // setImageMain()

	/**
	 * Set the value of [image_main_thumb] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImageMainThumb($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image_main_thumb !== $v) {
			$this->image_main_thumb = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE_MAIN_THUMB;
		}

		return $this;
	} // setImageMainThumb()

	/**
	 * Set the value of [image_icon] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImageIcon($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image_icon !== $v) {
			$this->image_icon = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE_ICON;
		}

		return $this;
	} // setImageIcon()

	/**
	 * Set the value of [image1] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImage1($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image1 !== $v) {
			$this->image1 = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE1;
		}

		return $this;
	} // setImage1()

	/**
	 * Set the value of [image1_thumb] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImage1Thumb($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image1_thumb !== $v) {
			$this->image1_thumb = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE1_THUMB;
		}

		return $this;
	} // setImage1Thumb()

	/**
	 * Set the value of [image2] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImage2($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image2 !== $v) {
			$this->image2 = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE2;
		}

		return $this;
	} // setImage2()

	/**
	 * Set the value of [image2_thumb] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImage2Thumb($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image2_thumb !== $v) {
			$this->image2_thumb = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE2_THUMB;
		}

		return $this;
	} // setImage2Thumb()

	/**
	 * Set the value of [image3] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImage3($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image3 !== $v) {
			$this->image3 = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE3;
		}

		return $this;
	} // setImage3()

	/**
	 * Set the value of [image3_thumb] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImage3Thumb($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image3_thumb !== $v) {
			$this->image3_thumb = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE3_THUMB;
		}

		return $this;
	} // setImage3Thumb()

	/**
	 * Set the value of [image4] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImage4($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image4 !== $v) {
			$this->image4 = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE4;
		}

		return $this;
	} // setImage4()

	/**
	 * Set the value of [image4_thumb] column.
	 * 
	 * @param      string $v new value
	 * @return     Product The current object (for fluent API support)
	 */
	public function setImage4Thumb($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->image4_thumb !== $v) {
			$this->image4_thumb = $v;
			$this->modifiedColumns[] = ProductPeer::IMAGE4_THUMB;
		}

		return $this;
	} // setImage4Thumb()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->category_id = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->title = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
			$this->title_full = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->description_short = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->description_full = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
			$this->price = ($row[$startcol + 6] !== null) ? (int) $row[$startcol + 6] : null;
			$this->image_main = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
			$this->image_main_thumb = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
			$this->image_icon = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
			$this->image1 = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
			$this->image1_thumb = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
			$this->image2 = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
			$this->image2_thumb = ($row[$startcol + 13] !== null) ? (string) $row[$startcol + 13] : null;
			$this->image3 = ($row[$startcol + 14] !== null) ? (string) $row[$startcol + 14] : null;
			$this->image3_thumb = ($row[$startcol + 15] !== null) ? (string) $row[$startcol + 15] : null;
			$this->image4 = ($row[$startcol + 16] !== null) ? (string) $row[$startcol + 16] : null;
			$this->image4_thumb = ($row[$startcol + 17] !== null) ? (string) $row[$startcol + 17] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 18; // 18 = ProductPeer::NUM_COLUMNS - ProductPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Product object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->aCategory !== null && $this->category_id !== $this->aCategory->getId()) {
			$this->aCategory = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = ProductPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->aCategory = null;
			$this->collLots = null;
			$this->lastLotCriteria = null;

			$this->collProductPhotos = null;
			$this->lastProductPhotoCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BaseProduct:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			ProductPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseProduct:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BaseProduct:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(ProductPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
    foreach (sfMixer::getCallables('BaseProduct:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			ProductPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aCategory !== null) {
				if ($this->aCategory->isModified() || $this->aCategory->isNew()) {
					$affectedRows += $this->aCategory->save($con);
				}
				$this->setCategory($this->aCategory);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = ProductPeer::ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = ProductPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += ProductPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collLots !== null) {
				foreach ($this->collLots as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductPhotos !== null) {
				foreach ($this->collProductPhotos as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aCategory !== null) {
				if (!$this->aCategory->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCategory->getValidationFailures());
				}
			}


			if (($retval = ProductPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collLots !== null) {
					foreach ($this->collLots as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductPhotos !== null) {
					foreach ($this->collProductPhotos as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getCategoryId();
				break;
			case 2:
				return $this->getTitle();
				break;
			case 3:
				return $this->getTitleFull();
				break;
			case 4:
				return $this->getDescriptionShort();
				break;
			case 5:
				return $this->getDescriptionFull();
				break;
			case 6:
				return $this->getPrice();
				break;
			case 7:
				return $this->getImageMain();
				break;
			case 8:
				return $this->getImageMainThumb();
				break;
			case 9:
				return $this->getImageIcon();
				break;
			case 10:
				return $this->getImage1();
				break;
			case 11:
				return $this->getImage1Thumb();
				break;
			case 12:
				return $this->getImage2();
				break;
			case 13:
				return $this->getImage2Thumb();
				break;
			case 14:
				return $this->getImage3();
				break;
			case 15:
				return $this->getImage3Thumb();
				break;
			case 16:
				return $this->getImage4();
				break;
			case 17:
				return $this->getImage4Thumb();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = ProductPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getCategoryId(),
			$keys[2] => $this->getTitle(),
			$keys[3] => $this->getTitleFull(),
			$keys[4] => $this->getDescriptionShort(),
			$keys[5] => $this->getDescriptionFull(),
			$keys[6] => $this->getPrice(),
			$keys[7] => $this->getImageMain(),
			$keys[8] => $this->getImageMainThumb(),
			$keys[9] => $this->getImageIcon(),
			$keys[10] => $this->getImage1(),
			$keys[11] => $this->getImage1Thumb(),
			$keys[12] => $this->getImage2(),
			$keys[13] => $this->getImage2Thumb(),
			$keys[14] => $this->getImage3(),
			$keys[15] => $this->getImage3Thumb(),
			$keys[16] => $this->getImage4(),
			$keys[17] => $this->getImage4Thumb(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = ProductPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setCategoryId($value);
				break;
			case 2:
				$this->setTitle($value);
				break;
			case 3:
				$this->setTitleFull($value);
				break;
			case 4:
				$this->setDescriptionShort($value);
				break;
			case 5:
				$this->setDescriptionFull($value);
				break;
			case 6:
				$this->setPrice($value);
				break;
			case 7:
				$this->setImageMain($value);
				break;
			case 8:
				$this->setImageMainThumb($value);
				break;
			case 9:
				$this->setImageIcon($value);
				break;
			case 10:
				$this->setImage1($value);
				break;
			case 11:
				$this->setImage1Thumb($value);
				break;
			case 12:
				$this->setImage2($value);
				break;
			case 13:
				$this->setImage2Thumb($value);
				break;
			case 14:
				$this->setImage3($value);
				break;
			case 15:
				$this->setImage3Thumb($value);
				break;
			case 16:
				$this->setImage4($value);
				break;
			case 17:
				$this->setImage4Thumb($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = ProductPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setCategoryId($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setTitle($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setTitleFull($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setDescriptionShort($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setDescriptionFull($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setPrice($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setImageMain($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setImageMainThumb($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setImageIcon($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setImage1($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setImage1Thumb($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setImage2($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setImage2Thumb($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setImage3($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setImage3Thumb($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setImage4($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setImage4Thumb($arr[$keys[17]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(ProductPeer::DATABASE_NAME);

		if ($this->isColumnModified(ProductPeer::ID)) $criteria->add(ProductPeer::ID, $this->id);
		if ($this->isColumnModified(ProductPeer::CATEGORY_ID)) $criteria->add(ProductPeer::CATEGORY_ID, $this->category_id);
		if ($this->isColumnModified(ProductPeer::TITLE)) $criteria->add(ProductPeer::TITLE, $this->title);
		if ($this->isColumnModified(ProductPeer::TITLE_FULL)) $criteria->add(ProductPeer::TITLE_FULL, $this->title_full);
		if ($this->isColumnModified(ProductPeer::DESCRIPTION_SHORT)) $criteria->add(ProductPeer::DESCRIPTION_SHORT, $this->description_short);
		if ($this->isColumnModified(ProductPeer::DESCRIPTION_FULL)) $criteria->add(ProductPeer::DESCRIPTION_FULL, $this->description_full);
		if ($this->isColumnModified(ProductPeer::PRICE)) $criteria->add(ProductPeer::PRICE, $this->price);
		if ($this->isColumnModified(ProductPeer::IMAGE_MAIN)) $criteria->add(ProductPeer::IMAGE_MAIN, $this->image_main);
		if ($this->isColumnModified(ProductPeer::IMAGE_MAIN_THUMB)) $criteria->add(ProductPeer::IMAGE_MAIN_THUMB, $this->image_main_thumb);
		if ($this->isColumnModified(ProductPeer::IMAGE_ICON)) $criteria->add(ProductPeer::IMAGE_ICON, $this->image_icon);
		if ($this->isColumnModified(ProductPeer::IMAGE1)) $criteria->add(ProductPeer::IMAGE1, $this->image1);
		if ($this->isColumnModified(ProductPeer::IMAGE1_THUMB)) $criteria->add(ProductPeer::IMAGE1_THUMB, $this->image1_thumb);
		if ($this->isColumnModified(ProductPeer::IMAGE2)) $criteria->add(ProductPeer::IMAGE2, $this->image2);
		if ($this->isColumnModified(ProductPeer::IMAGE2_THUMB)) $criteria->add(ProductPeer::IMAGE2_THUMB, $this->image2_thumb);
		if ($this->isColumnModified(ProductPeer::IMAGE3)) $criteria->add(ProductPeer::IMAGE3, $this->image3);
		if ($this->isColumnModified(ProductPeer::IMAGE3_THUMB)) $criteria->add(ProductPeer::IMAGE3_THUMB, $this->image3_thumb);
		if ($this->isColumnModified(ProductPeer::IMAGE4)) $criteria->add(ProductPeer::IMAGE4, $this->image4);
		if ($this->isColumnModified(ProductPeer::IMAGE4_THUMB)) $criteria->add(ProductPeer::IMAGE4_THUMB, $this->image4_thumb);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(ProductPeer::DATABASE_NAME);

		$criteria->add(ProductPeer::ID, $this->id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	/**
	 * Generic method to set the primary key (id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Product (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCategoryId($this->category_id);

		$copyObj->setTitle($this->title);

		$copyObj->setTitleFull($this->title_full);

		$copyObj->setDescriptionShort($this->description_short);

		$copyObj->setDescriptionFull($this->description_full);

		$copyObj->setPrice($this->price);

		$copyObj->setImageMain($this->image_main);

		$copyObj->setImageMainThumb($this->image_main_thumb);

		$copyObj->setImageIcon($this->image_icon);

		$copyObj->setImage1($this->image1);

		$copyObj->setImage1Thumb($this->image1_thumb);

		$copyObj->setImage2($this->image2);

		$copyObj->setImage2Thumb($this->image2_thumb);

		$copyObj->setImage3($this->image3);

		$copyObj->setImage3Thumb($this->image3_thumb);

		$copyObj->setImage4($this->image4);

		$copyObj->setImage4Thumb($this->image4_thumb);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getLots() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addLot($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getProductPhotos() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addProductPhoto($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Product Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     ProductPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new ProductPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a Category object.
	 *
	 * @param      Category $v
	 * @return     Product The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setCategory(Category $v = null)
	{
		if ($v === null) {
			$this->setCategoryId(NULL);
		} else {
			$this->setCategoryId($v->getId());
		}

		$this->aCategory = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Category object, it will not be re-added.
		if ($v !== null) {
			$v->addProduct($this);
		}

		return $this;
	}


	/**
	 * Get the associated Category object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Category The associated Category object.
	 * @throws     PropelException
	 */
	public function getCategory(PropelPDO $con = null)
	{
		if ($this->aCategory === null && ($this->category_id !== null)) {
			$c = new Criteria(CategoryPeer::DATABASE_NAME);
			$c->add(CategoryPeer::ID, $this->category_id);
			$this->aCategory = CategoryPeer::doSelectOne($c, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aCategory->addProducts($this);
			 */
		}
		return $this->aCategory;
	}

	/**
	 * Clears out the collLots collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addLots()
	 */
	public function clearLots()
	{
		$this->collLots = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collLots collection (array).
	 *
	 * By default this just sets the collLots collection to an empty array (like clearcollLots());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initLots()
	{
		$this->collLots = array();
	}

	/**
	 * Gets an array of Lot objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Product has previously been saved, it will retrieve
	 * related Lots from storage. If this Product is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Lot[]
	 * @throws     PropelException
	 */
	public function getLots($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ProductPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLots === null) {
			if ($this->isNew()) {
			   $this->collLots = array();
			} else {

				$criteria->add(LotPeer::PRODUCT_ID, $this->id);

				LotPeer::addSelectColumns($criteria);
				$this->collLots = LotPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(LotPeer::PRODUCT_ID, $this->id);

				LotPeer::addSelectColumns($criteria);
				if (!isset($this->lastLotCriteria) || !$this->lastLotCriteria->equals($criteria)) {
					$this->collLots = LotPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastLotCriteria = $criteria;
		return $this->collLots;
	}

	/**
	 * Returns the number of related Lot objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Lot objects.
	 * @throws     PropelException
	 */
	public function countLots(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ProductPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collLots === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(LotPeer::PRODUCT_ID, $this->id);

				$count = LotPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(LotPeer::PRODUCT_ID, $this->id);

				if (!isset($this->lastLotCriteria) || !$this->lastLotCriteria->equals($criteria)) {
					$count = LotPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collLots);
				}
			} else {
				$count = count($this->collLots);
			}
		}
		$this->lastLotCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Lot object to this object
	 * through the Lot foreign key attribute.
	 *
	 * @param      Lot $l Lot
	 * @return     void
	 * @throws     PropelException
	 */
	public function addLot(Lot $l)
	{
		if ($this->collLots === null) {
			$this->initLots();
		}
		if (!in_array($l, $this->collLots, true)) { // only add it if the **same** object is not already associated
			array_push($this->collLots, $l);
			$l->setProduct($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Product is new, it will return
	 * an empty collection; or if this Product has previously
	 * been saved, it will retrieve related Lots from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Product.
	 */
	public function getLotsJoinAuctionType($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ProductPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLots === null) {
			if ($this->isNew()) {
				$this->collLots = array();
			} else {

				$criteria->add(LotPeer::PRODUCT_ID, $this->id);

				$this->collLots = LotPeer::doSelectJoinAuctionType($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(LotPeer::PRODUCT_ID, $this->id);

			if (!isset($this->lastLotCriteria) || !$this->lastLotCriteria->equals($criteria)) {
				$this->collLots = LotPeer::doSelectJoinAuctionType($criteria, $con, $join_behavior);
			}
		}
		$this->lastLotCriteria = $criteria;

		return $this->collLots;
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Product is new, it will return
	 * an empty collection; or if this Product has previously
	 * been saved, it will retrieve related Lots from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Product.
	 */
	public function getLotsJoinBet($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ProductPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLots === null) {
			if ($this->isNew()) {
				$this->collLots = array();
			} else {

				$criteria->add(LotPeer::PRODUCT_ID, $this->id);

				$this->collLots = LotPeer::doSelectJoinBet($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(LotPeer::PRODUCT_ID, $this->id);

			if (!isset($this->lastLotCriteria) || !$this->lastLotCriteria->equals($criteria)) {
				$this->collLots = LotPeer::doSelectJoinBet($criteria, $con, $join_behavior);
			}
		}
		$this->lastLotCriteria = $criteria;

		return $this->collLots;
	}

	/**
	 * Clears out the collProductPhotos collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addProductPhotos()
	 */
	public function clearProductPhotos()
	{
		$this->collProductPhotos = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collProductPhotos collection (array).
	 *
	 * By default this just sets the collProductPhotos collection to an empty array (like clearcollProductPhotos());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initProductPhotos()
	{
		$this->collProductPhotos = array();
	}

	/**
	 * Gets an array of ProductPhoto objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Product has previously been saved, it will retrieve
	 * related ProductPhotos from storage. If this Product is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array ProductPhoto[]
	 * @throws     PropelException
	 */
	public function getProductPhotos($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ProductPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductPhotos === null) {
			if ($this->isNew()) {
			   $this->collProductPhotos = array();
			} else {

				$criteria->add(ProductPhotoPeer::PRODUCT_ID, $this->id);

				ProductPhotoPeer::addSelectColumns($criteria);
				$this->collProductPhotos = ProductPhotoPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(ProductPhotoPeer::PRODUCT_ID, $this->id);

				ProductPhotoPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductPhotoCriteria) || !$this->lastProductPhotoCriteria->equals($criteria)) {
					$this->collProductPhotos = ProductPhotoPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductPhotoCriteria = $criteria;
		return $this->collProductPhotos;
	}

	/**
	 * Returns the number of related ProductPhoto objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related ProductPhoto objects.
	 * @throws     PropelException
	 */
	public function countProductPhotos(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(ProductPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collProductPhotos === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(ProductPhotoPeer::PRODUCT_ID, $this->id);

				$count = ProductPhotoPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(ProductPhotoPeer::PRODUCT_ID, $this->id);

				if (!isset($this->lastProductPhotoCriteria) || !$this->lastProductPhotoCriteria->equals($criteria)) {
					$count = ProductPhotoPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collProductPhotos);
				}
			} else {
				$count = count($this->collProductPhotos);
			}
		}
		$this->lastProductPhotoCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a ProductPhoto object to this object
	 * through the ProductPhoto foreign key attribute.
	 *
	 * @param      ProductPhoto $l ProductPhoto
	 * @return     void
	 * @throws     PropelException
	 */
	public function addProductPhoto(ProductPhoto $l)
	{
		if ($this->collProductPhotos === null) {
			$this->initProductPhotos();
		}
		if (!in_array($l, $this->collProductPhotos, true)) { // only add it if the **same** object is not already associated
			array_push($this->collProductPhotos, $l);
			$l->setProduct($this);
		}
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collLots) {
				foreach ((array) $this->collLots as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collProductPhotos) {
				foreach ((array) $this->collProductPhotos as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collLots = null;
		$this->collProductPhotos = null;
			$this->aCategory = null;
	}


  public function __call($method, $arguments)
  {
    if (!$callable = sfMixer::getCallable('BaseProduct:'.$method))
    {
      throw new sfException(sprintf('Call to undefined method BaseProduct::%s', $method));
    }

    array_unshift($arguments, $this);

    return call_user_func_array($callable, $arguments);
  }


} // BaseProduct
