<?php

/**
 * Base class that represents a row from the 'lot' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * 04/06/09 03:38:49
 *
 * @package    lib.model.om
 */
abstract class BaseLot extends BaseObject  implements Persistent {


  const PEER = 'LotPeer';

	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        LotPeer
	 */
	protected static $peer;

	/**
	 * The value for the id field.
	 * @var        int
	 */
	protected $id;

	/**
	 * The value for the auction_type_id field.
	 * @var        int
	 */
	protected $auction_type_id;

	/**
	 * The value for the product_id field.
	 * @var        int
	 */
	protected $product_id;

	/**
	 * The value for the dt_start field.
	 * @var        string
	 */
	protected $dt_start;

	/**
	 * The value for the dt_end field.
	 * @var        string
	 */
	protected $dt_end;

	/**
	 * The value for the dt_autobet field.
	 * @var        string
	 */
	protected $dt_autobet;

	/**
	 * The value for the is_closed field.
	 * @var        boolean
	 */
	protected $is_closed;

	/**
	 * The value for the price field.
	 * @var        int
	 */
	protected $price;

	/**
	 * The value for the user field.
	 * @var        string
	 */
	protected $user;

	/**
	 * The value for the bet_last_id field.
	 * @var        int
	 */
	protected $bet_last_id;

	/**
	 * @var        AuctionType
	 */
	protected $aAuctionType;

	/**
	 * @var        Product
	 */
	protected $aProduct;

	/**
	 * @var        Bet
	 */
	protected $aBet;

	/**
	 * @var        array BetRequest[] Collection to store aggregation of BetRequest objects.
	 */
	protected $collBetRequests;

	/**
	 * @var        Criteria The criteria used to select the current contents of collBetRequests.
	 */
	private $lastBetRequestCriteria = null;

	/**
	 * @var        array LotAuctionOption[] Collection to store aggregation of LotAuctionOption objects.
	 */
	protected $collLotAuctionOptions;

	/**
	 * @var        Criteria The criteria used to select the current contents of collLotAuctionOptions.
	 */
	private $lastLotAuctionOptionCriteria = null;

	/**
	 * @var        array LotAutobet[] Collection to store aggregation of LotAutobet objects.
	 */
	protected $collLotAutobets;

	/**
	 * @var        Criteria The criteria used to select the current contents of collLotAutobets.
	 */
	private $lastLotAutobetCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseLot object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [id] column value.
	 * 
	 * @return     int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * Get the [auction_type_id] column value.
	 * 
	 * @return     int
	 */
	public function getAuctionTypeId()
	{
		return $this->auction_type_id;
	}

	/**
	 * Get the [product_id] column value.
	 * 
	 * @return     int
	 */
	public function getProductId()
	{
		return $this->product_id;
	}

	/**
	 * Get the [optionally formatted] temporal [dt_start] column value.
	 * 
	 *
	 * @param      string $format The date/time format string (either date()-style or strftime()-style).
	 *							If format is NULL, then the raw DateTime object will be returned.
	 * @return     mixed Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
	 * @throws     PropelException - if unable to parse/validate the date/time value.
	 */
	public function getDtStart($format = 'Y-m-d H:i:s')
	{
		if ($this->dt_start === null) {
			return null;
		}


		if ($this->dt_start === '0000-00-00 00:00:00') {
			// while technically this is not a default value of NULL,
			// this seems to be closest in meaning.
			return null;
		} else {
			try {
				$dt = new DateTime($this->dt_start);
			} catch (Exception $x) {
				throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->dt_start, true), $x);
			}
		}

		if ($format === null) {
			// Because propel.useDateTimeClass is TRUE, we return a DateTime object.
			return $dt;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $dt->format('U'));
		} else {
			return $dt->format($format);
		}
	}

	/**
	 * Get the [optionally formatted] temporal [dt_end] column value.
	 * 
	 *
	 * @param      string $format The date/time format string (either date()-style or strftime()-style).
	 *							If format is NULL, then the raw DateTime object will be returned.
	 * @return     mixed Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
	 * @throws     PropelException - if unable to parse/validate the date/time value.
	 */
	public function getDtEnd($format = 'Y-m-d H:i:s')
	{
		if ($this->dt_end === null) {
			return null;
		}


		if ($this->dt_end === '0000-00-00 00:00:00') {
			// while technically this is not a default value of NULL,
			// this seems to be closest in meaning.
			return null;
		} else {
			try {
				$dt = new DateTime($this->dt_end);
			} catch (Exception $x) {
				throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->dt_end, true), $x);
			}
		}

		if ($format === null) {
			// Because propel.useDateTimeClass is TRUE, we return a DateTime object.
			return $dt;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $dt->format('U'));
		} else {
			return $dt->format($format);
		}
	}

	/**
	 * Get the [optionally formatted] temporal [dt_autobet] column value.
	 * 
	 *
	 * @param      string $format The date/time format string (either date()-style or strftime()-style).
	 *							If format is NULL, then the raw DateTime object will be returned.
	 * @return     mixed Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
	 * @throws     PropelException - if unable to parse/validate the date/time value.
	 */
	public function getDtAutobet($format = 'Y-m-d H:i:s')
	{
		if ($this->dt_autobet === null) {
			return null;
		}


		if ($this->dt_autobet === '0000-00-00 00:00:00') {
			// while technically this is not a default value of NULL,
			// this seems to be closest in meaning.
			return null;
		} else {
			try {
				$dt = new DateTime($this->dt_autobet);
			} catch (Exception $x) {
				throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->dt_autobet, true), $x);
			}
		}

		if ($format === null) {
			// Because propel.useDateTimeClass is TRUE, we return a DateTime object.
			return $dt;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $dt->format('U'));
		} else {
			return $dt->format($format);
		}
	}

	/**
	 * Get the [is_closed] column value.
	 * 
	 * @return     boolean
	 */
	public function getIsClosed()
	{
		return $this->is_closed;
	}

	/**
	 * Get the [price] column value.
	 * 
	 * @return     int
	 */
	public function getPrice()
	{
		return $this->price;
	}

	/**
	 * Get the [user] column value.
	 * 
	 * @return     string
	 */
	public function getUser()
	{
		return $this->user;
	}

	/**
	 * Get the [bet_last_id] column value.
	 * 
	 * @return     int
	 */
	public function getBetLastId()
	{
		return $this->bet_last_id;
	}

	/**
	 * Set the value of [id] column.
	 * 
	 * @param      int $v new value
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->id !== $v) {
			$this->id = $v;
			$this->modifiedColumns[] = LotPeer::ID;
		}

		return $this;
	} // setId()

	/**
	 * Set the value of [auction_type_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setAuctionTypeId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->auction_type_id !== $v) {
			$this->auction_type_id = $v;
			$this->modifiedColumns[] = LotPeer::AUCTION_TYPE_ID;
		}

		if ($this->aAuctionType !== null && $this->aAuctionType->getId() !== $v) {
			$this->aAuctionType = null;
		}

		return $this;
	} // setAuctionTypeId()

	/**
	 * Set the value of [product_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setProductId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->product_id !== $v) {
			$this->product_id = $v;
			$this->modifiedColumns[] = LotPeer::PRODUCT_ID;
		}

		if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
			$this->aProduct = null;
		}

		return $this;
	} // setProductId()

	/**
	 * Sets the value of [dt_start] column to a normalized version of the date/time value specified.
	 * 
	 * @param      mixed $v string, integer (timestamp), or DateTime value.  Empty string will
	 *						be treated as NULL for temporal objects.
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setDtStart($v)
	{
		// we treat '' as NULL for temporal objects because DateTime('') == DateTime('now')
		// -- which is unexpected, to say the least.
		if ($v === null || $v === '') {
			$dt = null;
		} elseif ($v instanceof DateTime) {
			$dt = $v;
		} else {
			// some string/numeric value passed; we normalize that so that we can
			// validate it.
			try {
				if (is_numeric($v)) { // if it's a unix timestamp
					$dt = new DateTime('@'.$v, new DateTimeZone('UTC'));
					// We have to explicitly specify and then change the time zone because of a
					// DateTime bug: http://bugs.php.net/bug.php?id=43003
					$dt->setTimeZone(new DateTimeZone(date_default_timezone_get()));
				} else {
					$dt = new DateTime($v);
				}
			} catch (Exception $x) {
				throw new PropelException('Error parsing date/time value: ' . var_export($v, true), $x);
			}
		}

		if ( $this->dt_start !== null || $dt !== null ) {
			// (nested ifs are a little easier to read in this case)

			$currNorm = ($this->dt_start !== null && $tmpDt = new DateTime($this->dt_start)) ? $tmpDt->format('Y-m-d H:i:s') : null;
			$newNorm = ($dt !== null) ? $dt->format('Y-m-d H:i:s') : null;

			if ( ($currNorm !== $newNorm) // normalized values don't match 
					)
			{
				$this->dt_start = ($dt ? $dt->format('Y-m-d H:i:s') : null);
				$this->modifiedColumns[] = LotPeer::DT_START;
			}
		} // if either are not null

		return $this;
	} // setDtStart()

	/**
	 * Sets the value of [dt_end] column to a normalized version of the date/time value specified.
	 * 
	 * @param      mixed $v string, integer (timestamp), or DateTime value.  Empty string will
	 *						be treated as NULL for temporal objects.
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setDtEnd($v)
	{
		// we treat '' as NULL for temporal objects because DateTime('') == DateTime('now')
		// -- which is unexpected, to say the least.
		if ($v === null || $v === '') {
			$dt = null;
		} elseif ($v instanceof DateTime) {
			$dt = $v;
		} else {
			// some string/numeric value passed; we normalize that so that we can
			// validate it.
			try {
				if (is_numeric($v)) { // if it's a unix timestamp
					$dt = new DateTime('@'.$v, new DateTimeZone('UTC'));
					// We have to explicitly specify and then change the time zone because of a
					// DateTime bug: http://bugs.php.net/bug.php?id=43003
					$dt->setTimeZone(new DateTimeZone(date_default_timezone_get()));
				} else {
					$dt = new DateTime($v);
				}
			} catch (Exception $x) {
				throw new PropelException('Error parsing date/time value: ' . var_export($v, true), $x);
			}
		}

		if ( $this->dt_end !== null || $dt !== null ) {
			// (nested ifs are a little easier to read in this case)

			$currNorm = ($this->dt_end !== null && $tmpDt = new DateTime($this->dt_end)) ? $tmpDt->format('Y-m-d H:i:s') : null;
			$newNorm = ($dt !== null) ? $dt->format('Y-m-d H:i:s') : null;

			if ( ($currNorm !== $newNorm) // normalized values don't match 
					)
			{
				$this->dt_end = ($dt ? $dt->format('Y-m-d H:i:s') : null);
				$this->modifiedColumns[] = LotPeer::DT_END;
			}
		} // if either are not null

		return $this;
	} // setDtEnd()

	/**
	 * Sets the value of [dt_autobet] column to a normalized version of the date/time value specified.
	 * 
	 * @param      mixed $v string, integer (timestamp), or DateTime value.  Empty string will
	 *						be treated as NULL for temporal objects.
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setDtAutobet($v)
	{
		// we treat '' as NULL for temporal objects because DateTime('') == DateTime('now')
		// -- which is unexpected, to say the least.
		if ($v === null || $v === '') {
			$dt = null;
		} elseif ($v instanceof DateTime) {
			$dt = $v;
		} else {
			// some string/numeric value passed; we normalize that so that we can
			// validate it.
			try {
				if (is_numeric($v)) { // if it's a unix timestamp
					$dt = new DateTime('@'.$v, new DateTimeZone('UTC'));
					// We have to explicitly specify and then change the time zone because of a
					// DateTime bug: http://bugs.php.net/bug.php?id=43003
					$dt->setTimeZone(new DateTimeZone(date_default_timezone_get()));
				} else {
					$dt = new DateTime($v);
				}
			} catch (Exception $x) {
				throw new PropelException('Error parsing date/time value: ' . var_export($v, true), $x);
			}
		}

		if ( $this->dt_autobet !== null || $dt !== null ) {
			// (nested ifs are a little easier to read in this case)

			$currNorm = ($this->dt_autobet !== null && $tmpDt = new DateTime($this->dt_autobet)) ? $tmpDt->format('Y-m-d H:i:s') : null;
			$newNorm = ($dt !== null) ? $dt->format('Y-m-d H:i:s') : null;

			if ( ($currNorm !== $newNorm) // normalized values don't match 
					)
			{
				$this->dt_autobet = ($dt ? $dt->format('Y-m-d H:i:s') : null);
				$this->modifiedColumns[] = LotPeer::DT_AUTOBET;
			}
		} // if either are not null

		return $this;
	} // setDtAutobet()

	/**
	 * Set the value of [is_closed] column.
	 * 
	 * @param      boolean $v new value
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setIsClosed($v)
	{
		if ($v !== null) {
			$v = (boolean) $v;
		}

		if ($this->is_closed !== $v) {
			$this->is_closed = $v;
			$this->modifiedColumns[] = LotPeer::IS_CLOSED;
		}

		return $this;
	} // setIsClosed()

	/**
	 * Set the value of [price] column.
	 * 
	 * @param      int $v new value
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setPrice($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->price !== $v) {
			$this->price = $v;
			$this->modifiedColumns[] = LotPeer::PRICE;
		}

		return $this;
	} // setPrice()

	/**
	 * Set the value of [user] column.
	 * 
	 * @param      string $v new value
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setUser($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->user !== $v) {
			$this->user = $v;
			$this->modifiedColumns[] = LotPeer::USER;
		}

		return $this;
	} // setUser()

	/**
	 * Set the value of [bet_last_id] column.
	 * 
	 * @param      int $v new value
	 * @return     Lot The current object (for fluent API support)
	 */
	public function setBetLastId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->bet_last_id !== $v) {
			$this->bet_last_id = $v;
			$this->modifiedColumns[] = LotPeer::BET_LAST_ID;
		}

		if ($this->aBet !== null && $this->aBet->getId() !== $v) {
			$this->aBet = null;
		}

		return $this;
	} // setBetLastId()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->auction_type_id = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
			$this->product_id = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
			$this->dt_start = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
			$this->dt_end = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
			$this->dt_autobet = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
			$this->is_closed = ($row[$startcol + 6] !== null) ? (boolean) $row[$startcol + 6] : null;
			$this->price = ($row[$startcol + 7] !== null) ? (int) $row[$startcol + 7] : null;
			$this->user = ($row[$startcol + 8] !== null) ? (string) $row[$startcol + 8] : null;
			$this->bet_last_id = ($row[$startcol + 9] !== null) ? (int) $row[$startcol + 9] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 10; // 10 = LotPeer::NUM_COLUMNS - LotPeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating Lot object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

		if ($this->aAuctionType !== null && $this->auction_type_id !== $this->aAuctionType->getId()) {
			$this->aAuctionType = null;
		}
		if ($this->aProduct !== null && $this->product_id !== $this->aProduct->getId()) {
			$this->aProduct = null;
		}
		if ($this->aBet !== null && $this->bet_last_id !== $this->aBet->getId()) {
			$this->aBet = null;
		}
	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(LotPeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = LotPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->aAuctionType = null;
			$this->aProduct = null;
			$this->aBet = null;
			$this->collBetRequests = null;
			$this->lastBetRequestCriteria = null;

			$this->collLotAuctionOptions = null;
			$this->lastLotAuctionOptionCriteria = null;

			$this->collLotAutobets = null;
			$this->lastLotAutobetCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BaseLot:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(LotPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			LotPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseLot:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BaseLot:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(LotPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
    foreach (sfMixer::getCallables('BaseLot:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			LotPeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			// We call the save method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aAuctionType !== null) {
				if ($this->aAuctionType->isModified() || $this->aAuctionType->isNew()) {
					$affectedRows += $this->aAuctionType->save($con);
				}
				$this->setAuctionType($this->aAuctionType);
			}

			if ($this->aProduct !== null) {
				if ($this->aProduct->isModified() || $this->aProduct->isNew()) {
					$affectedRows += $this->aProduct->save($con);
				}
				$this->setProduct($this->aProduct);
			}

			if ($this->aBet !== null) {
				if ($this->aBet->isModified() || $this->aBet->isNew()) {
					$affectedRows += $this->aBet->save($con);
				}
				$this->setBet($this->aBet);
			}

			if ($this->isNew() ) {
				$this->modifiedColumns[] = LotPeer::ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = LotPeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += LotPeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collBetRequests !== null) {
				foreach ($this->collBetRequests as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collLotAuctionOptions !== null) {
				foreach ($this->collLotAuctionOptions as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collLotAutobets !== null) {
				foreach ($this->collLotAutobets as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			// We call the validate method on the following object(s) if they
			// were passed to this object by their coresponding set
			// method.  This object relates to these object(s) by a
			// foreign key reference.

			if ($this->aAuctionType !== null) {
				if (!$this->aAuctionType->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aAuctionType->getValidationFailures());
				}
			}

			if ($this->aProduct !== null) {
				if (!$this->aProduct->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProduct->getValidationFailures());
				}
			}

			if ($this->aBet !== null) {
				if (!$this->aBet->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aBet->getValidationFailures());
				}
			}


			if (($retval = LotPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collBetRequests !== null) {
					foreach ($this->collBetRequests as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collLotAuctionOptions !== null) {
					foreach ($this->collLotAuctionOptions as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collLotAutobets !== null) {
					foreach ($this->collLotAutobets as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = LotPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getAuctionTypeId();
				break;
			case 2:
				return $this->getProductId();
				break;
			case 3:
				return $this->getDtStart();
				break;
			case 4:
				return $this->getDtEnd();
				break;
			case 5:
				return $this->getDtAutobet();
				break;
			case 6:
				return $this->getIsClosed();
				break;
			case 7:
				return $this->getPrice();
				break;
			case 8:
				return $this->getUser();
				break;
			case 9:
				return $this->getBetLastId();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = LotPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getAuctionTypeId(),
			$keys[2] => $this->getProductId(),
			$keys[3] => $this->getDtStart(),
			$keys[4] => $this->getDtEnd(),
			$keys[5] => $this->getDtAutobet(),
			$keys[6] => $this->getIsClosed(),
			$keys[7] => $this->getPrice(),
			$keys[8] => $this->getUser(),
			$keys[9] => $this->getBetLastId(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = LotPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setAuctionTypeId($value);
				break;
			case 2:
				$this->setProductId($value);
				break;
			case 3:
				$this->setDtStart($value);
				break;
			case 4:
				$this->setDtEnd($value);
				break;
			case 5:
				$this->setDtAutobet($value);
				break;
			case 6:
				$this->setIsClosed($value);
				break;
			case 7:
				$this->setPrice($value);
				break;
			case 8:
				$this->setUser($value);
				break;
			case 9:
				$this->setBetLastId($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = LotPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setAuctionTypeId($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setProductId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setDtStart($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setDtEnd($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setDtAutobet($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setIsClosed($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setPrice($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setUser($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setBetLastId($arr[$keys[9]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(LotPeer::DATABASE_NAME);

		if ($this->isColumnModified(LotPeer::ID)) $criteria->add(LotPeer::ID, $this->id);
		if ($this->isColumnModified(LotPeer::AUCTION_TYPE_ID)) $criteria->add(LotPeer::AUCTION_TYPE_ID, $this->auction_type_id);
		if ($this->isColumnModified(LotPeer::PRODUCT_ID)) $criteria->add(LotPeer::PRODUCT_ID, $this->product_id);
		if ($this->isColumnModified(LotPeer::DT_START)) $criteria->add(LotPeer::DT_START, $this->dt_start);
		if ($this->isColumnModified(LotPeer::DT_END)) $criteria->add(LotPeer::DT_END, $this->dt_end);
		if ($this->isColumnModified(LotPeer::DT_AUTOBET)) $criteria->add(LotPeer::DT_AUTOBET, $this->dt_autobet);
		if ($this->isColumnModified(LotPeer::IS_CLOSED)) $criteria->add(LotPeer::IS_CLOSED, $this->is_closed);
		if ($this->isColumnModified(LotPeer::PRICE)) $criteria->add(LotPeer::PRICE, $this->price);
		if ($this->isColumnModified(LotPeer::USER)) $criteria->add(LotPeer::USER, $this->user);
		if ($this->isColumnModified(LotPeer::BET_LAST_ID)) $criteria->add(LotPeer::BET_LAST_ID, $this->bet_last_id);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(LotPeer::DATABASE_NAME);

		$criteria->add(LotPeer::ID, $this->id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	/**
	 * Generic method to set the primary key (id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of Lot (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setAuctionTypeId($this->auction_type_id);

		$copyObj->setProductId($this->product_id);

		$copyObj->setDtStart($this->dt_start);

		$copyObj->setDtEnd($this->dt_end);

		$copyObj->setDtAutobet($this->dt_autobet);

		$copyObj->setIsClosed($this->is_closed);

		$copyObj->setPrice($this->price);

		$copyObj->setUser($this->user);

		$copyObj->setBetLastId($this->bet_last_id);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getBetRequests() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addBetRequest($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getLotAuctionOptions() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addLotAuctionOption($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getLotAutobets() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addLotAutobet($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     Lot Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     LotPeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new LotPeer();
		}
		return self::$peer;
	}

	/**
	 * Declares an association between this object and a AuctionType object.
	 *
	 * @param      AuctionType $v
	 * @return     Lot The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setAuctionType(AuctionType $v = null)
	{
		if ($v === null) {
			$this->setAuctionTypeId(NULL);
		} else {
			$this->setAuctionTypeId($v->getId());
		}

		$this->aAuctionType = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the AuctionType object, it will not be re-added.
		if ($v !== null) {
			$v->addLot($this);
		}

		return $this;
	}


	/**
	 * Get the associated AuctionType object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     AuctionType The associated AuctionType object.
	 * @throws     PropelException
	 */
	public function getAuctionType(PropelPDO $con = null)
	{
		if ($this->aAuctionType === null && ($this->auction_type_id !== null)) {
			$c = new Criteria(AuctionTypePeer::DATABASE_NAME);
			$c->add(AuctionTypePeer::ID, $this->auction_type_id);
			$this->aAuctionType = AuctionTypePeer::doSelectOne($c, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aAuctionType->addLots($this);
			 */
		}
		return $this->aAuctionType;
	}

	/**
	 * Declares an association between this object and a Product object.
	 *
	 * @param      Product $v
	 * @return     Lot The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setProduct(Product $v = null)
	{
		if ($v === null) {
			$this->setProductId(NULL);
		} else {
			$this->setProductId($v->getId());
		}

		$this->aProduct = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Product object, it will not be re-added.
		if ($v !== null) {
			$v->addLot($this);
		}

		return $this;
	}


	/**
	 * Get the associated Product object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Product The associated Product object.
	 * @throws     PropelException
	 */
	public function getProduct(PropelPDO $con = null)
	{
		if ($this->aProduct === null && ($this->product_id !== null)) {
			$c = new Criteria(ProductPeer::DATABASE_NAME);
			$c->add(ProductPeer::ID, $this->product_id);
			$this->aProduct = ProductPeer::doSelectOne($c, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aProduct->addLots($this);
			 */
		}
		return $this->aProduct;
	}

	/**
	 * Declares an association between this object and a Bet object.
	 *
	 * @param      Bet $v
	 * @return     Lot The current object (for fluent API support)
	 * @throws     PropelException
	 */
	public function setBet(Bet $v = null)
	{
		if ($v === null) {
			$this->setBetLastId(NULL);
		} else {
			$this->setBetLastId($v->getId());
		}

		$this->aBet = $v;

		// Add binding for other direction of this n:n relationship.
		// If this object has already been added to the Bet object, it will not be re-added.
		if ($v !== null) {
			$v->addLot($this);
		}

		return $this;
	}


	/**
	 * Get the associated Bet object
	 *
	 * @param      PropelPDO Optional Connection object.
	 * @return     Bet The associated Bet object.
	 * @throws     PropelException
	 */
	public function getBet(PropelPDO $con = null)
	{
		if ($this->aBet === null && ($this->bet_last_id !== null)) {
			$c = new Criteria(BetPeer::DATABASE_NAME);
			$c->add(BetPeer::ID, $this->bet_last_id);
			$this->aBet = BetPeer::doSelectOne($c, $con);
			/* The following can be used additionally to
			   guarantee the related object contains a reference
			   to this object.  This level of coupling may, however, be
			   undesirable since it could result in an only partially populated collection
			   in the referenced object.
			   $this->aBet->addLots($this);
			 */
		}
		return $this->aBet;
	}

	/**
	 * Clears out the collBetRequests collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addBetRequests()
	 */
	public function clearBetRequests()
	{
		$this->collBetRequests = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collBetRequests collection (array).
	 *
	 * By default this just sets the collBetRequests collection to an empty array (like clearcollBetRequests());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initBetRequests()
	{
		$this->collBetRequests = array();
	}

	/**
	 * Gets an array of BetRequest objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Lot has previously been saved, it will retrieve
	 * related BetRequests from storage. If this Lot is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array BetRequest[]
	 * @throws     PropelException
	 */
	public function getBetRequests($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBetRequests === null) {
			if ($this->isNew()) {
			   $this->collBetRequests = array();
			} else {

				$criteria->add(BetRequestPeer::LOT_ID, $this->id);

				BetRequestPeer::addSelectColumns($criteria);
				$this->collBetRequests = BetRequestPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(BetRequestPeer::LOT_ID, $this->id);

				BetRequestPeer::addSelectColumns($criteria);
				if (!isset($this->lastBetRequestCriteria) || !$this->lastBetRequestCriteria->equals($criteria)) {
					$this->collBetRequests = BetRequestPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBetRequestCriteria = $criteria;
		return $this->collBetRequests;
	}

	/**
	 * Returns the number of related BetRequest objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related BetRequest objects.
	 * @throws     PropelException
	 */
	public function countBetRequests(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collBetRequests === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(BetRequestPeer::LOT_ID, $this->id);

				$count = BetRequestPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(BetRequestPeer::LOT_ID, $this->id);

				if (!isset($this->lastBetRequestCriteria) || !$this->lastBetRequestCriteria->equals($criteria)) {
					$count = BetRequestPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collBetRequests);
				}
			} else {
				$count = count($this->collBetRequests);
			}
		}
		$this->lastBetRequestCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a BetRequest object to this object
	 * through the BetRequest foreign key attribute.
	 *
	 * @param      BetRequest $l BetRequest
	 * @return     void
	 * @throws     PropelException
	 */
	public function addBetRequest(BetRequest $l)
	{
		if ($this->collBetRequests === null) {
			$this->initBetRequests();
		}
		if (!in_array($l, $this->collBetRequests, true)) { // only add it if the **same** object is not already associated
			array_push($this->collBetRequests, $l);
			$l->setLot($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Lot is new, it will return
	 * an empty collection; or if this Lot has previously
	 * been saved, it will retrieve related BetRequests from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Lot.
	 */
	public function getBetRequestsJoinsfGuardUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBetRequests === null) {
			if ($this->isNew()) {
				$this->collBetRequests = array();
			} else {

				$criteria->add(BetRequestPeer::LOT_ID, $this->id);

				$this->collBetRequests = BetRequestPeer::doSelectJoinsfGuardUser($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(BetRequestPeer::LOT_ID, $this->id);

			if (!isset($this->lastBetRequestCriteria) || !$this->lastBetRequestCriteria->equals($criteria)) {
				$this->collBetRequests = BetRequestPeer::doSelectJoinsfGuardUser($criteria, $con, $join_behavior);
			}
		}
		$this->lastBetRequestCriteria = $criteria;

		return $this->collBetRequests;
	}

	/**
	 * Clears out the collLotAuctionOptions collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addLotAuctionOptions()
	 */
	public function clearLotAuctionOptions()
	{
		$this->collLotAuctionOptions = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collLotAuctionOptions collection (array).
	 *
	 * By default this just sets the collLotAuctionOptions collection to an empty array (like clearcollLotAuctionOptions());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initLotAuctionOptions()
	{
		$this->collLotAuctionOptions = array();
	}

	/**
	 * Gets an array of LotAuctionOption objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Lot has previously been saved, it will retrieve
	 * related LotAuctionOptions from storage. If this Lot is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array LotAuctionOption[]
	 * @throws     PropelException
	 */
	public function getLotAuctionOptions($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLotAuctionOptions === null) {
			if ($this->isNew()) {
			   $this->collLotAuctionOptions = array();
			} else {

				$criteria->add(LotAuctionOptionPeer::LOT_ID, $this->id);

				LotAuctionOptionPeer::addSelectColumns($criteria);
				$this->collLotAuctionOptions = LotAuctionOptionPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(LotAuctionOptionPeer::LOT_ID, $this->id);

				LotAuctionOptionPeer::addSelectColumns($criteria);
				if (!isset($this->lastLotAuctionOptionCriteria) || !$this->lastLotAuctionOptionCriteria->equals($criteria)) {
					$this->collLotAuctionOptions = LotAuctionOptionPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastLotAuctionOptionCriteria = $criteria;
		return $this->collLotAuctionOptions;
	}

	/**
	 * Returns the number of related LotAuctionOption objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related LotAuctionOption objects.
	 * @throws     PropelException
	 */
	public function countLotAuctionOptions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collLotAuctionOptions === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(LotAuctionOptionPeer::LOT_ID, $this->id);

				$count = LotAuctionOptionPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(LotAuctionOptionPeer::LOT_ID, $this->id);

				if (!isset($this->lastLotAuctionOptionCriteria) || !$this->lastLotAuctionOptionCriteria->equals($criteria)) {
					$count = LotAuctionOptionPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collLotAuctionOptions);
				}
			} else {
				$count = count($this->collLotAuctionOptions);
			}
		}
		$this->lastLotAuctionOptionCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a LotAuctionOption object to this object
	 * through the LotAuctionOption foreign key attribute.
	 *
	 * @param      LotAuctionOption $l LotAuctionOption
	 * @return     void
	 * @throws     PropelException
	 */
	public function addLotAuctionOption(LotAuctionOption $l)
	{
		if ($this->collLotAuctionOptions === null) {
			$this->initLotAuctionOptions();
		}
		if (!in_array($l, $this->collLotAuctionOptions, true)) { // only add it if the **same** object is not already associated
			array_push($this->collLotAuctionOptions, $l);
			$l->setLot($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Lot is new, it will return
	 * an empty collection; or if this Lot has previously
	 * been saved, it will retrieve related LotAuctionOptions from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Lot.
	 */
	public function getLotAuctionOptionsJoinAuctionOption($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLotAuctionOptions === null) {
			if ($this->isNew()) {
				$this->collLotAuctionOptions = array();
			} else {

				$criteria->add(LotAuctionOptionPeer::LOT_ID, $this->id);

				$this->collLotAuctionOptions = LotAuctionOptionPeer::doSelectJoinAuctionOption($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(LotAuctionOptionPeer::LOT_ID, $this->id);

			if (!isset($this->lastLotAuctionOptionCriteria) || !$this->lastLotAuctionOptionCriteria->equals($criteria)) {
				$this->collLotAuctionOptions = LotAuctionOptionPeer::doSelectJoinAuctionOption($criteria, $con, $join_behavior);
			}
		}
		$this->lastLotAuctionOptionCriteria = $criteria;

		return $this->collLotAuctionOptions;
	}

	/**
	 * Clears out the collLotAutobets collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addLotAutobets()
	 */
	public function clearLotAutobets()
	{
		$this->collLotAutobets = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collLotAutobets collection (array).
	 *
	 * By default this just sets the collLotAutobets collection to an empty array (like clearcollLotAutobets());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initLotAutobets()
	{
		$this->collLotAutobets = array();
	}

	/**
	 * Gets an array of LotAutobet objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this Lot has previously been saved, it will retrieve
	 * related LotAutobets from storage. If this Lot is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array LotAutobet[]
	 * @throws     PropelException
	 */
	public function getLotAutobets($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLotAutobets === null) {
			if ($this->isNew()) {
			   $this->collLotAutobets = array();
			} else {

				$criteria->add(LotAutobetPeer::LOT_ID, $this->id);

				LotAutobetPeer::addSelectColumns($criteria);
				$this->collLotAutobets = LotAutobetPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(LotAutobetPeer::LOT_ID, $this->id);

				LotAutobetPeer::addSelectColumns($criteria);
				if (!isset($this->lastLotAutobetCriteria) || !$this->lastLotAutobetCriteria->equals($criteria)) {
					$this->collLotAutobets = LotAutobetPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastLotAutobetCriteria = $criteria;
		return $this->collLotAutobets;
	}

	/**
	 * Returns the number of related LotAutobet objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related LotAutobet objects.
	 * @throws     PropelException
	 */
	public function countLotAutobets(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collLotAutobets === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(LotAutobetPeer::LOT_ID, $this->id);

				$count = LotAutobetPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(LotAutobetPeer::LOT_ID, $this->id);

				if (!isset($this->lastLotAutobetCriteria) || !$this->lastLotAutobetCriteria->equals($criteria)) {
					$count = LotAutobetPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collLotAutobets);
				}
			} else {
				$count = count($this->collLotAutobets);
			}
		}
		$this->lastLotAutobetCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a LotAutobet object to this object
	 * through the LotAutobet foreign key attribute.
	 *
	 * @param      LotAutobet $l LotAutobet
	 * @return     void
	 * @throws     PropelException
	 */
	public function addLotAutobet(LotAutobet $l)
	{
		if ($this->collLotAutobets === null) {
			$this->initLotAutobets();
		}
		if (!in_array($l, $this->collLotAutobets, true)) { // only add it if the **same** object is not already associated
			array_push($this->collLotAutobets, $l);
			$l->setLot($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this Lot is new, it will return
	 * an empty collection; or if this Lot has previously
	 * been saved, it will retrieve related LotAutobets from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in Lot.
	 */
	public function getLotAutobetsJoinsfGuardUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(LotPeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLotAutobets === null) {
			if ($this->isNew()) {
				$this->collLotAutobets = array();
			} else {

				$criteria->add(LotAutobetPeer::LOT_ID, $this->id);

				$this->collLotAutobets = LotAutobetPeer::doSelectJoinsfGuardUser($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(LotAutobetPeer::LOT_ID, $this->id);

			if (!isset($this->lastLotAutobetCriteria) || !$this->lastLotAutobetCriteria->equals($criteria)) {
				$this->collLotAutobets = LotAutobetPeer::doSelectJoinsfGuardUser($criteria, $con, $join_behavior);
			}
		}
		$this->lastLotAutobetCriteria = $criteria;

		return $this->collLotAutobets;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collBetRequests) {
				foreach ((array) $this->collBetRequests as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collLotAuctionOptions) {
				foreach ((array) $this->collLotAuctionOptions as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collLotAutobets) {
				foreach ((array) $this->collLotAutobets as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collBetRequests = null;
		$this->collLotAuctionOptions = null;
		$this->collLotAutobets = null;
			$this->aAuctionType = null;
			$this->aProduct = null;
			$this->aBet = null;
	}


  public function __call($method, $arguments)
  {
    if (!$callable = sfMixer::getCallable('BaseLot:'.$method))
    {
      throw new sfException(sprintf('Call to undefined method BaseLot::%s', $method));
    }

    array_unshift($arguments, $this);

    return call_user_func_array($callable, $arguments);
  }


} // BaseLot
