<?php

/**
 * Base class that represents a row from the 'auction_type' table.
 *
 * 
 *
 * This class was autogenerated by Propel 1.3.0-dev on:
 *
 * 04/06/09 03:38:48
 *
 * @package    lib.model.om
 */
abstract class BaseAuctionType extends BaseObject  implements Persistent {


  const PEER = 'AuctionTypePeer';

	/**
	 * The Peer class.
	 * Instance provides a convenient way of calling static methods on a class
	 * that calling code may not be able to identify.
	 * @var        AuctionTypePeer
	 */
	protected static $peer;

	/**
	 * The value for the id field.
	 * @var        int
	 */
	protected $id;

	/**
	 * The value for the title field.
	 * @var        string
	 */
	protected $title;

	/**
	 * @var        array AuctionBetType[] Collection to store aggregation of AuctionBetType objects.
	 */
	protected $collAuctionBetTypes;

	/**
	 * @var        Criteria The criteria used to select the current contents of collAuctionBetTypes.
	 */
	private $lastAuctionBetTypeCriteria = null;

	/**
	 * @var        array AuctionOption[] Collection to store aggregation of AuctionOption objects.
	 */
	protected $collAuctionOptions;

	/**
	 * @var        Criteria The criteria used to select the current contents of collAuctionOptions.
	 */
	private $lastAuctionOptionCriteria = null;

	/**
	 * @var        array Lot[] Collection to store aggregation of Lot objects.
	 */
	protected $collLots;

	/**
	 * @var        Criteria The criteria used to select the current contents of collLots.
	 */
	private $lastLotCriteria = null;

	/**
	 * Flag to prevent endless save loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInSave = false;

	/**
	 * Flag to prevent endless validation loop, if this object is referenced
	 * by another object which falls in this transaction.
	 * @var        boolean
	 */
	protected $alreadyInValidation = false;

	/**
	 * Initializes internal state of BaseAuctionType object.
	 * @see        applyDefaults()
	 */
	public function __construct()
	{
		parent::__construct();
		$this->applyDefaultValues();
	}

	/**
	 * Applies default values to this object.
	 * This method should be called from the object's constructor (or
	 * equivalent initialization method).
	 * @see        __construct()
	 */
	public function applyDefaultValues()
	{
	}

	/**
	 * Get the [id] column value.
	 * 
	 * @return     int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * Get the [title] column value.
	 * 
	 * @return     string
	 */
	public function getTitle()
	{
		return $this->title;
	}

	/**
	 * Set the value of [id] column.
	 * 
	 * @param      int $v new value
	 * @return     AuctionType The current object (for fluent API support)
	 */
	public function setId($v)
	{
		if ($v !== null) {
			$v = (int) $v;
		}

		if ($this->id !== $v) {
			$this->id = $v;
			$this->modifiedColumns[] = AuctionTypePeer::ID;
		}

		return $this;
	} // setId()

	/**
	 * Set the value of [title] column.
	 * 
	 * @param      string $v new value
	 * @return     AuctionType The current object (for fluent API support)
	 */
	public function setTitle($v)
	{
		if ($v !== null) {
			$v = (string) $v;
		}

		if ($this->title !== $v) {
			$this->title = $v;
			$this->modifiedColumns[] = AuctionTypePeer::TITLE;
		}

		return $this;
	} // setTitle()

	/**
	 * Indicates whether the columns in this object are only set to default values.
	 *
	 * This method can be used in conjunction with isModified() to indicate whether an object is both
	 * modified _and_ has some values set which are non-default.
	 *
	 * @return     boolean Whether the columns in this object are only been set with default values.
	 */
	public function hasOnlyDefaultValues()
	{
			// First, ensure that we don't have any columns that have been modified which aren't default columns.
			if (array_diff($this->modifiedColumns, array())) {
				return false;
			}

		// otherwise, everything was equal, so return TRUE
		return true;
	} // hasOnlyDefaultValues()

	/**
	 * Hydrates (populates) the object variables with values from the database resultset.
	 *
	 * An offset (0-based "start column") is specified so that objects can be hydrated
	 * with a subset of the columns in the resultset rows.  This is needed, for example,
	 * for results of JOIN queries where the resultset row includes columns from two or
	 * more tables.
	 *
	 * @param      array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
	 * @param      int $startcol 0-based offset column which indicates which restultset column to start with.
	 * @param      boolean $rehydrate Whether this object is being re-hydrated from the database.
	 * @return     int next starting column
	 * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
	 */
	public function hydrate($row, $startcol = 0, $rehydrate = false)
	{
		try {

			$this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
			$this->title = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
			$this->resetModified();

			$this->setNew(false);

			if ($rehydrate) {
				$this->ensureConsistency();
			}

			// FIXME - using NUM_COLUMNS may be clearer.
			return $startcol + 2; // 2 = AuctionTypePeer::NUM_COLUMNS - AuctionTypePeer::NUM_LAZY_LOAD_COLUMNS).

		} catch (Exception $e) {
			throw new PropelException("Error populating AuctionType object", $e);
		}
	}

	/**
	 * Checks and repairs the internal consistency of the object.
	 *
	 * This method is executed after an already-instantiated object is re-hydrated
	 * from the database.  It exists to check any foreign keys to make sure that
	 * the objects related to the current object are correct based on foreign key.
	 *
	 * You can override this method in the stub class, but you should always invoke
	 * the base method from the overridden method (i.e. parent::ensureConsistency()),
	 * in case your model changes.
	 *
	 * @throws     PropelException
	 */
	public function ensureConsistency()
	{

	} // ensureConsistency

	/**
	 * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
	 *
	 * This will only work if the object has been saved and has a valid primary key set.
	 *
	 * @param      boolean $deep (optional) Whether to also de-associated any related objects.
	 * @param      PropelPDO $con (optional) The PropelPDO connection to use.
	 * @return     void
	 * @throws     PropelException - if this object is deleted, unsaved or doesn't have pk match in db
	 */
	public function reload($deep = false, PropelPDO $con = null)
	{
		if ($this->isDeleted()) {
			throw new PropelException("Cannot reload a deleted object.");
		}

		if ($this->isNew()) {
			throw new PropelException("Cannot reload an unsaved object.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AuctionTypePeer::DATABASE_NAME, Propel::CONNECTION_READ);
		}

		// We don't need to alter the object instance pool; we're just modifying this instance
		// already in the pool.

		$stmt = AuctionTypePeer::doSelectStmt($this->buildPkeyCriteria(), $con);
		$row = $stmt->fetch(PDO::FETCH_NUM);
		$stmt->closeCursor();
		if (!$row) {
			throw new PropelException('Cannot find matching row in the database to reload object values.');
		}
		$this->hydrate($row, 0, true); // rehydrate

		if ($deep) {  // also de-associate any related objects?

			$this->collAuctionBetTypes = null;
			$this->lastAuctionBetTypeCriteria = null;

			$this->collAuctionOptions = null;
			$this->lastAuctionOptionCriteria = null;

			$this->collLots = null;
			$this->lastLotCriteria = null;

		} // if (deep)
	}

	/**
	 * Removes this object from datastore and sets delete attribute.
	 *
	 * @param      PropelPDO $con
	 * @return     void
	 * @throws     PropelException
	 * @see        BaseObject::setDeleted()
	 * @see        BaseObject::isDeleted()
	 */
	public function delete(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BaseAuctionType:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AuctionTypePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			AuctionTypePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseAuctionType:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	/**
	 * Persists this object to the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All modified related objects will also be persisted in the doSave()
	 * method.  This method wraps all precipitate database operations in a
	 * single transaction.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        doSave()
	 */
	public function save(PropelPDO $con = null)
	{

    foreach (sfMixer::getCallables('BaseAuctionType:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AuctionTypePeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
		}
		
		$con->beginTransaction();
		try {
			$affectedRows = $this->doSave($con);
			$con->commit();
    foreach (sfMixer::getCallables('BaseAuctionType:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			AuctionTypePeer::addInstanceToPool($this);
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollBack();
			throw $e;
		}
	}

	/**
	 * Performs the work of inserting or updating the row in the database.
	 *
	 * If the object is new, it inserts it; otherwise an update is performed.
	 * All related objects are also updated in this method.
	 *
	 * @param      PropelPDO $con
	 * @return     int The number of rows affected by this insert/update and any referring fk objects' save() operations.
	 * @throws     PropelException
	 * @see        save()
	 */
	protected function doSave(PropelPDO $con)
	{
		$affectedRows = 0; // initialize var to track total num of affected rows
		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;

			if ($this->isNew() ) {
				$this->modifiedColumns[] = AuctionTypePeer::ID;
			}

			// If this object has been modified, then save it to the database.
			if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = AuctionTypePeer::doInsert($this, $con);
					$affectedRows += 1; // we are assuming that there is only 1 row per doInsert() which
										 // should always be true here (even though technically
										 // BasePeer::doInsert() can insert multiple rows).

					$this->setId($pk);  //[IMV] update autoincrement primary key

					$this->setNew(false);
				} else {
					$affectedRows += AuctionTypePeer::doUpdate($this, $con);
				}

				$this->resetModified(); // [HL] After being saved an object is no longer 'modified'
			}

			if ($this->collAuctionBetTypes !== null) {
				foreach ($this->collAuctionBetTypes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collAuctionOptions !== null) {
				foreach ($this->collAuctionOptions as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collLots !== null) {
				foreach ($this->collLots as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;

		}
		return $affectedRows;
	} // doSave()

	/**
	 * Array of ValidationFailed objects.
	 * @var        array ValidationFailed[]
	 */
	protected $validationFailures = array();

	/**
	 * Gets any ValidationFailed objects that resulted from last call to validate().
	 *
	 *
	 * @return     array ValidationFailed[]
	 * @see        validate()
	 */
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	/**
	 * Validates the objects modified field values and all objects related to this table.
	 *
	 * If $columns is either a column name or an array of column names
	 * only those columns are validated.
	 *
	 * @param      mixed $columns Column name or an array of column names.
	 * @return     boolean Whether all columns pass validation.
	 * @see        doValidate()
	 * @see        getValidationFailures()
	 */
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	/**
	 * This function performs the validation work for complex object models.
	 *
	 * In addition to checking the current object, all related objects will
	 * also be validated.  If all pass then <code>true</code> is returned; otherwise
	 * an aggreagated array of ValidationFailed objects will be returned.
	 *
	 * @param      array $columns Array of column names to validate.
	 * @return     mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
	 */
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = AuctionTypePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collAuctionBetTypes !== null) {
					foreach ($this->collAuctionBetTypes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collAuctionOptions !== null) {
					foreach ($this->collAuctionOptions as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collLots !== null) {
					foreach ($this->collLots as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	/**
	 * Retrieves a field from the object by name passed in as a string.
	 *
	 * @param      string $name name
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     mixed Value of field.
	 */
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AuctionTypePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		$field = $this->getByPosition($pos);
		return $field;
	}

	/**
	 * Retrieves a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @return     mixed Value of field at $pos
	 */
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getTitle();
				break;
			default:
				return null;
				break;
		} // switch()
	}

	/**
	 * Exports the object as an array.
	 *
	 * You can specify the key type of the array by passing one of the class
	 * type constants.
	 *
	 * @param      string $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                        BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM. Defaults to BasePeer::TYPE_PHPNAME.
	 * @param      boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns.  Defaults to TRUE.
	 * @return     an associative array containing the field names (as keys) and field values
	 */
	public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true)
	{
		$keys = AuctionTypePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getTitle(),
		);
		return $result;
	}

	/**
	 * Sets a field from the object by name passed in as a string.
	 *
	 * @param      string $name peer name
	 * @param      mixed $value field value
	 * @param      string $type The type of fieldname the $name is of:
	 *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
	 *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM
	 * @return     void
	 */
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AuctionTypePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	/**
	 * Sets a field from the object by Position as specified in the xml schema.
	 * Zero-based.
	 *
	 * @param      int $pos position in xml schema
	 * @param      mixed $value field value
	 * @return     void
	 */
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setTitle($value);
				break;
		} // switch()
	}

	/**
	 * Populates the object using an array.
	 *
	 * This is particularly useful when populating an object from one of the
	 * request arrays (e.g. $_POST).  This method goes through the column
	 * names, checking to see whether a matching key exists in populated
	 * array. If so the setByName() method is called for that column.
	 *
	 * You can specify the key type of the array by additionally passing one
	 * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
	 * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
	 * The default key type is the column's phpname (e.g. 'AuthorId')
	 *
	 * @param      array  $arr     An array to populate the object from.
	 * @param      string $keyType The type of keys the array uses.
	 * @return     void
	 */
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AuctionTypePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setTitle($arr[$keys[1]]);
	}

	/**
	 * Build a Criteria object containing the values of all modified columns in this object.
	 *
	 * @return     Criteria The Criteria object containing all modified values.
	 */
	public function buildCriteria()
	{
		$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);

		if ($this->isColumnModified(AuctionTypePeer::ID)) $criteria->add(AuctionTypePeer::ID, $this->id);
		if ($this->isColumnModified(AuctionTypePeer::TITLE)) $criteria->add(AuctionTypePeer::TITLE, $this->title);

		return $criteria;
	}

	/**
	 * Builds a Criteria object containing the primary key for this object.
	 *
	 * Unlike buildCriteria() this method includes the primary key values regardless
	 * of whether or not they have been modified.
	 *
	 * @return     Criteria The Criteria object containing value(s) for primary key(s).
	 */
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);

		$criteria->add(AuctionTypePeer::ID, $this->id);

		return $criteria;
	}

	/**
	 * Returns the primary key for this object (row).
	 * @return     int
	 */
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	/**
	 * Generic method to set the primary key (id column).
	 *
	 * @param      int $key Primary key.
	 * @return     void
	 */
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	/**
	 * Sets contents of passed object to values from current object.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      object $copyObj An object of AuctionType (or compatible) type.
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @throws     PropelException
	 */
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setTitle($this->title);


		if ($deepCopy) {
			// important: temporarily setNew(false) because this affects the behavior of
			// the getter/setter methods for fkey referrer objects.
			$copyObj->setNew(false);

			foreach ($this->getAuctionBetTypes() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addAuctionBetType($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getAuctionOptions() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addAuctionOption($relObj->copy($deepCopy));
				}
			}

			foreach ($this->getLots() as $relObj) {
				if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
					$copyObj->addLot($relObj->copy($deepCopy));
				}
			}

		} // if ($deepCopy)


		$copyObj->setNew(true);

		$copyObj->setId(NULL); // this is a auto-increment column, so set to default value

	}

	/**
	 * Makes a copy of this object that will be inserted as a new row in table when saved.
	 * It creates a new object filling in the simple attributes, but skipping any primary
	 * keys that are defined for the table.
	 *
	 * If desired, this method can also make copies of all associated (fkey referrers)
	 * objects.
	 *
	 * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
	 * @return     AuctionType Clone of current object.
	 * @throws     PropelException
	 */
	public function copy($deepCopy = false)
	{
		// we use get_class(), because this might be a subclass
		$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	/**
	 * Returns a peer instance associated with this om.
	 *
	 * Since Peer classes are not to have any instance attributes, this method returns the
	 * same instance for all member of this class. The method could therefore
	 * be static, but this would prevent one from overriding the behavior.
	 *
	 * @return     AuctionTypePeer
	 */
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new AuctionTypePeer();
		}
		return self::$peer;
	}

	/**
	 * Clears out the collAuctionBetTypes collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addAuctionBetTypes()
	 */
	public function clearAuctionBetTypes()
	{
		$this->collAuctionBetTypes = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collAuctionBetTypes collection (array).
	 *
	 * By default this just sets the collAuctionBetTypes collection to an empty array (like clearcollAuctionBetTypes());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initAuctionBetTypes()
	{
		$this->collAuctionBetTypes = array();
	}

	/**
	 * Gets an array of AuctionBetType objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this AuctionType has previously been saved, it will retrieve
	 * related AuctionBetTypes from storage. If this AuctionType is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array AuctionBetType[]
	 * @throws     PropelException
	 */
	public function getAuctionBetTypes($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collAuctionBetTypes === null) {
			if ($this->isNew()) {
			   $this->collAuctionBetTypes = array();
			} else {

				$criteria->add(AuctionBetTypePeer::AUCTION_TYPE_ID, $this->id);

				AuctionBetTypePeer::addSelectColumns($criteria);
				$this->collAuctionBetTypes = AuctionBetTypePeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(AuctionBetTypePeer::AUCTION_TYPE_ID, $this->id);

				AuctionBetTypePeer::addSelectColumns($criteria);
				if (!isset($this->lastAuctionBetTypeCriteria) || !$this->lastAuctionBetTypeCriteria->equals($criteria)) {
					$this->collAuctionBetTypes = AuctionBetTypePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastAuctionBetTypeCriteria = $criteria;
		return $this->collAuctionBetTypes;
	}

	/**
	 * Returns the number of related AuctionBetType objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related AuctionBetType objects.
	 * @throws     PropelException
	 */
	public function countAuctionBetTypes(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collAuctionBetTypes === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(AuctionBetTypePeer::AUCTION_TYPE_ID, $this->id);

				$count = AuctionBetTypePeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(AuctionBetTypePeer::AUCTION_TYPE_ID, $this->id);

				if (!isset($this->lastAuctionBetTypeCriteria) || !$this->lastAuctionBetTypeCriteria->equals($criteria)) {
					$count = AuctionBetTypePeer::doCount($criteria, $con);
				} else {
					$count = count($this->collAuctionBetTypes);
				}
			} else {
				$count = count($this->collAuctionBetTypes);
			}
		}
		$this->lastAuctionBetTypeCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a AuctionBetType object to this object
	 * through the AuctionBetType foreign key attribute.
	 *
	 * @param      AuctionBetType $l AuctionBetType
	 * @return     void
	 * @throws     PropelException
	 */
	public function addAuctionBetType(AuctionBetType $l)
	{
		if ($this->collAuctionBetTypes === null) {
			$this->initAuctionBetTypes();
		}
		if (!in_array($l, $this->collAuctionBetTypes, true)) { // only add it if the **same** object is not already associated
			array_push($this->collAuctionBetTypes, $l);
			$l->setAuctionType($this);
		}
	}

	/**
	 * Clears out the collAuctionOptions collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addAuctionOptions()
	 */
	public function clearAuctionOptions()
	{
		$this->collAuctionOptions = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collAuctionOptions collection (array).
	 *
	 * By default this just sets the collAuctionOptions collection to an empty array (like clearcollAuctionOptions());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initAuctionOptions()
	{
		$this->collAuctionOptions = array();
	}

	/**
	 * Gets an array of AuctionOption objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this AuctionType has previously been saved, it will retrieve
	 * related AuctionOptions from storage. If this AuctionType is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array AuctionOption[]
	 * @throws     PropelException
	 */
	public function getAuctionOptions($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collAuctionOptions === null) {
			if ($this->isNew()) {
			   $this->collAuctionOptions = array();
			} else {

				$criteria->add(AuctionOptionPeer::AUCTION_TYPE_ID, $this->id);

				AuctionOptionPeer::addSelectColumns($criteria);
				$this->collAuctionOptions = AuctionOptionPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(AuctionOptionPeer::AUCTION_TYPE_ID, $this->id);

				AuctionOptionPeer::addSelectColumns($criteria);
				if (!isset($this->lastAuctionOptionCriteria) || !$this->lastAuctionOptionCriteria->equals($criteria)) {
					$this->collAuctionOptions = AuctionOptionPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastAuctionOptionCriteria = $criteria;
		return $this->collAuctionOptions;
	}

	/**
	 * Returns the number of related AuctionOption objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related AuctionOption objects.
	 * @throws     PropelException
	 */
	public function countAuctionOptions(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collAuctionOptions === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(AuctionOptionPeer::AUCTION_TYPE_ID, $this->id);

				$count = AuctionOptionPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(AuctionOptionPeer::AUCTION_TYPE_ID, $this->id);

				if (!isset($this->lastAuctionOptionCriteria) || !$this->lastAuctionOptionCriteria->equals($criteria)) {
					$count = AuctionOptionPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collAuctionOptions);
				}
			} else {
				$count = count($this->collAuctionOptions);
			}
		}
		$this->lastAuctionOptionCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a AuctionOption object to this object
	 * through the AuctionOption foreign key attribute.
	 *
	 * @param      AuctionOption $l AuctionOption
	 * @return     void
	 * @throws     PropelException
	 */
	public function addAuctionOption(AuctionOption $l)
	{
		if ($this->collAuctionOptions === null) {
			$this->initAuctionOptions();
		}
		if (!in_array($l, $this->collAuctionOptions, true)) { // only add it if the **same** object is not already associated
			array_push($this->collAuctionOptions, $l);
			$l->setAuctionType($this);
		}
	}

	/**
	 * Clears out the collLots collection (array).
	 *
	 * This does not modify the database; however, it will remove any associated objects, causing
	 * them to be refetched by subsequent calls to accessor method.
	 *
	 * @return     void
	 * @see        addLots()
	 */
	public function clearLots()
	{
		$this->collLots = null; // important to set this to NULL since that means it is uninitialized
	}

	/**
	 * Initializes the collLots collection (array).
	 *
	 * By default this just sets the collLots collection to an empty array (like clearcollLots());
	 * however, you may wish to override this method in your stub class to provide setting appropriate
	 * to your application -- for example, setting the initial array to the values stored in database.
	 *
	 * @return     void
	 */
	public function initLots()
	{
		$this->collLots = array();
	}

	/**
	 * Gets an array of Lot objects which contain a foreign key that references this object.
	 *
	 * If this collection has already been initialized with an identical Criteria, it returns the collection.
	 * Otherwise if this AuctionType has previously been saved, it will retrieve
	 * related Lots from storage. If this AuctionType is new, it will return
	 * an empty collection or the current collection, the criteria is ignored on a new object.
	 *
	 * @param      PropelPDO $con
	 * @param      Criteria $criteria
	 * @return     array Lot[]
	 * @throws     PropelException
	 */
	public function getLots($criteria = null, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLots === null) {
			if ($this->isNew()) {
			   $this->collLots = array();
			} else {

				$criteria->add(LotPeer::AUCTION_TYPE_ID, $this->id);

				LotPeer::addSelectColumns($criteria);
				$this->collLots = LotPeer::doSelect($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return the collection.


				$criteria->add(LotPeer::AUCTION_TYPE_ID, $this->id);

				LotPeer::addSelectColumns($criteria);
				if (!isset($this->lastLotCriteria) || !$this->lastLotCriteria->equals($criteria)) {
					$this->collLots = LotPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastLotCriteria = $criteria;
		return $this->collLots;
	}

	/**
	 * Returns the number of related Lot objects.
	 *
	 * @param      Criteria $criteria
	 * @param      boolean $distinct
	 * @param      PropelPDO $con
	 * @return     int Count of related Lot objects.
	 * @throws     PropelException
	 */
	public function countLots(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
	{
		if ($criteria === null) {
			$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);
		} else {
			$criteria = clone $criteria;
		}

		if ($distinct) {
			$criteria->setDistinct();
		}

		$count = null;

		if ($this->collLots === null) {
			if ($this->isNew()) {
				$count = 0;
			} else {

				$criteria->add(LotPeer::AUCTION_TYPE_ID, $this->id);

				$count = LotPeer::doCount($criteria, $con);
			}
		} else {
			// criteria has no effect for a new object
			if (!$this->isNew()) {
				// the following code is to determine if a new query is
				// called for.  If the criteria is the same as the last
				// one, just return count of the collection.


				$criteria->add(LotPeer::AUCTION_TYPE_ID, $this->id);

				if (!isset($this->lastLotCriteria) || !$this->lastLotCriteria->equals($criteria)) {
					$count = LotPeer::doCount($criteria, $con);
				} else {
					$count = count($this->collLots);
				}
			} else {
				$count = count($this->collLots);
			}
		}
		$this->lastLotCriteria = $criteria;
		return $count;
	}

	/**
	 * Method called to associate a Lot object to this object
	 * through the Lot foreign key attribute.
	 *
	 * @param      Lot $l Lot
	 * @return     void
	 * @throws     PropelException
	 */
	public function addLot(Lot $l)
	{
		if ($this->collLots === null) {
			$this->initLots();
		}
		if (!in_array($l, $this->collLots, true)) { // only add it if the **same** object is not already associated
			array_push($this->collLots, $l);
			$l->setAuctionType($this);
		}
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this AuctionType is new, it will return
	 * an empty collection; or if this AuctionType has previously
	 * been saved, it will retrieve related Lots from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in AuctionType.
	 */
	public function getLotsJoinProduct($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLots === null) {
			if ($this->isNew()) {
				$this->collLots = array();
			} else {

				$criteria->add(LotPeer::AUCTION_TYPE_ID, $this->id);

				$this->collLots = LotPeer::doSelectJoinProduct($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(LotPeer::AUCTION_TYPE_ID, $this->id);

			if (!isset($this->lastLotCriteria) || !$this->lastLotCriteria->equals($criteria)) {
				$this->collLots = LotPeer::doSelectJoinProduct($criteria, $con, $join_behavior);
			}
		}
		$this->lastLotCriteria = $criteria;

		return $this->collLots;
	}


	/**
	 * If this collection has already been initialized with
	 * an identical criteria, it returns the collection.
	 * Otherwise if this AuctionType is new, it will return
	 * an empty collection; or if this AuctionType has previously
	 * been saved, it will retrieve related Lots from storage.
	 *
	 * This method is protected by default in order to keep the public
	 * api reasonable.  You can provide public methods for those you
	 * actually need in AuctionType.
	 */
	public function getLotsJoinBet($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
	{
		if ($criteria === null) {
			$criteria = new Criteria(AuctionTypePeer::DATABASE_NAME);
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLots === null) {
			if ($this->isNew()) {
				$this->collLots = array();
			} else {

				$criteria->add(LotPeer::AUCTION_TYPE_ID, $this->id);

				$this->collLots = LotPeer::doSelectJoinBet($criteria, $con, $join_behavior);
			}
		} else {
			// the following code is to determine if a new query is
			// called for.  If the criteria is the same as the last
			// one, just return the collection.

			$criteria->add(LotPeer::AUCTION_TYPE_ID, $this->id);

			if (!isset($this->lastLotCriteria) || !$this->lastLotCriteria->equals($criteria)) {
				$this->collLots = LotPeer::doSelectJoinBet($criteria, $con, $join_behavior);
			}
		}
		$this->lastLotCriteria = $criteria;

		return $this->collLots;
	}

	/**
	 * Resets all collections of referencing foreign keys.
	 *
	 * This method is a user-space workaround for PHP's inability to garbage collect objects
	 * with circular references.  This is currently necessary when using Propel in certain
	 * daemon or large-volumne/high-memory operations.
	 *
	 * @param      boolean $deep Whether to also clear the references on all associated objects.
	 */
	public function clearAllReferences($deep = false)
	{
		if ($deep) {
			if ($this->collAuctionBetTypes) {
				foreach ((array) $this->collAuctionBetTypes as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collAuctionOptions) {
				foreach ((array) $this->collAuctionOptions as $o) {
					$o->clearAllReferences($deep);
				}
			}
			if ($this->collLots) {
				foreach ((array) $this->collLots as $o) {
					$o->clearAllReferences($deep);
				}
			}
		} // if ($deep)

		$this->collAuctionBetTypes = null;
		$this->collAuctionOptions = null;
		$this->collLots = null;
	}


  public function __call($method, $arguments)
  {
    if (!$callable = sfMixer::getCallable('BaseAuctionType:'.$method))
    {
      throw new sfException(sprintf('Call to undefined method BaseAuctionType::%s', $method));
    }

    array_unshift($arguments, $this);

    return call_user_func_array($callable, $arguments);
  }


} // BaseAuctionType
