<?php

class Product extends BaseProduct
{
    public function __toString()
    {
        return $this->getTitle();
    }
    
    public function getCategoryTitle()
    {
        return ($category = $this->getCategory()) ? $category->getTitle() : null; 
    }
    
    public function getPriceFormatted()
    {
        return number_format($this->getPrice(), 0, ',', ' ');
    }
    
    public function save(PropelPDO $con = null)
    {
        parent::save($con);
        
        // Удаляем кеш шаблонов
//        $cacheManager = sfContext::getInstance()->getViewCacheManager();
//        
//        $lots = $this->getLots();
//        foreach ($lots as $lot)
//            $cacheManager->remove('@sf_cache_partial?module=Auction&action=_lotItem&sf_cache_key=' . $lot->getId());
        
        // Удаляем кеш данных
        sfCacheManager::removeObject('Product', $this->getId());
    }
}
