<?php

class Payment extends BasePayment
{
    private $_storedStatus = null;

    public function sendEmail($mailFrom, $mailTo, $mailSubject, $mailBody)
    {
        try {

//            $mailer = new Swift ( new Swift_Connection_Sendmail ( ) );
            $mailer = new Swift ( new Swift_Connection_NativeMail ( ) );
            $message = new Swift_Message ( $mailSubject, $mailBody, 'text/html' );

            $recipients = new Swift_RecipientList();

            if (is_array($mailTo)) {

                foreach ($mailTo as $currentMailTo)
                    $recipients->addTo($currentMailTo);

            } else {
                $recipients->addTo($mailTo);
            }

            $mailer->send ( $message, $recipients, $mailFrom );
            $mailer->disconnect ();

        } catch ( Exception $e ) {

            $mailer->disconnect ();

        }
    }

    public function getUserTitle()
    {
        return ($user = $this->getsfGuardUser()) ? $user->getUsername() : '-';
    }

    public function getPaymentTypeTitle()
    {
        return ($paymentType = $this->getPaymentType()) ? $paymentType->getTitle() : '-';
    }

    public function getBetsPackageTitle()
    {
        return ($betsPackage = $this->getBetsPackage()) ? $betsPackage->getTitle() : '-';
    }

    public function setStatus($v)
    {
        if (is_null($this->_storedStatus) && $v != $this->getStatus())
            $this->_storedStatus = $this->getStatus();

        parent::setStatus($v);
    }

    public function save(PropelPDO $con = null)
    {
        $this->clearCache();

        if (($this->isNew() && sfConfig::get('app_pay_status_complete') == $this->getStatus()) || (!is_null($this->_storedStatus) &&
             sfConfig::get('app_pay_status_incomplete') == $this->_storedStatus &&
             sfConfig::get('app_pay_status_complete') == $this->getStatus())) { // Добавление оплаченного пакета ставок

            $userBetsPackage = new UserBetsPackage();
            $userBetsPackage->setUserId($this->getUserId());
            $userBetsPackage->setBetsPackageId($this->getBetsPackageId());
            $userBetsPackage->setDtCreated(time());
            $userBetsPackage->save();

            $betsPackage = sfCacheManager::getObject('BetsPackage', $this->getBetsPackageId());
            $user = sfCacheManager::getObject('sfGuardUser', $this->getUserId());

            $mailTo = $user->getEmail();
            $mailFrom = new Swift_Address('aga@obana.by', 'ОБАНА.BY');
            $mailSubject = 'Аукционы OBANA.BY | Пакет ставок зачислен!';
            $mailBody =
'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body>
<p>Уважаемый пользователь,</p>

<p>
На Ваш счет успешно зачислено ' . $betsPackage->getBetsCountFull() . '.<br />
Следить за своим балансом Вы можете в своем <a href="http://obana/profile/account/info">личном кабинете</a>.
</p>

<p>
С уважением,<br />
Администрация проекта OBANA.BY
</p>
</body>
</html>';

//            get_partial('User/emailPayment', array('amount' => $betsPackage->getBetsCountFull()));

            $this->sendEmail($mailFrom, $mailTo, $mailSubject, $mailBody);

        }

        parent::save($con);
    }

    public function delete(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::delete($con);
    }

    private function clearCache()
    {
        // Сам объект
        sfCacheManager::removeObject('Payment', $this->getId());

        // Все списки
        sfCacheManager::removeTag('PaymentList');
    }
}
