<?php

class PartnerPayment extends BasePartnerPayment
{
    private $_monthName = array('января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря');

    public function getDtFormatted()
    {
        $dtTimestamp = strtotime($this->getDt());

        if (strtotime(strftime('%Y-%m-%d')) <= $dtTimestamp)
            return 'сегодня';
        else if (strtotime(strftime('%Y-%m-%d')) - 24*3600 <= $dtTimestamp)
            return 'вчера';
        else
            return sprintf(
                '%s %s',
                $this->getDt('j'),
                $this->_monthName[$this->getDt('n')-1]
            );
    }

    public function save(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::save($con);
    }

    public function delete(PropelPDO $con = null)
    {
        $this->clearCache();

        parent::delete($con);
    }

    private function clearCache()
    {
        // Сам объект
        sfCacheManager::removeObject('PartnerPayment', $this->getId());

        // Все списки
        sfCacheManager::removeTag('PartnerPaymentList');
    }
}
