<?php

/**
 * Lot form base class.
 *
 * @package    auction
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormGeneratedTemplate.php 12815 2008-11-09 10:43:58Z fabien $
 */
class BaseLotForm extends BaseFormPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'              => new sfWidgetFormInputHidden(),
      'auction_type_id' => new sfWidgetFormPropelChoice(array('model' => 'AuctionType', 'add_empty' => true)),
      'product_id'      => new sfWidgetFormPropelChoice(array('model' => 'Product', 'add_empty' => true)),
      'dt_start'        => new sfWidgetFormDateTime(),
      'dt_end'          => new sfWidgetFormDateTime(),
      'dt_autobet'      => new sfWidgetFormDateTime(),
      'is_closed'       => new sfWidgetFormInputCheckbox(),
      'price'           => new sfWidgetFormInput(),
      'user'            => new sfWidgetFormInput(),
      'bet_last_id'     => new sfWidgetFormPropelChoice(array('model' => 'Bet', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'id'              => new sfValidatorPropelChoice(array('model' => 'Lot', 'column' => 'id', 'required' => false)),
      'auction_type_id' => new sfValidatorPropelChoice(array('model' => 'AuctionType', 'column' => 'id', 'required' => false)),
      'product_id'      => new sfValidatorPropelChoice(array('model' => 'Product', 'column' => 'id', 'required' => false)),
      'dt_start'        => new sfValidatorDateTime(array('required' => false)),
      'dt_end'          => new sfValidatorDateTime(array('required' => false)),
      'dt_autobet'      => new sfValidatorDateTime(array('required' => false)),
      'is_closed'       => new sfValidatorBoolean(array('required' => false)),
      'price'           => new sfValidatorInteger(array('required' => false)),
      'user'            => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'bet_last_id'     => new sfValidatorPropelChoice(array('model' => 'Bet', 'column' => 'id', 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorPropelUnique(array('model' => 'Lot', 'column' => array('id')))
    );

    $this->widgetSchema->setNameFormat('lot[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Lot';
  }


}
