<?php

class AvatarForm extends sfForm
{
    public function configure()
    {
        $this->setWidgets(array(
            'file' => new sfWidgetFormInputFile()
        ));

        $this->setValidators(array(
            'file' => new sfValidatorFile(
                array(
                    'required'   => true,
                    'max_size'   => '10000000',
                    'mime_types' => 'web_images'
                )
             )
        ));

        $this->widgetSchema['file']->setLabel('Укажите файл');

        $this->validatorSchema['file']->setMessage('required', 'Поле обязательно для заполнения.');
        $this->validatorSchema['file']->setMessage('max_size', 'Максимальный размер загружаемого файла - 10 Мб.');
        $this->validatorSchema['file']->setMessage('mime_types', 'Допускается загрузка файлов следующих форматов: jpg, gif, png.');

        $this->widgetSchema->setNameFormat('avatar[%s]');
    }
}

?>