<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * PromoCodeVoucher filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BasePromoCodeVoucherFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'promo_code_id' => new sfWidgetFormPropelChoice(array('model' => 'PromoCode', 'add_empty' => true)),
      'voucher_id'    => new sfWidgetFormPropelChoice(array('model' => 'Voucher', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'promo_code_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'PromoCode', 'column' => 'id')),
      'voucher_id'    => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Voucher', 'column' => 'id')),
    ));

    $this->widgetSchema->setNameFormat('promo_code_voucher_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'PromoCodeVoucher';
  }

  public function getFields()
  {
    return array(
      'id'            => 'Number',
      'promo_code_id' => 'ForeignKey',
      'voucher_id'    => 'ForeignKey',
    );
  }
}
