<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * ProductPhoto filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BaseProductPhotoFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'product_id'     => new sfWidgetFormPropelChoice(array('model' => 'Product', 'add_empty' => true)),
      'file'           => new sfWidgetFormFilterInput(),
      'width'          => new sfWidgetFormFilterInput(),
      'height'         => new sfWidgetFormFilterInput(),
      'width_preview'  => new sfWidgetFormFilterInput(),
      'height_preview' => new sfWidgetFormFilterInput(),
      'width_thumb'    => new sfWidgetFormFilterInput(),
      'height_thumb'   => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'product_id'     => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Product', 'column' => 'id')),
      'file'           => new sfValidatorPass(array('required' => false)),
      'width'          => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'height'         => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'width_preview'  => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'height_preview' => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'width_thumb'    => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'height_thumb'   => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
    ));

    $this->widgetSchema->setNameFormat('product_photo_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'ProductPhoto';
  }

  public function getFields()
  {
    return array(
      'id'             => 'Number',
      'product_id'     => 'ForeignKey',
      'file'           => 'Text',
      'width'          => 'Number',
      'height'         => 'Number',
      'width_preview'  => 'Number',
      'height_preview' => 'Number',
      'width_thumb'    => 'Number',
      'height_thumb'   => 'Number',
    );
  }
}
