<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * Product filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BaseProductFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'category_id'       => new sfWidgetFormPropelChoice(array('model' => 'Category', 'add_empty' => true)),
      'title'             => new sfWidgetFormFilterInput(),
      'title_full'        => new sfWidgetFormFilterInput(),
      'description_short' => new sfWidgetFormFilterInput(),
      'description_full'  => new sfWidgetFormFilterInput(),
      'price'             => new sfWidgetFormFilterInput(),
      'image_main'        => new sfWidgetFormFilterInput(),
      'image_main_thumb'  => new sfWidgetFormFilterInput(),
      'image_icon'        => new sfWidgetFormFilterInput(),
      'image1'            => new sfWidgetFormFilterInput(),
      'image1_thumb'      => new sfWidgetFormFilterInput(),
      'image2'            => new sfWidgetFormFilterInput(),
      'image2_thumb'      => new sfWidgetFormFilterInput(),
      'image3'            => new sfWidgetFormFilterInput(),
      'image3_thumb'      => new sfWidgetFormFilterInput(),
      'image4'            => new sfWidgetFormFilterInput(),
      'image4_thumb'      => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'category_id'       => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Category', 'column' => 'id')),
      'title'             => new sfValidatorPass(array('required' => false)),
      'title_full'        => new sfValidatorPass(array('required' => false)),
      'description_short' => new sfValidatorPass(array('required' => false)),
      'description_full'  => new sfValidatorPass(array('required' => false)),
      'price'             => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'image_main'        => new sfValidatorPass(array('required' => false)),
      'image_main_thumb'  => new sfValidatorPass(array('required' => false)),
      'image_icon'        => new sfValidatorPass(array('required' => false)),
      'image1'            => new sfValidatorPass(array('required' => false)),
      'image1_thumb'      => new sfValidatorPass(array('required' => false)),
      'image2'            => new sfValidatorPass(array('required' => false)),
      'image2_thumb'      => new sfValidatorPass(array('required' => false)),
      'image3'            => new sfValidatorPass(array('required' => false)),
      'image3_thumb'      => new sfValidatorPass(array('required' => false)),
      'image4'            => new sfValidatorPass(array('required' => false)),
      'image4_thumb'      => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('product_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Product';
  }

  public function getFields()
  {
    return array(
      'id'                => 'Number',
      'category_id'       => 'ForeignKey',
      'title'             => 'Text',
      'title_full'        => 'Text',
      'description_short' => 'Text',
      'description_full'  => 'Text',
      'price'             => 'Number',
      'image_main'        => 'Text',
      'image_main_thumb'  => 'Text',
      'image_icon'        => 'Text',
      'image1'            => 'Text',
      'image1_thumb'      => 'Text',
      'image2'            => 'Text',
      'image2_thumb'      => 'Text',
      'image3'            => 'Text',
      'image3_thumb'      => 'Text',
      'image4'            => 'Text',
      'image4_thumb'      => 'Text',
    );
  }
}
